/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms;

import ddb.dsz.core.data.ClosureOrder;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.util.UtilityConstants;
import ds.core.impl.task.DocumentBlobAccess;
import ds.core.impl.task.TaskStateAccess;
import ds.util.datatransforms.AbstractDataTransformer;
import ds.util.datatransforms.IncompleteDataException;
import ds.util.datatransforms.PassThroughHandler;
import ds.util.datatransforms.TaskClosure;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.commons.collections.Closure;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class DataTransformerImpl2
extends AbstractDataTransformer {
    final int MAX_NODES = 1000;
    private List<ClosureInformation> closures = new Vector<ClosureInformation>();
    private static final Executor REQUEUER = Executors.newCachedThreadPool(UtilityConstants.createThreadFactory((String)"DataTransformer Requeue Thread"));

    private DataTransformerImpl2() {
    }

    private DataTransformerImpl2(boolean bl) {
        super(bl);
    }

    private DataTransformerImpl2(String string) {
        super(string);
    }

    private DataTransformerImpl2(String string, boolean bl) {
        super(string, bl);
    }

    private DataTransformerImpl2(ThreadFactory threadFactory) {
        super(threadFactory);
    }

    private DataTransformerImpl2(ThreadFactory threadFactory, boolean bl) {
        super(threadFactory, bl);
    }

    public void addClosure(Closure closure) {
        this.addClosure(closure, ClosureOrder.MIDDLE);
    }

    public void addClosure(Closure closure, ClosureOrder closureOrder) {
        this.addClosure(closure, closureOrder, null);
    }

    public void addClosure(Closure closure, ClosureOrder closureOrder, TaskDataAccess.DataType dataType) {
        ClosureInformation closureInformation = new ClosureInformation();
        closureInformation.access = dataType;
        closureInformation.closure = closure;
        closureInformation.order = closureOrder;
        this.closures.add(closureInformation);
        if (closure instanceof TaskClosure) {
            ((TaskClosure)TaskClosure.class.cast(closure)).registerTransformer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClosure(Closure closure) {
        Object object = this.TASK_LIST_LOCK;
        synchronized (object) {
            for (ClosureInformation closureInformation : this.closures) {
                if (closureInformation.closure != closure) continue;
                this.closures.remove(closureInformation);
                if (closure instanceof TaskClosure) {
                    ((TaskClosure)TaskClosure.class.cast(closure)).unregisterTransformer(this);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllClosures() {
        Object object = this.TASK_LIST_LOCK;
        synchronized (object) {
            for (ClosureInformation closureInformation : this.closures) {
                if (!(closureInformation.closure instanceof TaskClosure)) continue;
                ((TaskClosure)TaskClosure.class.cast(closureInformation.closure)).unregisterTransformer(this);
            }
            this.closures.clear();
        }
    }

    protected void execute(TaskDataAccess taskDataAccess) {
        if (!taskDataAccess.isGenerated() && taskDataAccess.getSize() > 0x100000L) {
            this.enqueChunks(taskDataAccess);
            return;
        }
        boolean bl = false;
        if (!this.execute(taskDataAccess, ClosureOrder.FIRST)) {
            bl = true;
        }
        if (!this.execute(taskDataAccess, ClosureOrder.MIDDLE)) {
            bl = true;
        }
        if (!this.execute(taskDataAccess, ClosureOrder.LAST)) {
            bl = true;
        }
        if (bl) {
            this.enqueChunks(taskDataAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(TaskDataAccess taskDataAccess, ClosureOrder closureOrder) {
        boolean bl = true;
        Vector<ClosureInformation> vector = new Vector<ClosureInformation>();
        Iterator iterator = this.TASK_LIST_LOCK;
        synchronized (iterator) {
            vector.addAll(this.closures);
        }
        for (ClosureInformation closureInformation : vector) {
            if (!closureInformation.order.equals((Object)closureOrder) || closureInformation.access != null && !closureInformation.access.equals((Object)taskDataAccess.getType())) continue;
            try {
                closureInformation.closure.execute((Object)taskDataAccess);
            }
            catch (IncompleteDataException incompleteDataException) {
                bl = false;
            }
            catch (Exception exception) {
                this.handleError(exception);
            }
        }
        return bl;
    }

    public void stop() {
        this.removeAllClosures();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleError(String string) {
        Vector<ClosureInformation> vector = new Vector<ClosureInformation>();
        Iterator iterator = this.TASK_LIST_LOCK;
        synchronized (iterator) {
            vector.addAll(this.closures);
        }
        for (ClosureInformation closureInformation : vector) {
            if (!closureInformation.order.equals((Object)ClosureOrder.ERROR)) continue;
            try {
                closureInformation.closure.execute((Object)string);
            }
            catch (Exception exception) {}
        }
    }

    private void enqueChunks(TaskDataAccess taskDataAccess) {
        if (taskDataAccess.isGenerated()) {
            return;
        }
        if (this.isOrderImportant() && taskDataAccess.getType().equals((Object)TaskDataAccess.DataType.DATA)) {
            this.executeIndirectlyWorker(taskDataAccess);
        } else {
            REQUEUER.execute(new EnqueIndirectly(taskDataAccess));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeIndirectlyWorker(final TaskDataAccess taskDataAccess) {
        if (taskDataAccess instanceof TaskStateAccess) {
            return;
        }
        if (taskDataAccess.getTask().getDataName().equalsIgnoreCase("dir") && taskDataAccess.getType().equals((Object)TaskDataAccess.DataType.DATA)) {
            this.executeIndirectlyWorker_Dir(taskDataAccess);
            return;
        }
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputStream inputStream = this.createStream(taskDataAccess);
            if (inputStream == null) {
                this.logger.log(Level.SEVERE, "Unable to open input stream for " + taskDataAccess.toString());
                return;
            }
            try {
                sAXParser.parse(inputStream, (DefaultHandler)new PassThroughHandler(null){
                    DOMResult result;
                    SAXTransformerFactory tf;
                    static final String COMMAND_DATA = "CommandData";
                    static final String COMMAND_TASKING = "CommandTasking";
                    static final String DATALOG = "DataLog";
                    String command_block;
                    int depth;
                    boolean skip2;
                    {
                        super(transformerHandler);
                        this.tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                        this.command_block = null;
                        this.depth = 0;
                        this.skip2 = true;
                    }

                    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                        if (!this.skip2) {
                            try {
                                if (this.depth == 0) {
                                    this.start(this.command_block);
                                    this.skip = false;
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            ++this.depth;
                        }
                        super.startElement(string, string2, string3, attributes);
                        if (string3.equals(COMMAND_DATA) || string3.equals(COMMAND_TASKING)) {
                            this.command_block = string3;
                            try {
                                this.skip2 = false;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }

                    public void endElement(String string, String string2, String string3) throws SAXException {
                        if (string3.equals(COMMAND_DATA) || string3.equals(COMMAND_TASKING)) {
                            this.skip = true;
                        }
                        super.endElement(string, string2, string3);
                        if (!this.skip) {
                            --this.depth;
                            if (this.depth == 0) {
                                this.finish(this.command_block);
                            }
                        }
                    }

                    private void start(String string) throws Exception {
                        this.hd = this.tf.newTransformerHandler();
                        this.result = new DOMResult();
                        this.hd.setResult(this.result);
                        this.hd.startDocument();
                        this.hd.startElement("", "", DATALOG, new AttributesImpl());
                        this.hd.startElement("", "", string, new AttributesImpl());
                    }

                    private void finish(String string) throws SAXException {
                        this.hd.endElement("", "", string);
                        this.hd.endElement("", "", DATALOG);
                        this.hd.endDocument();
                        Node node = this.result.getNode();
                        if (node instanceof Document) {
                            DataTransformerImpl2.this.requeue(new DocumentBlobAccess(taskDataAccess, (Document)node));
                        } else {
                            System.err.println("invalid result!");
                        }
                    }
                });
            }
            finally {
                inputStream.close();
            }
        }
        catch (SAXException sAXException) {
            this.handleError(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.handleError(parserConfigurationException);
        }
        catch (IOException iOException) {
            this.handleError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeIndirectlyWorker_Dir(final TaskDataAccess taskDataAccess) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputStream inputStream = this.createStream(taskDataAccess);
            if (inputStream == null) {
                this.logger.log(Level.SEVERE, "Unable to open input stream for " + taskDataAccess.toString());
                return;
            }
            try {
                sAXParser.parse(inputStream, (DefaultHandler)new PassThroughHandler(null){
                    int count;
                    DOMResult result;
                    Attributes directoryAttr;
                    Attributes directoriesAttr;
                    final SAXTransformerFactory tf;
                    static final String DIRECTORIES = "Directories";
                    static final String DIRECTORY = "Directory";
                    static final String COMMAND_DATA = "CommandData";
                    static final String COMMAND_TASKING = "CommandTasking";
                    static final String DATALOG = "DataLog";
                    {
                        super(transformerHandler);
                        this.skip = true;
                        this.count = 0;
                        this.tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                    }

                    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                        super.startElement(string, string2, string3, attributes);
                        if (string3.equals(COMMAND_DATA) || string3.equals(COMMAND_TASKING)) {
                            try {
                                this.start(string3);
                                this.skip = false;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } else if (string3.equals(DIRECTORIES)) {
                            this.directoriesAttr = new AttributesImpl(attributes);
                        } else if (string3.equals(DIRECTORY)) {
                            this.directoryAttr = new AttributesImpl(attributes);
                        }
                    }

                    public void endElement(String string, String string2, String string3) throws SAXException {
                        if (string3.equals(COMMAND_DATA) || string3.equals(COMMAND_TASKING)) {
                            this.skip = true;
                            this.finish(string3);
                        }
                        super.endElement(string, string2, string3);
                        if (string3.equals("File")) {
                            if (this.count > 1000) {
                                this.count = 0;
                                try {
                                    this.hd.endElement("", "", DIRECTORY);
                                    this.hd.endElement("", "", DIRECTORIES);
                                    this.finish(COMMAND_DATA);
                                    this.start(COMMAND_DATA);
                                    this.hd.startElement("", "", DIRECTORIES, this.directoriesAttr);
                                    this.hd.startElement("", "", DIRECTORY, this.directoryAttr);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            } else {
                                ++this.count;
                            }
                        }
                    }

                    private void start(String string) throws Exception {
                        this.hd = this.tf.newTransformerHandler();
                        this.result = new DOMResult();
                        this.hd.setResult(this.result);
                        this.hd.startDocument();
                        this.hd.startElement("", "", DATALOG, new AttributesImpl());
                        this.hd.startElement("", "", string, new AttributesImpl());
                    }

                    private void finish(String string) throws SAXException {
                        this.hd.endElement("", "", string);
                        this.hd.endElement("", "", DATALOG);
                        this.hd.endDocument();
                        Node node = this.result.getNode();
                        if (node instanceof Document) {
                            DataTransformerImpl2.this.requeue(new DocumentBlobAccess(taskDataAccess, (Document)node));
                        } else {
                            System.err.println("invalid result!");
                        }
                    }
                });
            }
            finally {
                inputStream.close();
            }
        }
        catch (SAXException sAXException) {
            this.handleError(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.handleError(parserConfigurationException);
        }
        catch (IOException iOException) {
            this.handleError(iOException);
        }
    }

    private InputStream createStream(TaskDataAccess taskDataAccess) throws IOException {
        return taskDataAccess.getStream();
    }

    private class ClosureInformation {
        ClosureOrder order;
        TaskDataAccess.DataType access;
        Closure closure;

        private ClosureInformation() {
        }
    }

    private class EnqueIndirectly
    implements Runnable {
        TaskDataAccess tda;

        public EnqueIndirectly(TaskDataAccess taskDataAccess) {
            this.tda = taskDataAccess;
        }

        public void run() {
            DataTransformerImpl2.this.executeIndirectlyWorker(this.tda);
        }
    }
}

