/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.netmapviewer.closures;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.netmapviewer.NetmapViewerHost;
import ddb.dsz.plugin.netmapviewer.Resource;
import ddb.dsz.plugin.netmapviewer.insertion.InsertShare;
import java.awt.EventQueue;
import org.apache.commons.collections.Closure;

public class SharesClosure
implements Closure {
    private final CoreController core;
    NetmapViewerHost networkHost;

    public SharesClosure(CoreController coreController, NetmapViewerHost netmapViewerHost) {
        this.networkHost = netmapViewerHost;
        this.core = coreController;
    }

    public void execute(Object object) {
        Resource resource;
        DataEvent dataEvent = (DataEvent)object;
        Task task = this.core.getTaskById(dataEvent.getTaskId());
        if (!DataEvent.DataEventType.DATA.equals((Object)dataEvent.getDataType())) {
            return;
        }
        boolean bl = true;
        for (ObjectValue objectValue : dataEvent.getData().getObjects("resource")) {
            resource = new Resource();
            resource.setCaption(objectValue.getString("caption"));
            resource.setDescription(objectValue.getString("Description"));
            String string = objectValue.getString("Name");
            resource.setName(string);
            resource.setNodeType(objectValue.getString("type"));
            resource.setPath(objectValue.getString("path"));
            resource.setAdmin(objectValue.getBoolean("admin"));
            EventQueue.invokeLater(new InsertShare(resource, bl, this.networkHost));
            bl = false;
        }
        for (ObjectValue objectValue : dataEvent.getData().getObjects("share")) {
            resource = new Resource();
            resource.setName(objectValue.getString("remotename"));
            resource.setDescription(String.format("Mapped Resource on %s", task.getHost().getId()));
            EventQueue.invokeLater(new InsertShare(resource, bl, this.networkHost));
            bl = false;
        }
    }
}

