/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel.filemodel;

import ddb.detach.MutableTabbableStatus;
import ddb.detach.TabbableStatus;
import ddb.detach.TabbableStatusImpl;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.ClosureFactory;
import ddb.dsz.core.data.DataTransformer;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.targetmodel.TargetDetail;
import ddb.targetmodel.filemodel.Data;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileObjectFields;
import ddb.targetmodel.filemodel.FileSystemListener;
import ddb.targetmodel.filemodel.history.ActionType;
import ddb.targetmodel.filemodel.history.CommandType;
import ddb.targetmodel.filemodel.listeners.CdListener;
import ddb.targetmodel.filemodel.listeners.CopyListener;
import ddb.targetmodel.filemodel.listeners.DirCrawler;
import ddb.targetmodel.filemodel.listeners.DrivesListener;
import ddb.targetmodel.filemodel.listeners.GetListener;
import ddb.targetmodel.filemodel.listeners.MoveListener;
import ddb.targetmodel.filemodel.listeners.PwdListener;
import ddb.util.Guid;
import ddb.util.UtilityConstants;
import java.io.File;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.event.EventListenerList;
import org.apache.commons.collections.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemModel
implements TargetDetail {
    public static final int TRANSLATE_PRIORITY = Integer.MAX_VALUE;
    public static final int RETRIEVE_PRIORITY = Integer.MIN_VALUE;
    static final List<FileObject> NULL_LIST = Collections.unmodifiableList(new ArrayList());
    static Data<?>[] NO_DATA = new Data[0];
    static final Set<String> INTERESTING_TASKS = new HashSet<String>();
    static final ExecutorService onFinishExec = new ThreadPoolExecutor(20, Integer.MAX_VALUE, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), UtilityConstants.createThreadFactory((String)"FileSystemModel - onFinishExec"));
    DataTransformer transformer = DataTransformer.newInstance((String)"FileSystemModel");
    boolean finished = false;
    private static final String FILE_TABLE = "create Table File (\tFILEID INTEGER PRIMARY KEY ON CONFLICT IGNORE AUTOINCREMENT,PARENT INTEGER DEFAULT -1,\tNAME TEXT NOT NULL DEFAULT '.' COLLATE NOCASE,\tTRANSLATED_NAME TEXT COLLATE NOCASE,\tALT_NAME TEXT COLLATE NOCASE,\tSIZE INTEGER,\tCREATED TEXT,\tMODIFIED TEXT,\tACCESSED TEXT, UNIQUE (Parent, Name) ON CONFLICT IGNORE, CONSTRAINT Fk_Parent FOREIGN KEY (Parent) REFERENCES File(FileId));";
    private static final String DIRECTORY_TABLE = "create Table Directory (\tDIRID INTEGER PRIMARY KEY ON CONFLICT IGNORE,\tLAST_PARTIAL TEXT,\tLAST_FULL TEXT,\tACCESS_DENIED INTEGER,\tCONSTRAINT Fk_Dir_Id FOREIGN KEY (DirId) REFERENCES File(FileId));";
    private static final String DRIVE_TABLE = "create Table Drive (\tDRIVEID INTEGER PRIMARY KEY ON CONFLICT IGNORE,\tSOURCE TEXT,\tTYPE INTEGER,\tSERIAL TEXT,\tFILESYSTEM TEXT,\tOPTIONS TEXT,\tCONSTRAINT Fk_Drive_Id FOREIGN KEY (DriveId) REFERENCES File(FileId));";
    private static final String HASH_TABLE = "create Table Hash (\tHASHID\tINTEGER PRIMARY KEY ON CONFLICT IGNORE,\tSHA1\tTEXT,\tMD5\t\tTEXT,\tSHA256\tTEXT,\tSHA512\tTEXT,\tCONSTRAINT Fk_Drive_Id FOREIGN KEY (HashId) REFERENCES File(FileId));";
    private static final String ATTRIBUTE_TABLE = "Create Table FileAttributes (\tAttrId\t\t\t\t\tINTEGER PRIMARY KEY ON CONFLICT REPLACE,\tArchive\t\t\t\t\tINTEGER,\tCompressed\t\t\t\tINTEGER,\tEncrypted\t\t\t\tINTEGER,\tHidden\t\t\t\t\tINTEGER,\tOffline\t\t\t\t\tINTEGER,\tReadOnly\t\t\t\tINTEGER,\tReparsePoint\t\t\tINTEGER,\tSparseFile\t\t\t\tINTEGER,\tSystem\t\t\t\t\tINTEGER,\tTemporary\t\t\t\tINTEGER,\tNotContentIndexed\t\tINTEGER,\tDevice\t\t\t\t\tINTEGER,\tOwnerRead\t\t\t\tINTEGER,\tOwnerWrite\t\t\t\tINTEGER,\tOwnerExec\t\t\t\tINTEGER,\tGroupRead\t\t\t\tINTEGER,\tGroupWrite\t\t\t\tINTEGER,\tGroupExec\t\t\t\tINTEGER,\tWorldRead\t\t\t\tINTEGER,\tWorldWrite\t\t\t\tINTEGER,\tWorldExec\t\t\t\tINTEGER,\tSetUid\t\t\t\t\tINTEGER,\tSetGid\t\t\t\t\tINTEGER,\tStickyBit\t\t\t\tINTEGER,\tOwner_Name\t\t\t\tTEXT,\tOwner_Id\t\t\t\tINTEGER,\tGroup_Name\t\t\t\tTEXT,\tGroup_Id\t\t\t\tINTEGER,\tCharacterSpecialFile\tINTEGER,\tBlockSpecialFile\t\tINTEGER,\tUnixFamilySocket\t\tINTEGER,\tNamedPipe\t\t\t\tINTEGER,\tSymbolicLink\t\t\tINTEGER,\tHardLinks\t\t\t\tINTEGER,\tinode\t\t\t\t\tINTEGER,\tCONSTRAINT Fk_Attr_Id FOREIGN KEY (AttrId) REFERENCES File(FileId));";
    private static final String HISTORY_TABLE = "Create Table History (\tFILEID INTEGER,\tTASKID INTEGER,   OPERATION STRING,\tACTION INTEGER,\tCOMMAND INTEGER,\tTIME TEXT,\tARGUMENT TEXT,\tCONSTRAINT Pk_History_Table PRIMARY KEY (FileId, Operation, TaskId) ON CONFLICT IGNORE );";
    static final String[] SCHEMA;
    public static final Long ROOT;
    public static final Long HOSTS;
    public static final Long DEAD;
    ScheduledThreadPoolExecutor databaseExec = new ScheduledThreadPoolExecutor(1, UtilityConstants.createThreadFactory((String)"FileSystemModel - databaseExec"));
    static ScheduledThreadPoolExecutor fileChangedExec;
    Status status = Status.Starting;
    EventListenerList listeners = new EventListenerList();
    final Object UPDATED_FILES_LOCK = new Object();
    List<FileObject> updatedFiles2 = new ArrayList<FileObject>();
    Comparator<FileObject> FileObjectComparator = new Comparator<FileObject>(){

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            return fileObject.getId().intValue() - fileObject2.getId().intValue();
        }
    };
    CoreController core;
    String hostId;
    Connection connection;
    PreparedStatement directoryListing;
    PreparedStatement subdirectories;
    PreparedStatement addAttributes;
    PreparedStatement retrieveFile;
    PreparedStatement retrieveFullFile;
    PreparedStatement makeDirectory;
    PreparedStatement makeDrive;
    PreparedStatement createFile;
    PreparedStatement createFileBatch;
    PreparedStatement createHash;
    PreparedStatement findFile;
    PreparedStatement findFileSimple;
    PreparedStatement addHistory;
    PreparedStatement dumpHistory;
    PreparedStatement listOfChildren;
    PreparedStatement getSearchFile;
    PreparedStatement getDrives;
    PreparedStatement getPath;
    PreparedStatement deleteFile;
    PreparedStatement deleteDirectory;
    PreparedStatement deleteDrive;
    int createdFileCount = 0;
    boolean autoGenerated = false;
    final Object PENDING_REQUESTS = new Object();
    Set<Long> pendingRequests = new HashSet<Long>();
    PreparedStatement[] Statements = new PreparedStatement[FileObjectFields.values().length];
    final Object PENDING_FINDS = new Object();
    List<FindFile> pendingFinds = new Vector<FindFile>();
    final FindFile2 FINDFILE2 = new FindFile2();
    final Object PENDING_FILES = new Object();
    List<FileObject> pendingSaves = new Vector<FileObject>();
    List<Long> pendingFileAttributes = new Vector<Long>();
    List<Long> pendingDirectories = new Vector<Long>();
    List<Long> pendingDrives = new Vector<Long>();
    List<Long> pendingDeletes = new Vector<Long>();
    final SaveFile2 SAVEFILE2 = new SaveFile2();
    List<AddHistoryItem> pendingHistory = new Vector<AddHistoryItem>();
    final Object PENDING_GETNODEFORPATH = new Object();
    List<GetNodeForPath> pendingGetNodeForPath = new Vector<GetNodeForPath>();
    final GetNodeForPath2 GETNODEFORPATH2 = new GetNodeForPath2();
    final Object PENDING_TRANSLATION = new Object();
    Set<Long> pendingTranslations = new HashSet<Long>();
    private boolean needsInit = true;
    private File tempDatabase = null;
    private final Map<Task, Long> furthestOrdinal = new HashMap<Task, Long>();
    private final Runnable CreateDatabase = new Runnable(){

        public void run() {
            try {
                File file = new File(FileSystemModel.this.core.getUserConfigDirectory(), "FileBrowser");
                file.mkdirs();
                Calendar calendar = Calendar.getInstance();
                FileSystemModel.this.tempDatabase = new File(file, String.format("%s_%04d_%02d_%02d_%02dh%02dm%02ds.%03d.db", FileSystemModel.this.hostId, calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14)));
                FileSystemModel.this.tempDatabase.deleteOnExit();
                Class<?> clazz = Class.forName("org.sqlite.JDBC");
                if (FileSystemModel.this.tempDatabase.exists()) {
                    FileSystemModel.this.needsInit = false;
                }
                if (FileSystemModel.this.core.isLiveOperation()) {
                    FileSystemModel.this.core.setCommandEnvironmentVariable("File_Database", FileSystemModel.this.tempDatabase.getName(), FileSystemModel.this.core.getHostById(FileSystemModel.this.hostId));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };
    private final Runnable ConnectToDatabase = new Runnable(){

        public void run() {
            try {
                FileSystemModel.this.connection = DriverManager.getConnection(String.format("jdbc:sqlite:/%s", FileSystemModel.this.tempDatabase.getAbsolutePath()));
                String string = String.format("Connecting to %s with %s %s (%d.%d)", FileSystemModel.this.tempDatabase.getAbsolutePath(), FileSystemModel.this.connection.getMetaData().getDatabaseProductName(), FileSystemModel.this.connection.getMetaData().getDatabaseProductVersion(), FileSystemModel.this.connection.getMetaData().getDatabaseMajorVersion(), FileSystemModel.this.connection.getMetaData().getDatabaseMinorVersion());
                FileSystemModel.this.core.logEvent(Level.INFO, "FileSystemModel", string);
                String[] stringArray = new String[]{"PRAGMA synchronous=OFF", "PRAGMA cache_size=20000", "PRAGMA foreign_keys = ON", "PRAGMA ignore_check_constraints=true", "PRAGMA journal_mode=MEMORY"};
                Statement statement = FileSystemModel.this.connection.createStatement();
                for (String string2 : stringArray) {
                    statement.execute(string2);
                }
                if (FileSystemModel.this.needsInit) {
                    FileSystemModel.this.needsInit = false;
                    for (String string2 : SCHEMA) {
                        statement.execute(string2);
                    }
                    statement.execute(String.format("INSERT INTO File (FileId, Parent) VALUES(%d, NULL)", ROOT));
                    statement.execute(String.format("INSERT INTO File (FileId, Parent) VALUES(%d, NULL)", DEAD));
                    statement.execute(String.format("INSERT INTO Directory (DirId) VALUES(%d)", ROOT));
                }
                FileSystemModel.this.connection.setAutoCommit(true);
                FileSystemModel.this.retrieveFile = FileSystemModel.this.connection.prepareStatement("Select *, (Select count(*) from File as FC where F.FileId = FC.Parent) as Children From File AS F LEFT OUTER JOIN Directory ON F.FileId = Directory.DirId LEFT OUTER JOIN Drive ON Directory.DirId = Drive.DriveId Where F.FileId = ?", 1003, 1007);
                FileSystemModel.this.listOfChildren = FileSystemModel.this.connection.prepareStatement("Select FileId from File left outer join Directory on File.FileId = Directory.DirId Where Parent = ? Order By Directory.DirId ISNULL Collate Nocase, File.Name Collate Nocase", 1003, 1007);
                FileSystemModel.this.retrieveFullFile = FileSystemModel.this.connection.prepareStatement("SELECT *, (SELECT count(*) FROM File as FC where F.FileId = FC.Parent) as CHILDREN From File AS F LEFT OUTER JOIN Directory ON F.FileId = Directory.DirId LEFT OUTER JOIN Drive ON Directory.DirId = Drive.DriveId LEFT OUTER JOIN FileAttributes ON F.FileId = FileAttributes.AttrId LEFT OUTER JOIN Hash ON F.FileId = Hash.HashId WHERE F.FileId = ?", 1003, 1007);
                FileSystemModel.this.directoryListing = FileSystemModel.this.connection.prepareStatement("Select FileId, Created, Accessed, Modified, Size, Name, Parent, DirId, (Select count(*) from File as FC where F.FileId = FC.Parent) as CHILDREN, Access_Denied, DriveId, Type From File AS F LEFT OUTER JOIN Directory ON F.FileId = Directory.DirId LEFT OUTER JOIN Drive ON Directory.DirId = Drive.DriveId Where F.Parent = ? Order By Directory.DirId ISNULL Collate Nocase, F.Name", 1003, 1007);
                FileSystemModel.this.subdirectories = FileSystemModel.this.connection.prepareStatement("Select FileId, Name, Parent, DirId, (Select count(*) from File as FC where F.FileId = FC.Parent) as CHILDREN, DriveId, Type From Directory INNER JOIN File As F ON Directory.DirId = F.FileId LEFT OUTER JOIN Drive ON Directory.DirId = Drive.DriveId Where F.Parent = ? Order By Directory.DirId ISNULL Collate Nocase, F.Name", 1003, 1007);
                FileSystemModel.this.makeDirectory = FileSystemModel.this.connection.prepareStatement("insert or ignore into Directory (DirId) Values (?)");
                FileSystemModel.this.makeDrive = FileSystemModel.this.connection.prepareStatement("insert or ignore into Drive (DriveId) Values (?)");
                FileSystemModel.this.addAttributes = FileSystemModel.this.connection.prepareStatement("insert or ignore into FileAttributes (AttrId) Values(?)");
                try {
                    FileSystemModel.this.createFile = FileSystemModel.this.connection.prepareStatement("insert into File (Name, Parent) values(?,?)", 1);
                    FileSystemModel.this.autoGenerated = true;
                    FileSystemModel.this.core.logEvent(Level.INFO, FileSystemModel.class.getSimpleName(), "Autogenerated keys are available");
                }
                catch (Exception exception) {
                    FileSystemModel.this.createFile = FileSystemModel.this.connection.prepareStatement("insert or ignore into File (Name, Parent) values(?,?)");
                    FileSystemModel.this.autoGenerated = false;
                    FileSystemModel.this.core.logEvent(Level.INFO, FileSystemModel.class.getSimpleName(), "Autogenerated keys are not available");
                }
                FileSystemModel.this.createFileBatch = FileSystemModel.this.connection.prepareStatement("insert or ignore into File (Name, Parent) values(?,?)");
                FileSystemModel.this.createHash = FileSystemModel.this.connection.prepareStatement("insert or ignore into Hash (HashId) values (?)");
                FileSystemModel.this.findFile = FileSystemModel.this.connection.prepareStatement("select * From File AS F LEFT OUTER JOIN Directory ON F.FileId = Directory.DirId LEFT OUTER JOIN Drive ON Directory.DirId = Drive.DriveId Where F.parent = ? and (F.Name = ?)", 1003, 1007);
                FileSystemModel.this.findFileSimple = FileSystemModel.this.connection.prepareStatement("select FileId, Name, Parent, DirId, DriveId, Access_Denied From File AS F LEFT OUTER JOIN Directory ON F.FileId = Directory.DirId LEFT OUTER JOIN Drive ON Directory.DirId = Drive.DriveId Where F.parent = ? and (F.Name = ?)", 1003, 1007);
                FileSystemModel.this.addHistory = FileSystemModel.this.connection.prepareStatement("Insert into History (FileId, Operation, TaskId, Action, Command, Time, Argument) values (?,?,?,?,?,?,?)");
                FileSystemModel.this.dumpHistory = FileSystemModel.this.connection.prepareStatement("SELECT * FROM History WHERE FileId = ? ORDER BY TaskId", 1003, 1007);
                FileSystemModel.this.getSearchFile = FileSystemModel.this.connection.prepareStatement("select * From File AS F LEFT OUTER JOIN Directory ON F.FileId = Directory.DirId LEFT OUTER JOIN Drive ON Directory.DirId = Drive.DriveId Where F.FileId = ?");
                FileSystemModel.this.getDrives = FileSystemModel.this.connection.prepareStatement("select * From Drive INNER JOIN Directory ON Drive.DriveId = Directory.DirId INNER JOIN File ON Drive.DriveId = File.FileId Where File.Parent = " + ROOT, 1003, 1007);
                FileSystemModel.this.getPath = FileSystemModel.this.connection.prepareStatement("Select FileId, Parent, Name From File Where FileId = ?", 1003, 1007);
                FileSystemModel.this.deleteFile = FileSystemModel.this.connection.prepareStatement("DELETE FROM File WHERE FileId = ?");
                FileSystemModel.this.deleteDirectory = FileSystemModel.this.connection.prepareStatement("DELETE FROM Directory WHERE DirId = ?");
                FileSystemModel.this.deleteDrive = FileSystemModel.this.connection.prepareStatement("DELETE FROM Drive WHERE DriveId = ?");
                FileObject fileObject = new FileObject(FileSystemModel.this);
                for (FileObjectFields fileObjectFields : FileObjectFields.DirFields) {
                    FileSystemModel.this.Statements[fileObjectFields.ordinal()] = FileSystemModel.this.connection.prepareStatement(String.format("Update Directory SET %s=? WHERE DirId=?", fileObjectFields.getName()));
                }
                for (FileObjectFields fileObjectFields : FileObjectFields.DriveFields) {
                    FileSystemModel.this.Statements[fileObjectFields.ordinal()] = FileSystemModel.this.connection.prepareStatement(String.format("Update Drive SET %s=? WHERE DriveId=?", fileObjectFields.getName()));
                }
                for (FileObjectFields fileObjectFields : FileObjectFields.AttrFields) {
                    FileSystemModel.this.Statements[fileObjectFields.ordinal()] = FileSystemModel.this.connection.prepareStatement(String.format("Update FileAttributes SET %s=? WHERE AttrId=?", fileObjectFields.getName()));
                }
                for (FileObjectFields fileObjectFields : FileObjectFields.FileFields) {
                    FileSystemModel.this.Statements[fileObjectFields.ordinal()] = FileSystemModel.this.connection.prepareStatement(String.format("Update File SET %s=? WHERE FileId=?", fileObjectFields.getName()));
                }
                for (FileObjectFields fileObjectFields : FileObjectFields.HashFields) {
                    FileSystemModel.this.Statements[fileObjectFields.ordinal()] = FileSystemModel.this.connection.prepareStatement(String.format("Update Hash SET %s=? WHERE HashId=?", fileObjectFields.getName()));
                }
                FileSystemModel.this.status = Status.Running;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };
    private final Runnable SendNotifications = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List<FileObject> list;
            FileSystemListener[] fileSystemListenerArray = (FileSystemListener[])FileSystemModel.this.listeners.getListeners(FileSystemListener.class);
            Iterator iterator = FileSystemModel.this.UPDATED_FILES_LOCK;
            synchronized (iterator) {
                list = FileSystemModel.this.updatedFiles2;
                FileSystemModel.this.updatedFiles2 = new ArrayList<FileObject>();
            }
            for (FileObject fileObject : list) {
                for (FileSystemListener fileSystemListener : fileSystemListenerArray) {
                    try {
                        fileSystemListener.fileChanged(fileObject);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    };
    private MutableTabbableStatus tabbableStatus = new TabbableStatusImpl(null);
    private final DirCrawler dirCrawler;
    PathRecord pathToId2 = new PathRecord(20);
    private final Set<Long> mergeIds = new TreeSet<Long>();
    private boolean mergeRunning = false;

    public FileSystemModel(CoreController coreController, String string) throws Exception {
        this.hostId = string;
        this.core = coreController;
        this.dirCrawler = new DirCrawler(coreController, this);
        this.transformer.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"cd", (String)"Dsz", (Closure)new CdListener(coreController, this)));
        this.transformer.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"copy", (String)"Dsz", (Closure)new CopyListener(coreController, this)));
        this.transformer.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"drives", (String)"Dsz", (Closure)new DrivesListener(coreController, this)));
        this.transformer.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"get", (String)"Dsz", (Closure)new GetListener(coreController, this)));
        this.transformer.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"move", (String)"Dsz", (Closure)new MoveListener(coreController, this)));
        this.transformer.addClosure(ClosureFactory.newVariableClosure((CoreController)coreController, (String)"pwd", (String)"Dsz", (Closure)new PwdListener(coreController, this)));
        this.databaseExec.submit(this.CreateDatabase);
        this.databaseExec.submit(this.ConnectToDatabase);
        fileChangedExec.scheduleWithFixedDelay(this.SendNotifications, 1000L, 250L, TimeUnit.MILLISECONDS);
        this.databaseExec.scheduleWithFixedDelay(this.FINDFILE2, 250L, 250L, TimeUnit.MILLISECONDS);
        this.databaseExec.scheduleWithFixedDelay(this.SAVEFILE2, 250L, 250L, TimeUnit.MILLISECONDS);
        this.databaseExec.scheduleWithFixedDelay(this.GETNODEFORPATH2, 50L, 50L, TimeUnit.MILLISECONDS);
        this.addFileSystemListener(new FileSystemListener(){

            public void fileChanged(FileObject fileObject) {
                if (fileObject == null) {
                    return;
                }
                if (fileObject.getParent() < 0L) {
                    return;
                }
                FileSystemModel.this.addMergeId(fileObject.getParent());
                FileSystemModel.this.addMergeId(fileObject.getId());
            }
        });
    }

    public void setPendingData(int n) {
        if (n > 0) {
            this.tabbableStatus.setDetails(String.format("Pending Dir Entries:  %d", n));
        } else {
            this.tabbableStatus.setDetails("");
        }
        this.tabbableStatus.setIndeterminate(n > 0);
        this.tabbableStatus.notifyObservers();
    }

    public File getDatabaseFile() {
        return this.tempDatabase;
    }

    public TabbableStatus getTabbableStatus() {
        return this.tabbableStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrdinal(Task task, Long l) {
        if (task == null || l == null || l == -1L) {
            return;
        }
        Map<Task, Long> map = this.furthestOrdinal;
        synchronized (map) {
            Long l2 = this.furthestOrdinal.get(task);
            if (l2 != null && l < l2) {
                return;
            }
            this.furthestOrdinal.put(task, l + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOrdinalDetails() {
        long l = 0L;
        long l2 = 0L;
        Map<Task, Long> map = this.furthestOrdinal;
        synchronized (map) {
            for (Task task : this.furthestOrdinal.keySet()) {
                l += (long)task.getNextOrdinal();
                l2 += this.furthestOrdinal.get(task).longValue();
            }
        }
        if (l == l2) {
            return null;
        }
        return String.format("Processed %d of %d records", l2, l);
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeDirectory(long l) {
        Object object = this.PENDING_FILES;
        synchronized (object) {
            this.pendingDirectories.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeDrive(long l) {
        Object object = this.PENDING_FILES;
        synchronized (object) {
            this.pendingDrives.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskingDone(long l) {
        Object object = this.PENDING_REQUESTS;
        synchronized (object) {
            this.pendingRequests.remove(l);
        }
        this.fireFileChanged(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskingStarted(long l) {
        Object object = this.PENDING_REQUESTS;
        synchronized (object) {
            this.pendingRequests.add(l);
        }
        this.fireFileChanged(l);
    }

    @Override
    public void addTask(Task task) {
        if (task == null || task.getCommandName() == null || task.getCommandName().equals("")) {
            return;
        }
        if (task.getCommandName().equalsIgnoreCase("dir")) {
            this.dirCrawler.addTask(task);
        }
        if (INTERESTING_TASKS.contains(task.getDataName().toLowerCase())) {
            this.transformer.addTask(task);
        }
    }

    public void addHistoryItem(FileObject fileObject, TaskId taskId, ActionType actionType, CommandType commandType, Calendar calendar) {
        this.addHistoryItem(fileObject, taskId, actionType, commandType, calendar, null);
    }

    public void addHistoryItem(FileObject fileObject, TaskId taskId, ActionType actionType, CommandType commandType, Calendar calendar, String string) {
        if (fileObject == null) {
            return;
        }
        this.databaseExec.submit(new AddHistoryItem(fileObject, taskId, actionType, commandType, calendar, string));
    }

    public FileObject getChildNode(FileObject fileObject, String string, boolean bl, CommandType commandType, TaskId taskId, Calendar calendar, boolean bl2, Closure closure) {
        return this.getChildNode(fileObject.getId(), fileObject.getPath(), string, bl, commandType, taskId, calendar, bl2, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getChildNode(Long l, String string, String string2, boolean bl, CommandType commandType, TaskId taskId, Calendar calendar, boolean bl2, Closure closure) {
        FindFile findFile = new FindFile(l, string2, bl, taskId, commandType, calendar, string, bl2, closure);
        if (closure != null) {
            Object object = this.PENDING_FINDS;
            synchronized (object) {
                this.pendingFinds.add(findFile);
            }
            return null;
        }
        Future<FileObject> future = this.databaseExec.submit(findFile);
        try {
            FileObject fileObject = future.get();
            return fileObject;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public FileObject getNodeForPath(String string, boolean bl, CommandType commandType, TaskId taskId, Calendar calendar, boolean bl2, Closure closure) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("/") || string.startsWith("\\")) {
            return null;
        }
        return this.getNodeForPath(ROOT, null, Arrays.asList(string.split("[\\\\/]")), bl, commandType, taskId, calendar, bl2, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getNodeForPath(Long l, String string, List<String> list, boolean bl, CommandType commandType, TaskId taskId, Calendar calendar, boolean bl2, Closure closure) {
        if (closure != null) {
            Object object = this.PENDING_GETNODEFORPATH;
            synchronized (object) {
                this.pendingGetNodeForPath.add(new GetNodeForPath(l, list, bl, commandType, taskId, calendar, bl2, closure));
            }
            return null;
        }
        Future<FileObject> future = this.databaseExec.submit(new GetNodeForPath(l, list, bl, commandType, taskId, calendar, bl2, closure));
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void addFileSystemListener(FileSystemListener fileSystemListener) {
        this.listeners.add(FileSystemListener.class, fileSystemListener);
    }

    public void removeFileSystemListener(FileSystemListener fileSystemListener) {
        this.listeners.remove(FileSystemListener.class, fileSystemListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileChanged(FileObject fileObject) {
        Object object = this.UPDATED_FILES_LOCK;
        synchronized (object) {
            int n = Collections.binarySearch(this.updatedFiles2, fileObject, this.FileObjectComparator);
            if (n >= 0) {
                return;
            }
            ++n;
            n = -n;
            this.updatedFiles2.add(n, fileObject);
        }
    }

    void fireFileChanged(Long l) {
        this.databaseExec.submit(new GetFile(l, false, "", new Closure(){

            public void execute(Object object) {
                FileSystemModel.this.fireFileChanged((FileObject)FileObject.class.cast(object));
            }
        }));
    }

    public FileObject getFile(long l, String string) {
        return this.getFile(l, string, null);
    }

    public FileObject getFile(long l, String string, Closure closure) {
        Future<FileObject> future = this.databaseExec.submit(new GetFile(l, false, string, closure));
        if (closure == null) {
            try {
                return future.get();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public FileObject getFullFile(long l, String string) {
        return this.getFullFile(l, string, null);
    }

    public FileObject getFullFile(long l, String string, Closure closure) {
        Future<FileObject> future = this.databaseExec.submit(new GetFile(l, true, string, closure));
        if (closure == null) {
            try {
                return future.get();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public List<FileObject> getDirectoryListing(Long l, String string) {
        Future<List<FileObject>> future = this.databaseExec.submit(new GetList(l, this.directoryListing, string));
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return NULL_LIST;
        }
    }

    public List<Long> getChildren(Long l, String string, Closure closure) {
        Future<List<Long>> future = this.databaseExec.submit(new GetChildren(l, closure));
        if (closure != null) {
            return null;
        }
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Collections.emptyList();
        }
    }

    public List<FileObject> getSubdirectories(Long l, String string) {
        Future<List<FileObject>> future = this.databaseExec.submit(new GetList(l, this.subdirectories, string));
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return NULL_LIST;
        }
    }

    public FileObject getSearchFile(Long l) {
        Future<FileObject> future = this.databaseExec.submit(new GetSearchFile(l));
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public List<FileObject> getDrives() {
        Future<List<FileObject>> future = this.databaseExec.submit(new GetDrives());
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return NULL_LIST;
        }
    }

    public List<FileObject> getArbitraryQuery(PreparedStatement preparedStatement) {
        Future<List<FileObject>> future = this.databaseExec.submit(new ExecArbitrary(preparedStatement));
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return NULL_LIST;
        }
    }

    public void getPath(FileObject fileObject) {
        this.getPath(fileObject, null);
    }

    public void getPath(FileObject fileObject, Closure closure) {
        try {
            this.databaseExec.submit(new GetPath(fileObject, closure));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public PreparedStatement prepareStatement(String string) {
        Future<PreparedStatement> future = this.databaseExec.submit(new PrepareStatement(string));
        try {
            return future.get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void retrieveFileInformation(FileObject fileObject, Runnable runnable) {
        try {
            this.databaseExec.submit(new GetFileInformation(fileObject, runnable));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(FileObject fileObject) {
        Object object = this.PENDING_FILES;
        synchronized (object) {
            this.pendingSaves.add(fileObject);
        }
        if (!fileObject.getDataElement(FileObjectFields.File_TranslatedName).hasValue()) {
            this.translate(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FileObject fileObject) {
        Object object = this.PENDING_FILES;
        synchronized (object) {
            this.pendingDeletes.add(fileObject.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAttributes(long l) {
        Object object = this.PENDING_FILES;
        synchronized (object) {
            this.pendingFileAttributes.add(l);
        }
    }

    public void recover(SQLException sQLException) {
        sQLException.printStackTrace();
        this.status = Status.Exception;
        this.databaseExec.submit(this.ConnectToDatabase);
    }

    void translate(FileObject fileObject) {
    }

    public void DumpHistory(FileObject fileObject, PrintStream printStream) {
        this.DumpHistory(fileObject.getId(), System.out);
    }

    public void DumpHistory(Long l, PrintStream printStream) {
        this.databaseExec.submit(new DumpHistory(l, printStream));
    }

    private void Dump(String string) {
        new Dumper(string).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMergeId(Long l) {
        if (l == null) {
            return;
        }
        Set<Long> set = this.mergeIds;
        synchronized (set) {
            this.mergeIds.add(l);
            if (!this.mergeRunning) {
                this.core.submit((Runnable)new MergeDirectories());
                this.mergeRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getNextMergeId() {
        Set<Long> set = this.mergeIds;
        synchronized (set) {
            if (this.mergeIds.size() == 0) {
                return null;
            }
            Long l = this.mergeIds.iterator().next();
            if (l == null) {
                return null;
            }
            this.mergeIds.remove(l);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneMerge() {
        Set<Long> set = this.mergeIds;
        synchronized (set) {
            if (!this.mergeIds.isEmpty()) {
                this.core.submit((Runnable)new MergeDirectories());
            } else {
                this.mergeRunning = false;
            }
        }
    }

    static {
        INTERESTING_TASKS.add("cd");
        INTERESTING_TASKS.add("copy");
        INTERESTING_TASKS.add("drives");
        INTERESTING_TASKS.add("get");
        INTERESTING_TASKS.add("move");
        INTERESTING_TASKS.add("pwd");
        SCHEMA = new String[]{FILE_TABLE, DIRECTORY_TABLE, DRIVE_TABLE, ATTRIBUTE_TABLE, HASH_TABLE, HISTORY_TABLE};
        ROOT = new Long(0L);
        HOSTS = new Long(-1L);
        DEAD = new Long(-2L);
        fileChangedExec = new ScheduledThreadPoolExecutor(1, UtilityConstants.createThreadFactory((String)"FileSystemModel - fileChangedExec"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MergeDirectories
    implements Runnable {
        private MergeDirectories() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Long l = FileSystemModel.this.getNextMergeId();
                if (l == null) {
                    return;
                }
                List<Long> list = FileSystemModel.this.getChildren(l, null, null);
                Collections.sort(list);
                Vector<FileObject> vector = new Vector<FileObject>(list.size());
                for (Long object : list) {
                    vector.add(FileSystemModel.this.getFullFile(object, null));
                }
                for (FileObject fileObject : vector) {
                    Vector<FileObject> vector2 = new Vector<FileObject>();
                    vector2.addAll(vector);
                    vector2.remove(fileObject);
                    FileObject fileObject2 = this.findMatch(vector2, fileObject.getName(), (String)fileObject.getDataElement(FileObjectFields.File_AlternateName).getValue());
                    if (fileObject == fileObject2 || fileObject2 == null || fileObject.getParent().longValue() != fileObject2.getParent().longValue()) continue;
                    if (fileObject.getDataElement(FileObjectFields.File_AlternateName).hasValue()) {
                        this.merge(fileObject2, fileObject);
                        continue;
                    }
                    this.merge(fileObject, fileObject2);
                }
            }
            finally {
                FileSystemModel.this.doneMerge();
            }
        }

        private FileObject findMatch(List<FileObject> list, String string, String string2) {
            for (FileObject fileObject : list) {
                String string3;
                String string4 = string3 = fileObject.getDataElement(FileObjectFields.File_AlternateName).hasValue() ? fileObject.getDataElement(FileObjectFields.File_AlternateName).getValue().toString() : null;
                if (string3 != null && string3.trim().length() == 0) {
                    string3 = null;
                }
                if (string != null && string.trim().length() > 0 && (string.equalsIgnoreCase(fileObject.getName()) || string.equalsIgnoreCase(string3))) {
                    return fileObject;
                }
                if (string2 == null || string2.trim().length() <= 0 || !string2.equalsIgnoreCase(fileObject.getName()) && !string2.equalsIgnoreCase(string3)) continue;
                return fileObject;
            }
            return null;
        }

        private void merge(FileObject fileObject, FileObject fileObject2) {
            if (fileObject.getParent().longValue() != fileObject2.getParent().longValue()) {
                return;
            }
            for (FileObjectFields fileObjectFields : FileObjectFields.values()) {
                if (fileObject2.getDataElement(fileObjectFields).hasValue() || !fileObject.getDataElement(fileObjectFields).hasValue()) continue;
                fileObject2.getDataElement(fileObjectFields).setValue(fileObject.getDataElement(fileObjectFields).getValue());
            }
            this.adoptChildren(fileObject, fileObject2);
            FileSystemModel.this.save(fileObject2);
            fileObject.getDataElement(FileObjectFields.File_Parent).setValue(DEAD, true);
            fileObject.setName(String.format("%d", fileObject.getId()));
            FileSystemModel.this.save(fileObject);
        }

        private void adoptChildren(FileObject fileObject, FileObject fileObject2) {
            List<Long> list = FileSystemModel.this.getChildren(fileObject.getId(), null, null);
            for (Long l : list) {
                FileObject fileObject3 = FileSystemModel.this.getFile(l, null);
                if (fileObject3 == null) continue;
                fileObject3.setParent(fileObject2.getId());
                FileSystemModel.this.save(fileObject3);
            }
        }
    }

    private class Dumper
    implements Runnable {
        String table;

        public Dumper(String string) {
            this.table = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Statement statement = FileSystemModel.this.connection.createStatement();
                try {
                    ResultSet resultSet = statement.executeQuery(String.format("Select * from %s", this.table));
                    try {
                        int n;
                        System.out.println("------------------------------------------------");
                        System.out.printf("-----------------%s DUMP-----------------------", this.table);
                        System.out.println("------------------------------------------------");
                        for (n = 1; n <= resultSet.getMetaData().getColumnCount(); ++n) {
                            System.out.printf("%-10s", resultSet.getMetaData().getColumnName(n));
                            System.out.print("\t");
                        }
                        System.out.println();
                        System.out.println("------------------------------------------------");
                        while (resultSet.next()) {
                            for (n = 1; n <= resultSet.getMetaData().getColumnCount(); ++n) {
                                System.out.printf("%10s", resultSet.getString(n));
                                System.out.print("\t");
                            }
                            System.out.println();
                        }
                        System.out.println("------------------------------------------------");
                    }
                    finally {
                        resultSet.close();
                    }
                }
                finally {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetPath
    extends DatabaseAction<Object> {
        FileObject fo;
        Closure onFinish;

        public GetPath(FileObject fileObject, Closure closure) {
            super(Priority.QUERY);
            this.fo = fileObject;
            this.onFinish = closure;
        }

        /*
         * Exception decompiling
         */
        @Override
        public String call() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ExecuteClosure
    implements Runnable {
        Object obj;
        Closure closure;

        public ExecuteClosure(Object object, Closure closure) {
            this.obj = object;
            this.closure = closure;
        }

        public void run() {
            this.closure.execute(this.obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrepareStatement
    extends DatabaseAction<PreparedStatement> {
        String query;

        public PrepareStatement(String string) {
            super(Priority.QUERY);
            this.query = string;
        }

        @Override
        public PreparedStatement call() throws Exception {
            if (FileSystemModel.this.status == Status.Exception) {
                return null;
            }
            try {
                return FileSystemModel.this.connection.prepareStatement(this.query);
            }
            catch (SQLException sQLException) {
                FileSystemModel.this.recover(sQLException);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecArbitrary
    extends DatabaseAction<List<FileObject>> {
        PreparedStatement statement;

        public ExecArbitrary(PreparedStatement preparedStatement) {
            super(Priority.QUERY);
            this.statement = preparedStatement;
        }

        @Override
        public List<FileObject> call() throws Exception {
            if (FileSystemModel.this.status == Status.Exception) {
                return null;
            }
            try {
                ResultSet resultSet = this.statement.executeQuery();
                return FileObject.getFiles(FileSystemModel.this, resultSet, null);
            }
            catch (SQLException sQLException) {
                FileSystemModel.this.recover(sQLException);
                return NULL_LIST;
            }
        }
    }

    private class GetNodeForPath2
    implements Runnable {
        private GetNodeForPath2() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (FileSystemModel.this.status == Status.Exception) {
                return;
            }
            try {
                GetNodeForPath[] getNodeForPathArray = null;
                Object object = FileSystemModel.this.PENDING_GETNODEFORPATH;
                synchronized (object) {
                    getNodeForPathArray = FileSystemModel.this.pendingGetNodeForPath.toArray(new GetNodeForPath[FileSystemModel.this.pendingGetNodeForPath.size()]);
                    FileSystemModel.this.pendingGetNodeForPath.clear();
                }
                if (getNodeForPathArray == null || getNodeForPathArray.length == 0) {
                    return;
                }
                this.get(getNodeForPathArray);
            }
            catch (SQLException sQLException) {
                FileSystemModel.this.recover(sQLException);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void get(GetNodeForPath[] getNodeForPathArray) throws SQLException {
            FileSystemModel.this.connection.setAutoCommit(false);
            try {
                for (GetNodeForPath getNodeForPath : getNodeForPathArray) {
                    try {
                        getNodeForPath.call();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            finally {
                FileSystemModel.this.connection.setAutoCommit(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetNodeForPath
    extends DatabaseAction<FileObject> {
        List<String> path;
        boolean create;
        CommandType cmd;
        TaskId taskId;
        Calendar timestamp;
        Closure onFinish;

        public GetNodeForPath(Long l, List<String> list, boolean bl, CommandType commandType, TaskId taskId, Calendar calendar, boolean bl2, Closure closure) {
            super(Priority.QUERY);
            this.path = list;
            this.create = bl;
            this.cmd = commandType;
            this.taskId = taskId;
            this.timestamp = calendar;
            this.onFinish = closure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public FileObject call() throws Exception {
            if (this.path == null) {
                return null;
            }
            try {
                Object object;
                int n;
                long l = ROOT;
                FileObject fileObject = null;
                int n2 = 0;
                for (n = this.path.size() - 1; n > 0; --n) {
                    object = FileSystemModel.this.pathToId2.GetPath(this.path.subList(0, n));
                    if (object == null) continue;
                    l = (Long)object;
                    n2 = n;
                    break;
                }
                for (n = n2; n < this.path.size(); ++n) {
                    object = this.path.get(n);
                    FileObject fileObject2 = this.getFile((String)object, l);
                    if (fileObject2 == null) {
                        if (!this.create) return null;
                        fileObject = this.createFile((String)object, l);
                        FileSystemModel.this.addHistoryItem(fileObject, this.taskId, ActionType.CREATED, this.cmd, this.timestamp);
                        if (fileObject == null) {
                            return null;
                        }
                        FileSystemModel.this.fireFileChanged(fileObject);
                        FileSystemModel.this.translate(fileObject);
                    } else {
                        fileObject = fileObject2;
                    }
                    FileSystemModel.this.pathToId2.AddPath(this.path.subList(0, n), l);
                    l = fileObject.getId();
                    if (n + 1 >= this.path.size()) continue;
                    fileObject.setDirectory();
                }
                if (fileObject == null) {
                    return null;
                }
                String string = null;
                for (String string2 : this.path) {
                    if (string == null) {
                        string = string2 + "/";
                        continue;
                    }
                    string = string + string2 + "/";
                }
                fileObject.setPath(string);
                object = FileSystemModel.this.PENDING_REQUESTS;
                synchronized (object) {
                    fileObject.setPendingRequest(FileSystemModel.this.pendingRequests.contains(fileObject.getId()));
                }
                if (this.onFinish == null) return fileObject;
                onFinishExec.submit(new ExecuteClosure(fileObject, this.onFinish));
                return null;
            }
            catch (SQLException sQLException) {
                FileSystemModel.this.recover(sQLException);
                return null;
            }
        }

        FileObject getFile(String string, long l) throws SQLException {
            FileSystemModel.this.findFileSimple.setLong(1, l);
            FileSystemModel.this.findFileSimple.setString(2, string);
            ResultSet resultSet = FileSystemModel.this.findFileSimple.executeQuery();
            List<FileObject> list = FileObject.getFiles(FileSystemModel.this, resultSet, null, 1);
            if (list.size() != 0) {
                FileObject fileObject = list.get(0);
                FileSystemModel.this.createAttributes(fileObject.getId());
                return fileObject;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFile(String string, long l) throws SQLException {
            block7: {
                if (!this.create) {
                    return null;
                }
                FileSystemModel.this.createFile.setString(1, string);
                FileSystemModel.this.createFile.setLong(2, l);
                if (FileSystemModel.this.autoGenerated) {
                    FileSystemModel.this.createFile.executeUpdate();
                    ResultSet resultSet = FileSystemModel.this.createFile.getGeneratedKeys();
                    try {
                        if (resultSet.next()) {
                            ++FileSystemModel.this.createdFileCount;
                            FileObject fileObject = new FileObject(FileSystemModel.this, resultSet.getInt(1));
                            fileObject.setDataElement(FileObjectFields.File_Parent, (Object)l);
                            fileObject.setDataElement(FileObjectFields.File_Name, (Object)string);
                            FileObject fileObject2 = fileObject;
                            return fileObject2;
                        }
                        break block7;
                    }
                    finally {
                        resultSet.close();
                    }
                }
                FileSystemModel.this.createFile.executeUpdate();
                if (FileSystemModel.this.createFile.getUpdateCount() > 0) {
                    ++FileSystemModel.this.createdFileCount;
                    return this.getFile(string, l);
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathRecord {
        final int maximumLength;
        final Long[] ArrayOfIds;
        final int[] ArrayOfHashes;
        final List<?>[] ArrayOfPaths;
        int index = 0;
        int length = 0;

        public PathRecord(int n) {
            this.maximumLength = n;
            this.ArrayOfIds = new Long[this.maximumLength];
            this.ArrayOfHashes = new int[this.maximumLength];
            this.ArrayOfPaths = new List[this.maximumLength];
        }

        public PathRecord() {
            this(100);
        }

        public synchronized void AddPath(List<String> list, Long l) {
            if (this.GetPath(list, false) != null) {
                return;
            }
            this.ArrayOfIds[this.index] = l;
            this.ArrayOfHashes[this.index] = ((Object)list).hashCode();
            this.ArrayOfPaths[this.index] = list;
            ++this.index;
            if (this.index >= this.maximumLength) {
                this.index = 0;
            } else if (this.index > this.length) {
                this.length = this.index;
            }
        }

        public Long GetPath(List<String> list) {
            return this.GetPath(list, true);
        }

        public synchronized Long GetPath(List<String> list, boolean bl) {
            int n = ((Object)list).hashCode();
            for (int i = 0; i < this.length; ++i) {
                if (this.ArrayOfHashes[i] != n || !((Object)list).equals(this.ArrayOfPaths[i])) continue;
                return this.ArrayOfIds[i];
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetDrives
    extends DatabaseAction<List<FileObject>> {
        public GetDrives() {
            super(Priority.QUERY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FileObject> call() throws Exception {
            if (FileSystemModel.this.status == Status.Exception) {
                return null;
            }
            try {
                ResultSet resultSet = FileSystemModel.this.getDrives.executeQuery();
                List<FileObject> list = FileObject.getFiles(FileSystemModel.this, resultSet, null);
                for (FileObject fileObject : list) {
                    Object object = FileSystemModel.this.PENDING_REQUESTS;
                    synchronized (object) {
                        fileObject.setPendingRequest(FileSystemModel.this.pendingRequests.contains(fileObject.getId()));
                    }
                }
                return list;
            }
            catch (SQLException sQLException) {
                FileSystemModel.this.recover(sQLException);
                return NULL_LIST;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetSearchFile
    extends DatabaseAction<FileObject> {
        long id;

        public GetSearchFile(long l) {
            super(Priority.QUERY);
            this.id = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileObject call() throws Exception {
            if (FileSystemModel.this.status == Status.Exception) {
                return null;
            }
            try {
                ResultSet resultSet = null;
                FileSystemModel.this.getSearchFile.setLong(1, this.id);
                resultSet = FileSystemModel.this.getSearchFile.executeQuery();
                List<FileObject> list = FileObject.getFiles(FileSystemModel.this, resultSet, null, 1);
                if (list.size() > 0) {
                    FileObject fileObject = list.get(0);
                    FileSystemModel.this.getPath(fileObject);
                    Object object = FileSystemModel.this.PENDING_REQUESTS;
                    synchronized (object) {
                        fileObject.setPendingRequest(FileSystemModel.this.pendingRequests.contains(fileObject.getId()));
                    }
                    return fileObject;
                }
                return null;
            }
            catch (SQLException sQLException) {
                FileSystemModel.this.recover(sQLException);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SaveFile2
    implements Runnable {
        private SaveFile2() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (FileSystemModel.this.status == Status.Exception) {
                return;
            }
            try {
                List<FileObject> list = null;
                List<Long> list2 = null;
                List<Long> list3 = null;
                List<Long> list4 = null;
                List<Long> list5 = null;
                Object object = FileSystemModel.this.PENDING_FILES;
                synchronized (object) {
                    list4 = FileSystemModel.this.pendingDirectories;
                    list3 = FileSystemModel.this.pendingDrives;
                    list2 = FileSystemModel.this.pendingFileAttributes;
                    list = FileSystemModel.this.pendingSaves;
                    list5 = FileSystemModel.this.pendingDeletes;
                    FileSystemModel.this.pendingDirectories = new Vector<Long>();
                    FileSystemModel.this.pendingDrives = new Vector<Long>();
                    FileSystemModel.this.pendingFileAttributes = new Vector<Long>();
                    FileSystemModel.this.pendingSaves = new Vector<FileObject>();
                    FileSystemModel.this.pendingDeletes = new Vector<Long>();
                }
                if (list != null && list.size() > 0) {
                    this.save(list);
                }
                if (list4 != null && list4.size() > 0) {
                    this.directory(list4);
                }
                if (list3 != null && list3.size() > 0) {
                    this.drive(list3);
                }
                if (list2 != null && list2.size() > 0) {
                    this.createAttributes(list2);
                }
                if (list5 != null && list5.size() > 0) {
                    this.delete(list5);
                }
            }
            catch (SQLException sQLException) {
                FileSystemModel.this.recover(sQLException);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void helper(List<Long> list, PreparedStatement preparedStatement) throws SQLException {
            Collections.sort(list);
            FileSystemModel.this.connection.setAutoCommit(false);
            try {
                long l = -1L;
                for (Long l2 : list) {
                    if (l2 == null || l2 == l) continue;
                    l = l2;
                    preparedStatement.setLong(1, l2);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
            finally {
                FileSystemModel.this.connection.setAutoCommit(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delete(List<Long> list) throws SQLException {
            Collections.sort(list, Collections.reverseOrder());
            for (PreparedStatement preparedStatement : new PreparedStatement[]{FileSystemModel.this.deleteDrive, FileSystemModel.this.deleteDirectory, FileSystemModel.this.deleteFile}) {
                FileSystemModel.this.connection.setAutoCommit(false);
                try {
                    long l = -1L;
                    for (Long l2 : list) {
                        if (l2 == null || l2 == l) continue;
                        l = l2;
                        preparedStatement.setLong(1, l2);
                        preparedStatement.addBatch();
                    }
                }
                finally {
                    preparedStatement.executeBatch();
                    FileSystemModel.this.connection.setAutoCommit(true);
                }
            }
            this.helper(list, FileSystemModel.this.deleteDrive);
            this.helper(list, FileSystemModel.this.deleteDirectory);
            this.helper(list, FileSystemModel.this.deleteFile);
        }

        private void directory(List<Long> list) throws SQLException {
            this.helper(list, FileSystemModel.this.makeDirectory);
        }

        private void drive(List<Long> list) throws SQLException {
            this.helper(list, FileSystemModel.this.makeDrive);
        }

        private void createAttributes(List<Long> list) throws SQLException {
            this.helper(list, FileSystemModel.this.addAttributes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save(List<FileObject> list) throws SQLException {
            FileSystemModel.this.connection.setAutoCommit(false);
            try {
                for (FileObject fileObject : list) {
                    Data<?> data;
                    long l = fileObject.getId();
                    boolean bl = false;
                    for (FileObjectFields fileObjectFields : FileObjectFields.HashFields) {
                        data = fileObject.getDataElement(fileObjectFields);
                        if (!data.hasValue() || !data.isModified()) continue;
                        bl = true;
                    }
                    if (bl) {
                        FileSystemModel.this.createHash.setLong(1, fileObject.getId());
                        FileSystemModel.this.createHash.addBatch();
                    }
                    for (FileObjectFields fileObjectFields : FileObjectFields.values()) {
                        PreparedStatement preparedStatement;
                        data = fileObject.getDataElement(fileObjectFields);
                        if (!data.isModified() || !data.hasValue() || (preparedStatement = FileSystemModel.this.Statements[fileObjectFields.ordinal()]) == null) continue;
                        preparedStatement.setLong(2, l);
                        data.prepare(preparedStatement, 1);
                        preparedStatement.addBatch();
                    }
                }
                FileSystemModel.this.createHash.executeBatch();
                FileSystemModel.this.createHash.clearBatch();
                for (PreparedStatement preparedStatement : FileSystemModel.this.Statements) {
                    if (preparedStatement == null) continue;
                    preparedStatement.executeBatch();
                    preparedStatement.clearBatch();
                }
            }
            finally {
                FileSystemModel.this.connection.setAutoCommit(true);
            }
            Object object = FileSystemModel.this.UPDATED_FILES_LOCK;
            synchronized (object) {
                if (FileSystemModel.this.updatedFiles2.size() == 0) {
                    FileSystemModel.this.updatedFiles2 = list;
                } else {
                    FileSystemModel.this.updatedFiles2.addAll(list);
                    Collections.sort(FileSystemModel.this.updatedFiles2, FileSystemModel.this.FileObjectComparator);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetList
    extends DatabaseAction<List<FileObject>> {
        Long id;
        PreparedStatement query;
        String path;

        public GetList(Long l, PreparedStatement preparedStatement, String string) {
            super(Priority.QUERY);
            this.id = l;
            this.query = preparedStatement;
            this.path = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FileObject> call() throws Exception {
            if (FileSystemModel.this.status == Status.Exception) {
                return NULL_LIST;
            }
            if (this.id != null) {
                try {
                    this.query.setLong(1, this.id);
                    List<FileObject> list = FileObject.getFiles(FileSystemModel.this, this.query.executeQuery(), this.path);
                    for (FileObject fileObject : list) {
                        Object object = FileSystemModel.this.PENDING_REQUESTS;
                        synchronized (object) {
                            fileObject.setPendingRequest(FileSystemModel.this.pendingRequests.contains(fileObject.getId()));
                        }
                    }
                    return list;
                }
                catch (SQLException sQLException) {
                    FileSystemModel.this.recover(sQLException);
                }
            }
            return new ArrayList<FileObject>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetFileInformation
    extends DatabaseAction<Object> {
        FileObject fo;
        Runnable exec;

        public GetFileInformation(FileObject fileObject, Runnable runnable) {
            super(Priority.QUERY);
            this.fo = fileObject;
            this.exec = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            block11: {
                if (FileSystemModel.this.status == Status.Exception) {
                    return null;
                }
                if (this.fo.isDiscard()) {
                    return null;
                }
                try {
                    FileSystemModel.this.retrieveFullFile.setLong(1, this.fo.getId());
                    ResultSet resultSet = FileSystemModel.this.retrieveFullFile.executeQuery();
                    if (resultSet == null) break block11;
                    try {
                        if (!resultSet.next()) break block11;
                        this.fo.retrieve(resultSet);
                        Object object = FileSystemModel.this.PENDING_REQUESTS;
                        synchronized (object) {
                            this.fo.setPendingRequest(FileSystemModel.this.pendingRequests.contains(this.fo.getId()));
                        }
                    }
                    finally {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    FileSystemModel.this.recover(sQLException);
                }
            }
            if (this.exec != null) {
                this.exec.run();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetFile
    extends DatabaseAction<FileObject> {
        long id;
        boolean full;
        String path;
        Closure closure;

        public GetFile(long l, boolean bl, String string, Closure closure) {
            super(Priority.QUERY);
            this.id = l;
            this.full = bl;
            this.path = string;
            this.closure = closure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileObject call() throws Exception {
            if (FileSystemModel.this.status == Status.Exception) {
                return null;
            }
            try {
                PreparedStatement preparedStatement = FileSystemModel.this.retrieveFullFile;
                if (!this.full) {
                    preparedStatement = FileSystemModel.this.retrieveFile;
                }
                preparedStatement.setLong(1, this.id);
                ResultSet resultSet = preparedStatement.executeQuery();
                List<FileObject> list = FileObject.getFiles(FileSystemModel.this, resultSet, this.path, 1);
                if (list.size() > 0) {
                    FileObject fileObject = list.get(0);
                    Object object = FileSystemModel.this.PENDING_REQUESTS;
                    synchronized (object) {
                        fileObject.setPendingRequest(FileSystemModel.this.pendingRequests.contains(fileObject.getId()));
                    }
                    if (this.closure == null) {
                        return fileObject;
                    }
                    this.closure.execute((Object)fileObject);
                }
                return null;
            }
            catch (SQLException sQLException) {
                FileSystemModel.this.recover(sQLException);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetChildren
    extends DatabaseAction<List<Long>> {
        Long id;
        Closure onFinish;

        public GetChildren(Long l, Closure closure) {
            super(Priority.QUERY);
            this.id = l;
            this.onFinish = closure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Long> call() throws Exception {
            if (this.id != null) {
                FileSystemModel.this.listOfChildren.setLong(1, this.id);
                ResultSet resultSet = FileSystemModel.this.listOfChildren.executeQuery();
                if (resultSet != null) {
                    try {
                        Vector<Long> vector = new Vector<Long>();
                        while (resultSet.next()) {
                            vector.add(resultSet.getLong(1));
                        }
                        if (this.onFinish != null) {
                            this.onFinish.execute(vector);
                        }
                        Vector<Long> vector2 = vector;
                        return vector2;
                    }
                    finally {
                        resultSet.close();
                    }
                }
            }
            return Collections.emptyList();
        }
    }

    private class FindFile2
    implements Runnable {
        private FindFile2() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                FindFile[] findFileArray = null;
                Object object = FileSystemModel.this.PENDING_FINDS;
                synchronized (object) {
                    findFileArray = FileSystemModel.this.pendingFinds.toArray(new FindFile[FileSystemModel.this.pendingFinds.size()]);
                    FileSystemModel.this.pendingFinds.clear();
                }
                FileSystemModel.this.connection.setAutoCommit(false);
                try {
                    this.create(findFileArray);
                    this.find(findFileArray);
                }
                finally {
                    FileSystemModel.this.connection.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {
                FileSystemModel.this.recover(sQLException);
            }
        }

        public void create(FindFile[] findFileArray) throws SQLException {
            for (FindFile findFile : findFileArray) {
                if (!findFile.create) continue;
                FileSystemModel.this.createFileBatch.setString(1, findFile.name);
                FileSystemModel.this.createFileBatch.setLong(2, findFile.parentId);
                FileSystemModel.this.createFileBatch.addBatch();
            }
            FileSystemModel.this.createFileBatch.executeBatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void find(FindFile[] findFileArray) throws SQLException {
            for (FindFile findFile : findFileArray) {
                FileObject fileObject = findFile.findFile();
                Object object = FileSystemModel.this.PENDING_REQUESTS;
                synchronized (object) {
                    fileObject.setPendingRequest(FileSystemModel.this.pendingRequests.contains(fileObject.getId()));
                }
                if (fileObject == null || findFile.onFinish == null) continue;
                onFinishExec.submit(new ExecuteClosure(fileObject, findFile.onFinish));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindFile
    extends DatabaseAction<FileObject> {
        long parentId;
        String name;
        boolean create;
        String path;
        boolean simple;
        Closure onFinish;

        public FindFile(long l, String string, boolean bl, TaskId taskId, CommandType commandType, Calendar calendar, String string2, boolean bl2, Closure closure) {
            super(Priority.QUERY);
            this.parentId = l;
            this.name = string;
            this.create = bl;
            this.path = string2;
            this.simple = bl2;
            this.onFinish = closure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileObject call() throws Exception {
            if (FileSystemModel.this.status == Status.Exception) {
                return null;
            }
            FileObject fileObject = null;
            fileObject = this.findFile();
            if (fileObject != null) {
                return fileObject;
            }
            fileObject = null;
            try {
                fileObject = this.createFile();
                if (fileObject != null) {
                    FileSystemModel.this.createAttributes(fileObject.getId());
                } else {
                    fileObject = this.findFile();
                }
                if (fileObject != null && this.onFinish != null) {
                    onFinishExec.submit(new ExecuteClosure(fileObject, this.onFinish));
                    FileObject fileObject2 = null;
                    return fileObject2;
                }
                FileObject fileObject3 = fileObject;
                return fileObject3;
            }
            catch (SQLException sQLException) {
                FileSystemModel.this.recover(sQLException);
                FileObject fileObject4 = null;
                return fileObject4;
            }
            finally {
                if (fileObject != null) {
                    FileSystemModel.this.fireFileChanged(fileObject);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject createFile() throws SQLException {
            block8: {
                if (!this.create) {
                    return null;
                }
                FileSystemModel.this.createFile.setString(1, this.name);
                FileSystemModel.this.createFile.setLong(2, this.parentId);
                if (FileSystemModel.this.autoGenerated) {
                    FileSystemModel.this.createFile.executeUpdate();
                    ResultSet resultSet = FileSystemModel.this.createFile.getGeneratedKeys();
                    try {
                        if (resultSet.next()) {
                            FileObject fileObject = new FileObject(FileSystemModel.this, resultSet.getInt(1));
                            fileObject.setParent(this.parentId);
                            fileObject.setName(this.name);
                            FileObject fileObject2 = fileObject;
                            return fileObject2;
                        }
                        break block8;
                    }
                    finally {
                        resultSet.close();
                    }
                }
                FileSystemModel.this.createFile.executeUpdate();
                if (FileSystemModel.this.createFile.getUpdateCount() > 0) {
                    FileSystemModel.this.findFileSimple.setLong(1, this.parentId);
                    FileSystemModel.this.findFileSimple.setString(2, this.name);
                    ResultSet resultSet = FileSystemModel.this.findFileSimple.executeQuery();
                    List<FileObject> list = FileObject.getFiles(FileSystemModel.this, resultSet, null, 1);
                    if (list.size() != 0) {
                        FileObject fileObject = list.get(0);
                        FileSystemModel.this.createAttributes(fileObject.getId());
                        return fileObject;
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject findFile() throws SQLException {
            List<FileObject> list;
            PreparedStatement preparedStatement = FileSystemModel.this.findFile;
            if (this.simple) {
                preparedStatement = FileSystemModel.this.findFileSimple;
            }
            preparedStatement.setLong(1, this.parentId);
            preparedStatement.setString(2, this.name);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet != null && (list = FileObject.getFiles(FileSystemModel.this, resultSet, this.path, 1)).size() > 0) {
                FileObject fileObject = list.get(0);
                if (fileObject != null) {
                    Object object = FileSystemModel.this.PENDING_REQUESTS;
                    synchronized (object) {
                        fileObject.setPendingRequest(FileSystemModel.this.pendingRequests.contains(fileObject.getId()));
                    }
                    FileSystemModel.this.fireFileChanged(fileObject);
                }
                return fileObject;
            }
            return null;
        }
    }

    private class DumpHistory
    implements Runnable {
        Long id;
        PrintStream out;

        public DumpHistory(Long l, PrintStream printStream) {
            this.id = l;
            this.out = printStream;
        }

        public void run() {
            if (FileSystemModel.this.status == Status.Exception) {
                return;
            }
            try {
                FileSystemModel.this.dumpHistory.setLong(1, this.id);
                ResultSet resultSet = FileSystemModel.this.dumpHistory.executeQuery();
                String string = "-------------------------------------------------------------";
                this.out.println(string);
                while (resultSet.next()) {
                    String string2;
                    Guid guid;
                    this.out.printf("%6d | %11s | %s\n", new Object[]{resultSet.getInt("TASKID"), CommandType.values()[resultSet.getInt("COMMAND")], ActionType.values()[resultSet.getInt("ACTION")].getAction(CommandType.values()[resultSet.getInt("COMMAND")], resultSet.getString("ARGUMENT"))});
                    int n = resultSet.getInt("TASKID");
                    TaskId taskId = TaskId.GenerateTaskId((int)n, (Operation)FileSystemModel.this.core.getOperationById(Guid.GenerateGuid((Guid)(guid = Guid.GenerateGuid((String)(string2 = resultSet.getString("OPERATION")))))));
                    Task task = FileSystemModel.this.core.getTaskById(taskId);
                    if (task == null) continue;
                    this.out.printf("%6s   %s\n", "", task.getFullCommandLine());
                }
                this.out.println(string);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddHistoryItem
    extends DatabaseAction<Object> {
        FileObject fileObject;
        TaskId task;
        ActionType action;
        CommandType command;
        Calendar timestamp;
        String arg;

        public AddHistoryItem(FileObject fileObject, TaskId taskId, ActionType actionType, CommandType commandType, Calendar calendar, String string) {
            super(Priority.SAVE_HISTORY);
            this.fileObject = fileObject;
            this.task = taskId;
            this.action = actionType;
            this.command = commandType;
            this.timestamp = calendar == null ? Calendar.getInstance() : calendar;
            this.arg = string;
        }

        @Override
        public Object call() throws Exception {
            if (FileSystemModel.this.status == Status.Exception) {
                return null;
            }
            if (this.fileObject == null) {
                return null;
            }
            try {
                FileSystemModel.this.addHistory.setLong(1, this.fileObject.getId());
                FileSystemModel.this.addHistory.setString(2, this.task.getOperation().getGuid().asString());
                FileSystemModel.this.addHistory.setInt(3, this.task.getId());
                FileSystemModel.this.addHistory.setInt(4, this.action.ordinal());
                FileSystemModel.this.addHistory.setInt(5, this.command.ordinal());
                FileSystemModel.this.addHistory.setTimestamp(6, new Timestamp(this.timestamp.getTimeInMillis()), this.timestamp);
                FileSystemModel.this.addHistory.setString(7, this.arg);
                FileSystemModel.this.addHistory.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                FileSystemModel.this.recover(sQLException);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class DatabaseAction<E>
    implements Callable<E> {
        Priority priority;

        public DatabaseAction(Priority priority) {
            this.priority = priority;
        }

        public Priority getPriority() {
            return this.priority;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        Starting,
        Running,
        Exception;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        QUERY,
        SAVE_DETAILS,
        SAVE_ATTRIBUTES,
        SAVE_HISTORY;

    }
}

