/*
 * Decompiled with CFR 0.152.
 */
package ddb.targetmodel.filemodel.listeners;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.data.ObjectValue;
import ddb.dsz.core.task.TaskId;
import ddb.targetmodel.filemodel.FileObject;
import ddb.targetmodel.filemodel.FileObjectFields;
import ddb.targetmodel.filemodel.FileSystemModel;
import ddb.targetmodel.filemodel.history.ActionType;
import ddb.targetmodel.filemodel.history.CommandType;
import ddb.targetmodel.filemodel.listeners.FileManagerDataListener;
import ddb.util.GeneralUtilities;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DirListener
extends FileManagerDataListener {
    static final Map<String, FileObjectFields> attributeLookup = new HashMap<String, FileObjectFields>();

    public DirListener(CoreController coreController, FileSystemModel fileSystemModel) {
        super(coreController, fileSystemModel);
    }

    protected void handleData(DataEvent dataEvent) {
        switch (dataEvent.getDataType()) {
            case DATA: {
                if (dataEvent.getData().getObject("diritem") == null) break;
                List list = dataEvent.getData().getObjects("DirItem");
                for (ObjectValue objectValue : list) {
                    String string = objectValue.getString("path");
                    if (string.length() == 3) {
                        System.out.printf("%s = %s, %d\n", string, SimpleDateFormat.getTimeInstance().format(Calendar.getInstance().getTime()), Runtime.getRuntime().totalMemory());
                    }
                    this.model.getNodeForPath(string, true, CommandType.DIR, dataEvent.getTaskId(), dataEvent.getTimestamp(), true, new FillinDirectory(this.model, objectValue, dataEvent.getTaskId(), dataEvent.getTimestamp()));
                }
                break;
            }
        }
    }

    static {
        attributeLookup.put("offline", FileObjectFields.Attr_Offline);
        attributeLookup.put("characterspecialfile", FileObjectFields.Attr_CharacterSpecialFile);
        attributeLookup.put("archive", FileObjectFields.Attr_Archive);
        attributeLookup.put("namedpipe", FileObjectFields.Attr_NamedPipe);
        attributeLookup.put("symboliclink", FileObjectFields.Attr_SymbolicLink);
        attributeLookup.put("compressed", FileObjectFields.Attr_Compressed);
        attributeLookup.put("encrypted", FileObjectFields.Attr_Encrypted);
        attributeLookup.put("blockspecialfile", FileObjectFields.Attr_BlockSpecialFile);
        attributeLookup.put("afunixfamilysocket", FileObjectFields.Attr_UnixFamilySocket);
        attributeLookup.put("hidden", FileObjectFields.Attr_Hidden);
        attributeLookup.put("temporary", FileObjectFields.Attr_Temporary);
        attributeLookup.put("reparsepoint", FileObjectFields.Attr_ReparsePoint);
        attributeLookup.put("system", FileObjectFields.Attr_System);
        attributeLookup.put("read-only", FileObjectFields.Attr_ReadOnly);
        attributeLookup.put("group", FileObjectFields.Attr_Group_Name);
        attributeLookup.put("owner", FileObjectFields.Attr_Owner_Name);
        attributeLookup.put("groupid", FileObjectFields.Attr_Group_Id);
        attributeLookup.put("ownerid", FileObjectFields.Attr_Owner_Id);
    }

    private class FillinDirectory
    extends FileManagerDataListener.DataClosure {
        ObjectValue directory;
        TaskId taskId;
        Calendar timestamp;

        public FillinDirectory(FileSystemModel fileSystemModel, ObjectValue objectValue, TaskId taskId, Calendar calendar) {
            super(DirListener.this, true, fileSystemModel);
            this.directory = objectValue;
            this.taskId = taskId;
            this.timestamp = calendar;
        }

        public void executeChild(Object object) {
            if (object == null || !(object instanceof FileObject)) {
                return;
            }
            FileObject fileObject = (FileObject)object;
            fileObject.setDirectory();
            String string = this.directory.getString("denied");
            if (string != null && string.equals("true")) {
                fileObject.setDataElement(FileObjectFields.Dir_AccessDenied, (Object)true);
                return;
            }
            fileObject.setDataElement(FileObjectFields.Dir_AccessDenied, (Object)false);
            List list = this.directory.getObjects("FileItem");
            for (ObjectValue objectValue : list) {
                String string2 = objectValue.getString("name");
                if (string2 == null || string2.equals(".") || string2.equals("..")) continue;
                this.model.getChildNode(fileObject, string2, true, CommandType.DIR, this.taskId, this.timestamp, true, new FillinFileObject(this.model, objectValue, this.taskId, this.timestamp));
            }
        }
    }

    private class FillinFileObject
    extends FileManagerDataListener.DataClosure {
        ObjectValue file;
        TaskId taskId;
        Calendar timestamp;

        public FillinFileObject(FileSystemModel fileSystemModel, ObjectValue objectValue, TaskId taskId, Calendar calendar) {
            super(DirListener.this, false, fileSystemModel);
            this.file = objectValue;
            this.taskId = taskId;
            this.timestamp = calendar;
        }

        public void executeChild(Object object) {
            Object object22;
            if (object == null || !(object instanceof FileObject)) {
                return;
            }
            FileObject fileObject = (FileObject)object;
            fileObject.setDataElement(FileObjectFields.File_AlternateName, (Object)this.file.getString("altName"));
            fileObject.setDataElement(FileObjectFields.File_Accessed, (Object)GeneralUtilities.stringToCalendar((String)this.file.getString("FileTimes::Accessed::time"), null));
            fileObject.setDataElement(FileObjectFields.File_Modified, (Object)GeneralUtilities.stringToCalendar((String)this.file.getString("FileTimes::Modified::time"), null));
            fileObject.setDataElement(FileObjectFields.File_Created, (Object)GeneralUtilities.stringToCalendar((String)this.file.getString("FileTimes::Created::time"), null));
            if (!this.file.getBoolean("Attributes::directory").booleanValue()) {
                fileObject.setDataElement(FileObjectFields.File_Size, (Object)this.file.getInteger("size"));
            } else {
                fileObject.setDirectory();
            }
            ObjectValue objectValue = this.file.getObject("Attributes");
            for (Object object22 : objectValue.getBooleanNames()) {
                fileObject.setDataElement(attributeLookup.get(object22), (Object)objectValue.getBoolean((String)object22));
            }
            for (Object object22 : objectValue.getStringNames()) {
                fileObject.setDataElement(attributeLookup.get(object22), (Object)objectValue.getString((String)object22));
            }
            objectValue = this.file.getObject("Unix-Specific");
            for (Object object22 : objectValue.getBooleanNames()) {
                fileObject.setDataElement(attributeLookup.get(object22), (Object)objectValue.getBoolean((String)object22));
            }
            for (Object object22 : objectValue.getStringNames()) {
                fileObject.setDataElement(attributeLookup.get(object22), (Object)objectValue.getString((String)object22));
            }
            List list = this.file.getObjects("hash");
            object22 = list.iterator();
            while (object22.hasNext()) {
                ObjectValue objectValue2 = (ObjectValue)object22.next();
                String string = objectValue2.getString("type");
                String string2 = objectValue2.getString("value");
                for (FileObjectFields fileObjectFields : FileObjectFields.HashFields) {
                    if (!fileObjectFields.getName().equalsIgnoreCase(string)) continue;
                    fileObject.setDataElement(fileObjectFields, (Object)string2);
                }
            }
            fileObject.save();
            this.model.addHistoryItem(fileObject, this.taskId, ActionType.INFO, CommandType.DIR, this.timestamp);
        }
    }
}

