/*
 * Decompiled with CFR 0.152.
 */
package ddb.autocomplete;

import ddb.autocomplete.CompletionService;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteDocument
extends PlainDocument {
    private CompletionService<?> completionService;
    private JTextComponent documentOwner;

    public AutoCompleteDocument(CompletionService<?> completionService, JTextComponent jTextComponent) {
        this.completionService = completionService;
        this.documentOwner = jTextComponent;
    }

    protected String complete(String string) {
        Object obj = this.completionService.autoComplete(string);
        return obj == null ? null : obj.toString();
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = this.getText(0, n);
        String string3 = this.complete(string2 + string);
        int n2 = n + string.length();
        if (string3 != null && string2.length() > 0) {
            string = string3.substring(Math.max(0, n2 - 1));
            super.insertString(n, string, attributeSet);
            this.documentOwner.select(n2, this.getLength());
        } else {
            super.insertString(n, string, attributeSet);
        }
    }
}

