/*
 * Decompiled with CFR 0.152.
 */
package ddb.bcb.ui;

import ddb.bcb.BreadcrumbBar;
import ddb.bcb.ui.BreadcrumbBarUI;
import ddb.bcb.ui.BreadcrumbParticle;
import ddb.bcb.ui.ChoicesSelector;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class BasicBreadcrumbParticleUI
extends BasicLabelUI {
    protected BreadcrumbParticle particle;
    protected FocusListener baseFocusListener;
    protected MouseListener baseMouseListener;
    protected KeyListener baseKeyListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicBreadcrumbParticleUI();
    }

    public void installUI(JComponent jComponent) {
        this.particle = (BreadcrumbParticle)jComponent;
        this.installDefaults(this.particle);
        this.installComponents(this.particle);
        this.installListeners(this.particle);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        this.uninstallListeners((BreadcrumbParticle)jComponent);
        this.uninstallComponents((BreadcrumbParticle)jComponent);
        this.uninstallDefaults((BreadcrumbParticle)jComponent);
        this.particle = null;
    }

    protected void installDefaults(BreadcrumbParticle breadcrumbParticle) {
        Font font = UIManager.getFont("BreadcrumbBar.font");
        if (font == null) {
            font = new Font("Tahoma", 0, 11);
        }
        breadcrumbParticle.setFont(font);
        breadcrumbParticle.setCursor(Cursor.getPredefinedCursor(12));
        breadcrumbParticle.setBorder(new EmptyBorder(0, 2, 0, 2));
    }

    protected void installComponents(BreadcrumbParticle breadcrumbParticle) {
    }

    protected void installListeners(final BreadcrumbParticle breadcrumbParticle) {
        this.baseFocusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                breadcrumbParticle.getModel().setArmed(true);
                breadcrumbParticle.getBar().repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                breadcrumbParticle.getModel().setArmed(false);
                breadcrumbParticle.getBar().repaint();
            }
        };
        breadcrumbParticle.addFocusListener(this.baseFocusListener);
        this.baseMouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                breadcrumbParticle.getModel().setRollover(true);
                breadcrumbParticle.getBar().repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                breadcrumbParticle.getModel().setRollover(false);
                breadcrumbParticle.getBar().repaint();
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 16) {
                    breadcrumbParticle.validateElement();
                } else if (System.getProperty("os.name").startsWith("Mac") || System.getProperty("mrj.version") != null) {
                    if ((!mouseEvent.isAltDown() || mouseEvent.isControlDown()) && mouseEvent.isPopupTrigger() && breadcrumbParticle.getBar().getPopupListener() != null) {
                        breadcrumbParticle.getBar().getPopupListener().mouseClicked(mouseEvent);
                    }
                } else if (mouseEvent.getModifiers() == 4 && breadcrumbParticle.getBar().getPopupListener() != null) {
                    breadcrumbParticle.getBar().getPopupListener().mouseClicked(mouseEvent);
                }
            }
        };
        breadcrumbParticle.addMouseListener(this.baseMouseListener);
        this.baseKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 40) {
                    breadcrumbParticle.getBar().getUI().popup(breadcrumbParticle.getIndex());
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (!(keyEvent.getSource() instanceof JLabel)) {
                    return;
                }
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
                if (keyEvent.getKeyChar() == '\n') {
                    breadcrumbParticle.validateElement();
                    return;
                }
            }
        };
        breadcrumbParticle.addKeyListener(this.baseKeyListener);
    }

    protected void uninstallDefaults(BreadcrumbParticle breadcrumbParticle) {
    }

    protected void uninstallComponents(BreadcrumbParticle breadcrumbParticle) {
    }

    protected void uninstallListeners(BreadcrumbParticle breadcrumbParticle) {
        breadcrumbParticle.removeKeyListener(this.baseKeyListener);
        this.baseKeyListener = null;
        breadcrumbParticle.removeMouseListener(this.baseMouseListener);
        this.baseMouseListener = null;
        breadcrumbParticle.removeFocusListener(this.baseFocusListener);
        this.baseFocusListener = null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        boolean bl2 = bl = this.particle.getModel().isSelected() || this.particle.getModel().isArmed() || this.particle.getModel().isRollover();
        if (bl) {
            BreadcrumbBar breadcrumbBar = this.particle.getBar();
            BreadcrumbBarUI breadcrumbBarUI = breadcrumbBar.getUI();
            ChoicesSelector choicesSelector = breadcrumbBarUI.getSelector(this.particle.getIndex() + 1);
            this.paintSelectedBackground(graphics2D, jComponent, choicesSelector);
        }
        super.paint(graphics, jComponent);
        if (bl) {
            this.paintSelectedForeground(graphics2D, jComponent);
        }
        graphics2D.dispose();
    }

    protected void paintSelectedBackground(Graphics2D graphics2D, JComponent jComponent, ChoicesSelector choicesSelector) {
    }

    protected void paintSelectedForeground(Graphics2D graphics2D, JComponent jComponent) {
        graphics2D.setColor(this.particle.getBar().getUnderlineColor() == null ? this.particle.getForeground() : this.particle.getBar().getUnderlineColor());
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = jComponent.getInsets(insets);
        rectangle.x = insets2.left;
        rectangle.y = insets2.top;
        rectangle.width = jComponent.getWidth() - (insets2.left + insets2.right);
        rectangle.height = jComponent.getHeight() - (insets2.top + insets2.bottom);
        SwingUtilities.layoutCompoundLabel(this.particle, this.particle.getFontMetrics(this.particle.getFont()), this.particle.getText(), this.particle.getIcon(), this.particle.getVerticalAlignment(), this.particle.getHorizontalAlignment(), this.particle.getVerticalTextPosition(), this.particle.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, this.particle.getIconTextGap());
        graphics2D.drawLine(rectangle3.x, rectangle3.y + rectangle3.height, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height);
    }
}

