/*
 * Decompiled with CFR 0.152.
 */
package ddb.detach;

import ddb.detach.Alignment;
import ddb.detach.CloseTabbableAction;
import ddb.detach.DetachTabbableDisplayAction;
import ddb.detach.MutableTabbableStatus;
import ddb.detach.Tabbable;
import ddb.detach.TabbableFrame;
import ddb.detach.TabbableStatus;
import ddb.detach.TabbableStatusImpl;
import ddb.detach.Workbench;
import ddb.imagemanager.ImageManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public abstract class AbstractTabbable
implements Tabbable {
    protected static final PropertyChangeListener updateTabRenderer = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof AbstractTabbable) {
                ((AbstractTabbable)AbstractTabbable.class.cast(propertyChangeEvent.getSource())).setDisplayedName();
            }
        }
    };
    protected final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected Color nameColor = Color.BLACK;
    private JComponent subDisplay;
    private JPanel mainDisplay;
    protected EventListenerList allListeners = new EventListenerList();
    protected Tabbable.TabState state = Tabbable.TabState.TABBED;
    protected Tabbable.TabState previous = Tabbable.TabState.TABBED;
    protected Alignment alignment = Alignment.CENTER;
    protected Workbench workbench;
    private JPanel _titleBar = null;
    private JLabel _title;
    private boolean verifyClose = true;
    private boolean showButtons = true;
    private boolean selected = false;
    protected final MutableTabbableStatus status;
    protected TabbableFrame frame = null;
    protected Dimension frameSize = null;
    protected Point frameSite = null;
    private String name;
    private String description;
    private String logo;
    private boolean hideable;
    private boolean unhideable;
    private boolean detachable;
    protected JPanel tabRenderDisplay = new JPanel();
    private JLabel tabNameDisplay = new JLabel();
    private JLabel tabIconDisplay = new JLabel();
    private Font baseFont = UIManager.getFont("Label.font");
    int colorCycle = 0;
    protected final Runnable FireContentsChanged = new Runnable(){

        public void run() {
            AbstractTabbable.this.fireContentsChanged();
        }
    };
    protected final Runnable FireContentsChangedRequestFocus = new Runnable(){

        public void run() {
            AbstractTabbable.this.fireContentsChangedRequestFocus();
        }
    };

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected abstract JComponent getTabbableSpecificRenderComponent();

    public JComponent getTabComponent() {
        return this.tabRenderDisplay;
    }

    public void fini() {
        this.status.fini();
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    public boolean isDetachable() {
        return this.detachable;
    }

    public boolean isHideable() {
        return this.hideable;
    }

    public boolean isUnhideable() {
        return this.unhideable;
    }

    public void setFrame(TabbableFrame tabbableFrame) {
        TabbableFrame tabbableFrame2 = this.frame;
        this.frame = tabbableFrame;
        this.changeSupport.firePropertyChange("TABBABLE_FRAME", tabbableFrame2, tabbableFrame);
    }

    public TabbableFrame getFrame() {
        return this.frame;
    }

    public synchronized Tabbable.TabState getCurrentState() {
        return this.state;
    }

    public synchronized Tabbable.TabState getPreviousState() {
        return this.previous;
    }

    public String getShortDescription() {
        return this.description;
    }

    protected void setShortDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.changeSupport.firePropertyChange("TABBABLE_SHORT_DESCRIPTION", string2, string);
    }

    public void setLogo(String string, Dimension dimension) {
        String string2 = this.logo;
        this.logo = string;
        this.tabIconDisplay.setIcon(ImageManager.getIcon(string, dimension));
        this.changeSupport.firePropertyChange("TABBABLE_LOGO", string2, string);
    }

    public void setLogo(Icon icon) {
        this.tabIconDisplay.setIcon(icon);
    }

    protected void setHideable(boolean bl) {
        boolean bl2 = this.hideable;
        this.hideable = bl;
        this.changeSupport.firePropertyChange("TABBABLE_HIDEABLE", bl2, bl);
    }

    protected void setUnhideable(boolean bl) {
        boolean bl2 = this.unhideable;
        this.unhideable = bl;
        this.changeSupport.firePropertyChange("TABBABLE_UNHIDEABLE", bl2, bl);
    }

    protected void setDetachable(boolean bl) {
        boolean bl2 = this.detachable;
        this.detachable = bl;
        this.changeSupport.firePropertyChange("TABBABLE_DETACHABLE", bl2, bl);
    }

    public String getLogo() {
        return this.logo;
    }

    public JComponent getHeader() {
        return null;
    }

    protected void setShowButtons(boolean bl) {
        boolean bl2 = this.showButtons;
        this.showButtons = bl;
        this.changeSupport.firePropertyChange("TABBABLE_SHOW_BUTTONS", bl2, bl);
    }

    public boolean ShowButtons() {
        return this.showButtons;
    }

    public void setVerifyClose(boolean bl) {
        boolean bl2 = this.verifyClose;
        this.verifyClose = bl;
        this.changeSupport.firePropertyChange("TABBABLE_VERIFY_CLOSE", bl2, bl);
    }

    public boolean isVerifyClose() {
        return this.verifyClose;
    }

    protected void registerDisplay(JComponent jComponent) {
        JComponent jComponent2 = this.subDisplay;
        this.subDisplay = jComponent;
        this.mainDisplay.add((Component)this.subDisplay, "Center");
        this.changeSupport.firePropertyChange("TABBABLE_DISPLAY", jComponent2, jComponent);
    }

    public JComponent getDisplay() {
        return this.mainDisplay;
    }

    protected void fireContentsChanged() {
        this.changeSupport.firePropertyChange("TABBABLE_CONTENT_CHANGED", false, true);
    }

    protected void fireContentsChangedRequestFocus() {
        this.changeSupport.firePropertyChange("TABBABLE_CONTENT_CHANGED_REQUEST_FOCUS", false, true);
    }

    public synchronized boolean isDetached() {
        return this.state == Tabbable.TabState.DETACHED;
    }

    public synchronized boolean isHidden() {
        return this.state == Tabbable.TabState.HIDDEN;
    }

    public synchronized boolean isTabbed() {
        return this.state == Tabbable.TabState.TABBED;
    }

    public synchronized boolean wasDetached() {
        return this.previous == Tabbable.TabState.DETACHED;
    }

    public synchronized boolean wasHidden() {
        return this.previous == Tabbable.TabState.HIDDEN;
    }

    public synchronized boolean wasTabbed() {
        return this.previous == Tabbable.TabState.TABBED;
    }

    public boolean isClosable() {
        return true;
    }

    public boolean isUserClosable() {
        return true;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        Alignment alignment2 = this.alignment;
        this.alignment = alignment;
        this.changeSupport.firePropertyChange("TABBABLE_ALIGNMENT", alignment2, alignment);
    }

    public void setDetached() {
        this.setState(Tabbable.TabState.DETACHED);
    }

    public void setHidden() {
        this.setState(Tabbable.TabState.HIDDEN);
    }

    public void setTabbed() {
        this.setState(Tabbable.TabState.TABBED);
    }

    public synchronized void setState(Tabbable.TabState tabState) {
        this.previous = this.state;
        this.state = tabState;
        if (tabState == Tabbable.TabState.DETACHED) {
            this.generateFloatingTitle();
        } else if (tabState == Tabbable.TabState.TABBED) {
            this.generateDockedTitle();
        }
        if (!Tabbable.TabState.TABBED.equals((Object)tabState)) {
            this.setSelected(false);
        }
        this.changeSupport.firePropertyChange("TABBABLE_STATE", (Object)this.previous, (Object)tabState);
    }

    public JMenuBar getMenuBar() {
        return null;
    }

    public TabbableStatus getStatus() {
        return this.status;
    }

    protected void setStatus(String string) {
        this.status.setDetails(string);
        this.status.notifyObservers();
    }

    public Dimension getPreferredSize() {
        return this.subDisplay.getPreferredSize();
    }

    public AbstractTabbable() {
        this.status = new TabbableStatusImpl(this);
        JComponent jComponent = this.getTabbableSpecificRenderComponent();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tabRenderDisplay.setLayout(gridBagLayout);
        int n = 1;
        if (jComponent != null) {
            n = 2;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = n;
        this.tabRenderDisplay.add((Component)this.tabIconDisplay, gridBagConstraints);
        gridBagLayout.addLayoutComponent(this.tabIconDisplay, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        this.tabRenderDisplay.add((Component)this.tabNameDisplay, gridBagConstraints);
        gridBagLayout.addLayoutComponent(this.tabNameDisplay, gridBagConstraints);
        if (jComponent != null) {
            gridBagConstraints.gridy = 1;
            this.tabRenderDisplay.add((Component)jComponent, gridBagConstraints);
            gridBagLayout.addLayoutComponent(jComponent, gridBagConstraints);
        }
        this.tabRenderDisplay.setOpaque(false);
        this.mainDisplay = new JPanel();
        this.mainDisplay.setLayout(new BorderLayout());
        this._title = new JLabel();
        this._title.setFont(this._title.getFont().deriveFont(12).deriveFont(1));
        this.addPropertyChangeListener("TABBABLE_NAME", updateTabRenderer);
        this.addPropertyChangeListener("TABBABLE_NAME_COLOR_CHANGED", updateTabRenderer);
    }

    public void setWorkbench(Workbench workbench) {
        Workbench workbench2 = this.workbench;
        this.workbench = workbench;
        this.changeSupport.firePropertyChange("TABBABLE_WORKBENCH", workbench2, workbench);
    }

    public Workbench getWorkbench() {
        return this.workbench;
    }

    public void generateDockedTitle() {
        JComponent jComponent;
        if (this._titleBar != null) {
            this.mainDisplay.remove(this._titleBar);
        }
        if (!this.ShowButtons() && this.getMenuBar() == null) {
            this._titleBar = null;
            return;
        }
        this._titleBar = new JPanel(new BorderLayout());
        JMenuBar jMenuBar = this.getMenuBar();
        if (jMenuBar != null) {
            this._titleBar.add((Component)jMenuBar, "West");
        }
        if ((jComponent = this.getHeader()) != null) {
            this._titleBar.add((Component)jComponent, "Center");
        }
        if (this.ShowButtons()) {
            this._titleBar.add((Component)this.generateButtonPanel(false), "East");
        }
        this.mainDisplay.add((Component)this._titleBar, "North");
    }

    public void generateFloatingTitle() {
        if (this._titleBar != null) {
            this.mainDisplay.remove(this._titleBar);
        }
        this._titleBar = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._titleBar.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        JPanel jPanel = this.generateButtonPanel(true);
        this._titleBar.add(jPanel);
        gridBagLayout.addLayoutComponent(jPanel, gridBagConstraints);
        JMenuBar jMenuBar = this.getMenuBar();
        JComponent jComponent = this.getHeader();
        if (jMenuBar != null && jComponent != null) {
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            this._titleBar.add(jMenuBar);
            gridBagLayout.addLayoutComponent(jMenuBar, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            this._titleBar.add(jComponent);
            gridBagLayout.addLayoutComponent(jComponent, gridBagConstraints);
        } else if (jMenuBar != null) {
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            this._titleBar.add(jMenuBar);
            gridBagLayout.addLayoutComponent(jMenuBar, gridBagConstraints);
        } else if (jComponent != null) {
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            this._titleBar.add(jComponent);
            gridBagLayout.addLayoutComponent(jComponent, gridBagConstraints);
        } else {
            JPanel jPanel2 = this._titleBar;
            this._titleBar = new JPanel(new BorderLayout());
            this._titleBar.add((Component)jPanel2, "East");
        }
        this.mainDisplay.add((Component)this._titleBar, "North");
    }

    private JPanel generateButtonPanel(boolean bl) {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        if (!bl) {
            jPanel.add(this.generateButton("Minimize", "Minimize this plugin", "InternalFrame.iconifyIcon", this.isDetached(), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractTabbable.this.frame.setExtendedState(1);
                }
            }));
        }
        jPanel.add(this.generateButton("Attachment", "Attach/Detatch this plugin", "InternalFrame.minimizeIcon", this.isDetachable() || this.isDetached(), new DetachTabbableDisplayAction(this, this.workbench)));
        if (!bl) {
            jPanel.add(this.generateButton("Maximize", "Maximize this plugin", "InternalFrame.maximizeIcon", this.isDetached(), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AbstractTabbable.this.frame != null) {
                        if ((AbstractTabbable.this.frame.getExtendedState() & 6) == 6) {
                            AbstractTabbable.this.frame.setExtendedState(0);
                        } else {
                            AbstractTabbable.this.frame.setExtendedState(6);
                        }
                    }
                }
            }));
            jPanel.add(this.generateButton("Close", "Close this plugin", "InternalFrame.closeIcon", this.isClosable(), new CloseTabbableAction(this, this.workbench)));
        }
        return jPanel;
    }

    private JButton generateButton(String string, String string2, String string3, boolean bl, ActionListener actionListener) {
        NoFocusButton noFocusButton = new NoFocusButton(string);
        noFocusButton.setIcon(UIManager.getIcon(string3));
        if (string2.length() > 0) {
            noFocusButton.setToolTipText(string2);
        }
        noFocusButton.addActionListener(actionListener);
        noFocusButton.setEnabled(bl);
        return noFocusButton;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.changeSupport.firePropertyChange("TABBABLE_NAME", string2, string);
        this.setDisplayedName();
    }

    public String getName() {
        return this.name;
    }

    protected void setDisplayedName() {
        EventQueue.invokeLater(new SetDisplayedName(this.getDockedTitle()));
    }

    public String getDockedTitle() {
        return this.name;
    }

    public String getDetachedTitle() {
        return this.name;
    }

    public void close() {
    }

    public JComponent getDefaultElement() {
        return null;
    }

    public void hideFrame() {
        if (this.frame == null) {
            return;
        }
        TabbableFrame tabbableFrame = this.frame;
        this.frame = null;
        this.frameSize = tabbableFrame.getSize();
        this.frameSite = tabbableFrame.getLocation();
        tabbableFrame.dispose();
    }

    public int compareTo(Tabbable tabbable) {
        if (this == tabbable) {
            return 0;
        }
        if (tabbable == null) {
            return 1;
        }
        int n = this.alignment.compareTo(tabbable.getAlignment());
        return n;
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.selected;
        this.selected = bl;
        this.changeSupport.firePropertyChange("TABBABLE_SELECTED", bl2, bl);
    }

    protected boolean isSelected() {
        return this.selected && this.workbench.isSelected();
    }

    public Point getFrameLocation() {
        if (this.frame != null) {
            return this.frame.getLocation();
        }
        return this.frameSite;
    }

    public Dimension getFrameSize() {
        if (this.frame != null) {
            return this.frame.getSize();
        }
        return this.frameSize;
    }

    public String toString() {
        return String.format("Tabbable (%s)", this.name);
    }

    public void setDisplayColor(Color color) {
        Color color2 = this.nameColor;
        this.nameColor = color;
        this.changeSupport.firePropertyChange("TABBABLE_NAME_COLOR_CHANGED", color2, color);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AbstractTabbable.this.baseFont != null) {
                    if (AbstractTabbable.this.nameColor.equals(Color.BLACK)) {
                        AbstractTabbable.this.tabNameDisplay.setFont(AbstractTabbable.this.baseFont);
                    } else {
                        AbstractTabbable.this.tabNameDisplay.setFont(AbstractTabbable.this.baseFont.deriveFont(1));
                    }
                }
                AbstractTabbable.this.tabNameDisplay.setForeground(AbstractTabbable.this.nameColor);
            }
        });
    }

    public class SetDisplayedName
    implements Runnable {
        String text;

        public SetDisplayedName(String string) {
            this.text = string;
        }

        public void run() {
            AbstractTabbable.this.tabNameDisplay.setText(this.text);
        }
    }

    private class NoFocusButton
    extends JButton {
        private String uiKey;

        public NoFocusButton(String string) {
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setOpaque(true);
            this.uiKey = string;
        }

        public boolean isFocusable() {
            return false;
        }

        public void requestFocus() {
        }

        public AccessibleContext getAccessibleContext() {
            AccessibleContext accessibleContext = super.getAccessibleContext();
            if (this.uiKey != null) {
                accessibleContext.setAccessibleName(UIManager.getString(this.uiKey));
                this.uiKey = null;
            }
            return accessibleContext;
        }
    }
}

