/*
 * Decompiled with CFR 0.152.
 */
package ddb.memory;

import ddb.memory.MemoryDisplay;
import ddb.memory.MemoryGraph;
import ddb.memory.MemoryText;
import java.awt.BorderLayout;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;

public class MemoryUsage
extends JLayeredPane {
    MemoryGraph graph = new MemoryGraph();
    MemoryText text = new MemoryText();
    Calendar last = null;
    MemoryDisplay[] displays = new MemoryDisplay[]{this.graph, this.text};
    boolean stop = false;

    public MemoryUsage() {
        this.setLayer(this.graph, JLayeredPane.DEFAULT_LAYER);
        this.setLayer(this.text, JLayeredPane.DEFAULT_LAYER);
        this.moveToBack(this.graph);
        this.add(this.graph);
        this.add(this.text);
    }

    public void start() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (!MemoryUsage.this.stop) {
                    long l;
                    Calendar calendar = Calendar.getInstance();
                    long l2 = Runtime.getRuntime().totalMemory();
                    long l3 = Runtime.getRuntime().freeMemory();
                    if (MemoryUsage.this.last == null) {
                        l = 0L;
                        MemoryUsage.this.last = calendar;
                    } else {
                        l = calendar.getTimeInMillis() - MemoryUsage.this.last.getTimeInMillis();
                        MemoryUsage.this.last = calendar;
                    }
                    for (MemoryDisplay memoryDisplay : MemoryUsage.this.displays) {
                        memoryDisplay.setMemory(l3, l2, l);
                    }
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("Memory query");
        thread.start();
    }

    public void stop() {
        this.stop = true;
    }

    public void resume() {
        this.stop = false;
        this.start();
    }

    public static void main() {
        MemoryUsage memoryUsage = new MemoryUsage();
        JFrame jFrame = new JFrame("Memory");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setLayout(new BorderLayout());
        jFrame.add(memoryUsage);
        jFrame.pack();
        jFrame.setVisible(true);
        memoryUsage.start();
    }
}

