/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.logviewer.models;

import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.logviewer.models.CommandModelColumns;
import ddb.util.FrequentlyAppendedTableModel;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandModel
extends FrequentlyAppendedTableModel<CommandModelColumns, Task>
implements TableModel {
    final List<Operation> operations = new Vector<Operation>();

    public Task GetTask(int row) {
        return (Task)super.getRecord(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateRecord(Task newTask) {
        if (newTask == null) {
            return;
        }
        if (newTask.getTypedCommand() == null) {
            return;
        }
        List<Operation> list = this.operations;
        synchronized (list) {
            if (!this.operations.contains(newTask.getId().getOperation())) {
                this.operations.add(newTask.getId().getOperation());
            }
        }
        super.addOrUpdateRecord((Object)newTask);
    }

    public CommandModel() {
        super(CommandModelColumns.class, 1L, TimeUnit.SECONDS);
        super.setComparator(Task.TaskComparator);
    }

    public boolean isCellEditable(int rowIndex, CommandModelColumns columnIndex) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int rowIndex, CommandModelColumns columnIndex) {
        Task task = (Task)super.getRecord(rowIndex);
        if (task == null) {
            return null;
        }
        switch (columnIndex) {
            case ID: {
                return task.getId().getId();
            }
            case OP: {
                List<Operation> list = this.operations;
                synchronized (list) {
                    return this.operations.indexOf(task.getId().getOperation());
                }
            }
            case COMMAND: {
                return task.getCommandName();
            }
            case STATUS: {
                return task.getState();
            }
            case FULLCOMMAND: {
                return task.getTypedCommand();
            }
            case COMMENT: {
                if (task.getTaskLogAccess() != null) {
                    return "";
                }
                if (task.getDataCount() > 0) {
                    return "";
                }
                if (task.getTaskingAccess() != null) {
                    return "";
                }
                return "No Log File";
            }
            case CREATED: {
                return task.getCreated();
            }
            case TARGET: {
                return task.getTargetId();
            }
            case GUID: {
                return task.getId().getOperation();
            }
            case DISPLAY: {
                return task.getDisplayTransform();
            }
            case STORAGE: {
                return task.getStorageTransform();
            }
            case VALID: {
                if (task.getTaskingAccess() != null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case TASK: {
                return task;
            }
        }
        return null;
    }

    public String getColumnName(CommandModelColumns columnIndex) {
        return columnIndex.getName();
    }

    public Class<?> getColumnClass(CommandModelColumns column) {
        return column.getClazz();
    }
}

