﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using FuzzTalk;
using FuzzTalk.Actions;
using FuzzTalkUI.Models;

namespace FuzzTalkUI.ViewModels
{
    public class FuzzTalkActionViewModel : ItemViewModel<FuzzTalkAction>
    {
        private Visibility _TcpConnectVisibility = Visibility.Collapsed;
        
        public Visibility TcpConnectVisibility
        {
        	get { return _TcpConnectVisibility; }
        	set
        	{                
        		_TcpConnectVisibility = value;
        
        		InvokePropertyChanged("TcpConnectVisibility");
        	}
        }

        private Visibility _SendVisibility = Visibility.Collapsed;
        
        public Visibility SendVisibility
        {
        	get { return _SendVisibility; }
        	set
        	{                
        		_SendVisibility = value;
        
        		InvokePropertyChanged("SendVisibility");
        	}
        }

        private Visibility _ReceiveVisibility = Visibility.Collapsed;
        
        public Visibility ReceiveVisibility
        {
        	get { return _ReceiveVisibility; }
        	set
        	{                
        		_ReceiveVisibility = value;
        
        		InvokePropertyChanged("ReceiveVisibility");
        	}
        }

        private Visibility _SendFuzzVisibility = Visibility.Collapsed;
        
        public Visibility SendFuzzVisibility
        {
        	get { return _SendFuzzVisibility; }
        	set
        	{                
        		_SendFuzzVisibility = value;
        
        		InvokePropertyChanged("SendFuzzVisibility");
        	}
        }

        private Visibility _DisconnectVisibility = Visibility.Collapsed;
        
        public Visibility DisconnectVisibility
        {
        	get { return _DisconnectVisibility; }
        	set
        	{                
        		_DisconnectVisibility = value;
        
        		InvokePropertyChanged("DisconnectVisibility");
        	}
        }

        private Visibility _SleepVisibility = Visibility.Collapsed;
        
        public Visibility SleepVisibility
        {
            get { return _SleepVisibility; }
        	set
        	{                
        		_SleepVisibility = value;
        
        		InvokePropertyChanged("SleepVisibility");
        	}
        }

        private Visibility _AttachDebuggerVisibility = Visibility.Collapsed;
        
        public Visibility AttachDebuggerVisibility
        {
        	get { return _AttachDebuggerVisibility; }
        	set
        	{                
        		_AttachDebuggerVisibility = value;
        
        		InvokePropertyChanged("AttachDebuggerVisibility");
        	}
        }

        private Visibility _DetachDebuggerVisibility = Visibility.Collapsed;
        
        public Visibility DetachDebuggerVisibility
        {
        	get { return _DetachDebuggerVisibility; }
        	set
        	{                
        		_DetachDebuggerVisibility = value;
        
        		InvokePropertyChanged("DetachDebuggerVisibility");
        	}
        }

        private FuzzTalkAction[] _dummyCollection;

        public FuzzTalkAction[] DummyCollection
        {
            get { return _dummyCollection; }
            set { _dummyCollection = value; }
        }

        private string _Name;
        
        public string Name
        {
        	get { return _Name; }
        	set
        	{                
        		_Name = value;
        
        		InvokePropertyChanged("Name");
        	}
        }

        public FuzzTalkActionViewModel(FuzzTalkAction Item, FrameworkElement Element, BaseViewModel Parent)
            : base(Item, Element, Parent)
        {
            Init();
        }

        public FuzzTalkActionViewModel(FuzzTalkAction Item, FrameworkElement Element)
            : base(Item, Element)
        {
            Init();
        }

        private void Init()
        {
            var t = Item.GetType();
            _Name = t.ToString();

            _dummyCollection = new[] { Item };

            if (t == typeof(TcpConnect))
                TcpConnectVisibility = Visibility.Visible;
            else if (t == typeof(Send))
                SendVisibility = Visibility.Visible;
            else if (t == typeof(SendFuzz))
                SendFuzzVisibility = Visibility.Visible;
            else if (t == typeof(Receive))
                ReceiveVisibility = Visibility.Visible;
            else if (t == typeof(Disconnect))
                DisconnectVisibility = Visibility.Visible;
            else if (t == typeof(FuzzTalkSleep))
                SleepVisibility = Visibility.Visible;
            else if (t == typeof(AttachDebugger))
                AttachDebuggerVisibility = Visibility.Visible;
            else if (t == typeof(DetachDebugger))
                DetachDebuggerVisibility = Visibility.Visible;
        }
    }
}
