from enum import Enum

class Privs(Enum):
    """
    Class containing the privilege available in glpi
    There are 7 different privs in GLPI (User = Self-Service)

    In glpi:

        mysql> select id, name from glpi_profiles order by id;
        +----+--------------+
        | id | name         |
        +----+--------------+
        |  1 | Self-Service |
        |  2 | Observer     |
        |  3 | Admin        |
        |  4 | Super-Admin  |
        |  5 | Hotliner     |
        |  6 | Technician   |
        |  7 | Supervisor   |
        |  8 | Read-Only    |
        +----+--------------+

        mysql> select * from glpi_profilerights where name="typedoc"
        +-----+-------------+---------+--------+
        | id  | profiles_id | name    | rights |
        +-----+-------------+---------+--------+
        |  21 |           1 | typedoc |      0 |
        |  89 |           2 | typedoc |      1 | # 1 --> READ right
        | 162 |           3 | typedoc |     23 | # 23 --> ALL rights
        | 234 |           4 | typedoc |     23 |
        | 307 |           5 | typedoc |      0 |
        | 378 |           6 | typedoc |      0 |
        | 449 |           7 | typedoc |      0 |
        | 568 |           8 | typedoc |      1 |
        +-----+-------------+---------+--------+
    """
    Unauthenticated = 0
    User = 1
    Observer = 2
    Admin = 3
    Superadmin = 4
    Hotliner = 5
    Technician = 6
    Supervisor = 7
    Readonly = 8

    @classmethod
    def list(cls):
        """
        List the different privileges available
        
        :return: The list of the different available privileges
        :rtype: list
        """
        privs = []
        for priv in cls.__members__:
            privs.append(priv)

        return privs
