from dataclasses import dataclass, field
from typing import List

@dataclass(frozen=True)
class DefaultVersion:
    """Return the Default version number"""
    minimal = "0"
    maximal = "10000000000"

@dataclass(frozen=True)
class VersionRequirement:
    """
    Class containing the min version for the exploit
    and the max version.
    Default is always compatible
    """
    min_version: str = DefaultVersion.minimal
    max_version: str = DefaultVersion.maximal

    def is_default(self):
        """
        Check if the version is the default one or not
        """
        return self.min_version == DefaultVersion.minimal \
               and self.max_version == DefaultVersion.maximal

@dataclass(frozen=True)
class Requirements:
    """
    Class containing all the requirement
    glpi_version is the version required for the glpi instance
    php_version is the version required for the php version used
    os_used is the os needed for the exploit
    api_status is whether or not the api is needed for the exploit
    require_inventory is whether or not the inventory is needed
    """
    glpi_version: VersionRequirement = VersionRequirement()
    php_version: VersionRequirement = VersionRequirement()
    plugin_version: VersionRequirement = VersionRequirement()
    os_used: str = "All"
    api_status: bool = False
    require_inventory: bool = False
