# Honggfuzz

**A security-oriented, feedback-driven, evolutionary fuzzer.**

Honggfuzz is a general-purpose fuzzer that uses code coverage (software and hardware-based) to find bugs. It is multi-process, multi-threaded, and supports persistent fuzzing for extreme speed.

## Key Features

*   **Fast**: Multi-process and multi-threaded engine. unlocking full CPU potential.
*   **Persistent Fuzzing**: Test APIs directly in-process with iteration speeds up to 1M/sec.
*   **Feedback-Driven**: Uses hardware (Intel BTS/PT) and software code coverage to evolve inputs.
*   **Easy**: Can start with an empty corpus and automatically build a valid input set.
*   **Deep Monitoring**: Uses low-level APIs (`ptrace`) to detect hijacked signals and hidden crashes.
*   **Broad Support**: Linux, macOS, Android, NetBSD, FreeBSD, and Windows (Cygwin).

## Installation

### Dependencies

**Linux (Ubuntu/Debian)**
```bash
sudo apt-get install binutils-dev libunwind-dev libblocksruntime-dev clang
```

**macOS**
Requires [Xcode](https://developer.apple.com/xcode/) (10.8+) and `libblocksruntime`.

### Build

```bash
make
# Compilation wrappers are created in hfuzz_cc/
```

## Usage

### 1. Compile Target
Use the provided compiler wrappers to automatically add instrumentation:

```bash
# C code
./hfuzz_cc/hfuzz-clang -o my_target my_target.c

# C++ code
./hfuzz_cc/hfuzz-clang++ -o my_target my_target.cpp
```

### 2. Run Fuzzer
Point it to an input corpus directory (can be empty) and your binary:

```bash
# Basic run
./honggfuzz -i input_dir/ -- ./my_target ___FILE___

# Persistent mode (faster)
./honggfuzz -P -i input_dir/ -- ./my_target
```

*Note: `___FILE___` is a placeholder for the input filename generated by honggfuzz.*

For advanced examples (Apache, OpenSSL, BIND, etc.), check the `examples/` directory.

See [USAGE.md](docs/USAGE.md) for detailed options.

## Trophies

Honggfuzz has discovered major security vulnerabilities in critical software.

### HTTP & Servers
*   **Apache HTTPD**:
    *   CVE-2017-7659 (mod_http2 remote crash)
    *   CVE-2017-9789 (Use-after-free)
    *   CVE-2018-1301, CVE-2018-1302, CVE-2018-1303
*   **OpenSSH**: Pre-auth remote crash (commit 28652bca)
*   **BIND**: Multiple bugs
*   **NGINX Unit**: Infinite loop
*   **ProFTPD**: CVE-2019-18217 (DoS)
*   **Samba**: CVE-2019-14907, CVE-2020-10745, CVE-2021-20277

### Cryptography & SSL
*   **OpenSSL**:
    *   **CVE-2016-6309 (Critical, Potential RCE)**
    *   CVE-2015-1789, CVE-2016-7054, CVE-2017-3731
*   **LibreSSL**: Multiple crashes and invalid frees
*   **BoringSSL**: Uninitialized memory use
*   **Crypto++**: CVE-2016-9939 (Remote DoS)

### Languages & Interpreters
*   **PHP**: WDDX bugs, generic interpreter crashes
*   **Python/Ruby**: Interpreter bugs
*   **Rust**: Panics/safety issues in `regex`, `h2`, `sleep-parser`, `lewton`
*   **Perl**: Multiple interpreter crashes

### Media & Formats
*   **FreeType 2**: CVE-2010-2497 through CVE-2010-2527 (7+ CVEs)
*   **LibTIFF**: Multiple bugs
*   **LibJPEG/Turbo**: Multiple bugs
*   **VLC**: Double-free RCE
*   **Adobe Flash**: CVE-2015-0316
*   **ImageIO (iOS/macOS)**: Multiple security problems (Project Zero)
*   **LibreOffice**: Memory corruption

### System & Utils
*   **Systemd**: Tested by honggfuzz
*   **fwupd**: 17+ bugs found
*   **TCPDump**: Multiple bugs
*   **Rsyslog**: Multiple bugs

*(See [OSS-Fuzz](https://bugs.chromium.org/p/oss-fuzz/issues/list?q=honggfuzz&can=1) for hundreds more)*

## Projects Using Honggfuzz

*   **Google OSS-Fuzz**: Continuous fuzzing for open source software.
*   **Android**: Used by Android Security team.
*   **Rust**: `honggfuzz-rs` crate for fuzzing Rust code.
*   **Bitcoin Core**: Fuzzing infrastructure.
*   **Apache HTTP Server**: CI fuzzing.
*   **Systemd**: CI fuzzing.
*   **Cifasis QuickFuzz**
*   **Mozilla FuzzOS**

## License

Apache License 2.0.

__This is NOT an official Google product__
