#!/usr/bin/env python3
# File: core/Detect.py

import sys
from . import Conn, FullList

# The default file to detect if vulnerable. Should not be changed
DST_FILE = "index.php"


def Scan(url, verbose, outdir, wordlist):
    res = Conn.Connect(1, url + DST_FILE)  # 1 = detection mode in original code

    if verbose > 1:
        print(f"[+] Testing '{url}{DST_FILE}'...\n")

    if res == 1:
        print("[-] Connection error.")
        print("[-] Check if URL is valid and target is up and listening on the specified port.\n")
        sys.exit(1)

    if res == 200:
        print(f"[+] {url} seems exploitable :)\n")
    else:
        print(f"[-] {url} is probably NOT exploitable :(")
        print("[-] You should run the Full Scan module anyway, just in case.\n")

    yes = {"yes", "y", "ye", ""}
    no = {"no", "n"}

    while True:
        choice = input("Would you like to run the Full Scan module? [Y/n]: ").strip().lower()
        if choice in yes:
            FullList.Scan(url, verbose, outdir, wordlist)
            return True
        if choice in no:
            print()
            return False
        print("Please respond with 'yes' or 'no': ", end="")
