---
title: "SNMP Exploiter"
draft: false
description: "Exploits the SNMP vulnerability"
tags: ["exploiter", "snmp", "cve-2020-15862"]
pre: "<i class='fa fa-network-wired'></i> "
---

{{% notice info %}}
The SNMP exploiter exploits [CVE-2020-15862](
https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-15862).
{{% /notice %}}

## SNMP

[SNMP (Simple Network Management Protocol)](
https://en.wikipedia.org/wiki/Simple_Network_Management_Protocol) is an
application-layer protocol used to monitor and manage devices connected over
an IP network such as routers, switches, firewalls, load balancers, servers,
cameras, printers, and wireless devices. An SNMP-managed network consists of
management stations, each having its own local database with information about
the network, know as the MIB (Management Information Base). EXTEND MIB is a
specific part of the MIB that allows administrators to extend functionality by
defining custom MIB objects linked to shell commands or scripts. An SNMP
community string is a form of authentication used to manage access to network
devices and to specify what type of operations can be performed. It is
essentially a plaintext password providing access to network devices'
configurations.

## Exploitation

On some Linux systems, NET-SNMP-EXTEND-MIB is supported by default. This allows
non-root users with access to a read-write community string to run arbitrary
commands on the victim as root.

In versions 1 and 2c of the SNMP protocol, the only means of authentication is
the community string. In these versions of SNMP, community strings are sent as
plaintext in all requests. Version 3 adds user-based authentication and
encryption to the SNMP protocol.

Infection Monkey's SNMP exploiter uses version 2c of the SNMP protocol. It
executes brute-force attacks against SNMP servers by using usernames and
passwords provided by the user (see [configuration](/usage/configuration) for
instructions) as SNMP community strings.

![SNMP Configuration](
/images/island/configuration-page/snmp-exploiter-configuration.png
"SNMP Configuration")

## Mitigation

1. Use SNMPv3 with the authPriv security level, if possible.

1. Treat community strings as passwords.

1. Enable the read-only build option (NETSNMP_NO_WRITE_SUPPORT).

1. Configure SNMP to use read-only community strings.

1. Apply security updates to your Net-SNMP installation.

1. Limit access over SNMP to trusted hosts.

Note that even with only read access, an SNMP server can still expose crucial
information about the network.

## See also
- [SNMP exploiter reference documentation](/reference/exploiters/snmp)
- [The L in Linux Stands for Lateral
  Movement](https://www.akamai.com/blog/security-research/linux-lateral-movement-more-than-ssh)
