---
title: "Zerologon Exploiter"
draft: false
description: "Exploits the Zerologon vulnerability"
tags: ["exploiter", "zerologon", "cve-2020-1472"]
pre: "<i class='fa fa-right-to-bracket'></i> "
---

{{% notice warning %}}
This exploiter is [unsafe for production](#a-note-on-safety)!
{{% /notice %}}

{{% notice info %}}
The Zerologon exploiter exploits [CVE-2020-1472](
https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-1472).
{{% /notice %}}

## Netlogon Remote Protocol

The [Netlogon Remote Protocol (MS-NRPC)](
https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-nrpc) is a
Windows Server process that authenticates users and other services within a
domain. If the Netlogon service is interrupted, the functionality of the domain
controller, whose responsibilities include user authentication, authorization,
and account management, is severely affected.

## Exploitation

Due to a flaw in the cryptographic authentication scheme of Netlogon, an
attacker can bypass authentication and gain administrator-level privileges to
an unpatched machine, including a domain controller, effectively granting the
attacker control over the entire domain.

Infection Monkey's Zerologon exploiter takes advantage of this vulnerability to
steal credentials from the domain controller, which are then used to propagate
to the machine using one of the brute force exploiters (for example, the SMB
exploiter).

![Zerologon Configuration](
/images/island/configuration-page/zerologon-exploiter-configuration.png
"Zerologon Configuration")

## Mitigation

To download the relevant security update and read more, click [here](
https://msrc.microsoft.com/update-guide/en-US/vulnerability/CVE-2020-1472).

## A note on safety

This exploiter is not safe for production or other sensitive environments.
During successful exploitation, the Zerologon exploiter:

* Will temporarily change the target domain controller's password.
* May break the target domain controller's communication with other systems in
  the network, affecting functionality.
* May change the administrator's password.
* Will *attempt* to revert all changes.

While the Zerologon exploiter is usually successful in reverting its changes
and restoring the original passwords, it sometimes fails. Restoring passwords
manually after the Zerologon exploiter has run is nontrivial. For information
on restoring the original passwords, see [manually restoring your password](
#manually-restoring-your-password).

To minimize the risk posed by this exploiter, it is recommended that this
exploiter be run _only_ against VMs with a recent snapshot and _only_ in
testing or staging environments.

## Manually restoring your password

This exploiter attempts to restore the original passwords after exploitation.
It is usually successful, but it sometimes fails. If this exploiter has changed
a password but was unable to restore the original, you can try the following
methods to restore the original password.

### Restore the VM from a recent snapshot

If the affected system is a virtual machine, the simplest way to restore it to
a working state is to revert to a recent snapshot.

### Restore the administrator's password

If you are unable to log in as the administrator, you can follow the
instructions
[here](https://www.top-password.com/knowledge/reset-windows-server-2019-password.html)
to regain access to the system.

### Use Reset-ComputerMachinePassword

If you are able to log in as the administrator, you can use the
[Reset-ComputerMachinePassword](https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.management/reset-computermachinepassword?view=powershell-5.1)
powershell command to restore the domain controller's password.

### Try a Zerologon password restoration tool
If all other approaches fail, you can try the tools and steps found
[here](https://github.com/risksense/zerologon).

## See also
- [Zerologon exploiter reference
  documentation](/reference/exploiters/zerologon)
