---
title: "Malware Masquerade"
draft: false
pre: "<i class='fas fa-mask'></i> "
tags: ["usage"]
---

## Description
**Masquerade** - to assume the appearance of something one is not
[[1](https://www.merriam-webster.com/dictionary/masquerade)]

A common way of detecting and identifying an executable as malware is to write
a detection rule (such as for a tool like YARA) that checks for the existence
of strings or unique byte sequences within a file. The Malware Masquerade
feature allows users to specify strings or arbitrary data (bytes) that will be
injected into the Agent binaries. This enables Infection Monkey Agents to
masquerade as specific types of malware. This is particularly useful for anyone
who writes their own detection rules and needs a way to test them, or anyone
looking to improve the fidelity of malware simulations.

## Using malware masquerade

![Malware Masquerade
Configuration](/images/island/configuration-page/malware-masquerade-configuration.png
"Malware masquerade configuration")

### Configuring strings

It is common for malware detection rules to rely on strings of text present
within a malware binary to identify the malware. Infection Monkey allows you to
specify any number of strings to include within the Linux or Windows Agent
binaries. It's as simple as adding these strings to either list in the
**Masquerade** tab on the **Configuration** screen and clicking _Submit_. You
can verify the success of this operation by downloading the binary and using
the Linux [\`strings\` command.](https://linux.die.net/man/1/strings)


```bash
curl https://<SERVER_IP>:5000/api/agent-binaries/linux -k -o monkey-linux-64 \
    && strings monkey-linux-64 | grep <MY_STRING>
```

### Configuring binary data

While many detection rules rely on strings, others depend on data that cannot
be represented in ASCII or Unicode characters. Infection Monkey can include
arbitrary bytes within the Agent binaries so that these rules and mechanisms
can also be tested. The data can be included in the Agent Binary by first
[Base64 encoding](https://www.base64encode.org/) it and then copy/pasting the
Base64-encoded data into the _Base64_ field in the **Masquerade** tab on the
**Configuration** screen.
