---
title: "MSSQL"
draft: false
description: "Reference material for the MSSQL exploiter"
pre: "<i class='fas fa-database'></i> "
---
{{< table_of_contents >}}

## Supported operating systems

| Operating system | Attack from                 | Target                      |
| :--------------- | :-------------------------- | :-------------------------- |
| Linux            | {{< os-icon-supported >}}   | {{< os-icon-unsupported >}} |
| Windows          | {{< os-icon-supported >}}   | {{< os-icon-supported >}}   |

## Configuration

<!--
This documentation was autogenerated by passing the plugin's config-schema.json
through https://github.com/adobe/jsonschema2md. It was then modified by hand to
remove extraneous information.
-->

| Property                                                           | Type      | Required | Nullable       |
| :----------------------------------------------------------------- | :-------- | :------- | :------------- |
| [target\_ports](#target_ports)                                     | `array`   | Optional | cannot be null |
| [try\_discovered\_mssql\_ports](#try_discovered_mssql_ports)       | `boolean` | Optional | cannot be null |
| [try\_unknown\_service\_ports](#try_unknown_service_ports)         | `boolean` | Optional | cannot be null |
| [server\_timeout](#server_timeout)                                 | `number`  | Optional | cannot be null |
| [agent\_binary\_download\_timeout](#agent_binary_download_timeout) | `number`  | Optional | cannot be null |

### target\_ports

A list of TCP ports that the MSSQL exploiter will try to exploit.

`target_ports`

* is optional

* Type: `integer[]`

* cannot be null

#### target\_ports Default Value

The default value is:

```json
[
  1433
]
```

### try\_discovered\_mssql\_ports

Attempt to exploit MSSQL on ports discovered from network scanning used by an MSSQL service.

`try_discovered_mssql_ports`

* is optional

* Type: `boolean`

* cannot be null

### try\_unknown\_service\_ports

Attempt the exploiter on all discovered, open TCP ports where the listening service cannot be positively identified.

`try_unknown_service_ports`

* is optional

* Type: `boolean`

* cannot be null

### server\_timeout

The maximum time (in seconds) to wait for response from the MSSQL server.

`server_timeout`

* is optional

* Type: `number`

* cannot be null

#### server\_timeout Constraints

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### server\_timeout Default Value

The default value is:

```json
15
```

### agent\_binary\_download\_timeout

The maximum time (in seconds) to wait for a successfully exploited MSSQL server to download the agent binary.

`agent_binary_download_timeout`

* is optional

* Type: `number`

* cannot be null

#### agent\_binary\_download\_timeout Constraints

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### agent\_binary\_download\_timeout Default Value

The default value is:

```json
60
```
