---
title: "SNMP"
draft: false
description: "Reference material for the SNMP exploiter"
pre: "<i class='fas fa-network-wired'></i> "
---
{{< table_of_contents >}}

## Supported operating systems

| Operating system | Attack from                 | Target                      |
| :--------------- | :-------------------------- | :-------------------------- |
| Linux            | {{< os-icon-supported >}}   | {{< os-icon-supported >}}   |
| Windows          | {{< os-icon-supported >}}   | {{< os-icon-unsupported >}} |

## Supported SNMP versions
| SNMP version | Supported                   |
| :----------- | :-------------------------- |
| 1            | {{< os-icon-unsupported >}} |
| 2c           | {{< os-icon-supported >}}   |
| 3            | {{< os-icon-unsupported >}} |

## Exploited CVEs

- {{% cve id=CVE-2020-15862 %}}

## Configuration

<!--
This documentation was autogenerated by passing the plugin's config-schema.json
through https://github.com/adobe/jsonschema2md. It was then modified by hand to
remove extraneous information.
-->

| Property                                                           | Type      | Required | Nullable       |
| :----------------------------------------------------------------- | :-------- | :------- | :------------- |
| [agent\_binary\_download\_timeout](#agent_binary_download_timeout) | `number`  | Optional | cannot be null |
| [snmp\_request\_timeout](#snmp_request_timeout)                    | `number`  | Optional | cannot be null |
| [snmp\_retries](#snmp_retries)                                     | `integer` | Optional | cannot be null |

### agent\_binary\_download\_timeout

The maximum time (in seconds) to wait for a successfully exploited SNMP client to download the agent binary.

`agent_binary_download_timeout`

* is optional

* Type: `number`

* cannot be null

#### agent\_binary\_download\_timeout Constraints

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### agent\_binary\_download\_timeout Default Value

The default value is:

```json
60
```

### snmp\_request\_timeout

The maximum time (in seconds) to wait for a response from an SNMP client.

`snmp_request_timeout`

* is optional

* Type: `number`

* cannot be null

#### snmp\_request\_timeout Constraints

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### snmp\_request\_timeout Default Value

The default value is:

```json
0.5
```

### snmp\_retries

The number of times to retry an SNMP request before giving up.

`snmp_retries`

* is optional

* Type: `integer`

* cannot be null

#### snmp\_retries Constraints

**minimum**: the value of this number must greater than or equal to: `0`

#### snmp\_retries Default Value

The default value is:

```json
3
```
