from ipaddress import IPv4Address

from agentpluginapi import AgentBinaryDownloadTicket, IHTTPAgentBinaryServerRegistrar, ReservationID
from monkeytypes import OperatingSystem

from .http_agent_binary_server import HTTPAgentBinaryServer


class HTTPAgentBinaryServerRegistrar(IHTTPAgentBinaryServerRegistrar):
    def __init__(self, server: HTTPAgentBinaryServer):
        self._server = server

    def reserve_download(
        self,
        operating_system: OperatingSystem,
        requestor_ip: IPv4Address,
        agent_binary_wrapper_template: bytes | None = None,
    ) -> AgentBinaryDownloadTicket:
        return self._server.register(operating_system, requestor_ip, agent_binary_wrapper_template)

    def clear_reservation(self, reservation_id: ReservationID):
        self._server.deregister(reservation_id)
