/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.io.File;
import net.azib.ipscan.config.CommandProcessor;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.core.state.StateTransitionListener;
import net.azib.ipscan.exporters.ExportProcessor;
import net.azib.ipscan.exporters.Exporter;
import net.azib.ipscan.exporters.ExporterRegistry;
import net.azib.ipscan.feeders.FeederCreator;
import net.azib.ipscan.feeders.FeederRegistry;

public class CommandLineProcessor
implements CommandProcessor,
StateTransitionListener {
    private final FeederRegistry feederRegistry;
    private final ExporterRegistry exporters;
    private StateMachine stateMachine;
    private ScanningResultList scanningResults;
    FeederCreator feederCreator;
    String[] feederArgs;
    Exporter exporter;
    String outputFilename;
    boolean autoStart;
    boolean autoQuit;
    boolean appendToFile;

    CommandLineProcessor(FeederRegistry feederCreators, ExporterRegistry exporters) {
        this.feederRegistry = feederCreators;
        this.exporters = exporters;
    }

    public CommandLineProcessor(FeederRegistry feederCreators, ExporterRegistry exporters, StateMachine stateMachine, ScanningResultList scanningResults) {
        this(feederCreators, exporters);
        this.stateMachine = stateMachine;
        this.scanningResults = scanningResults;
        if (stateMachine != null) {
            stateMachine.addTransitionListener(this);
        }
    }

    @Override
    public boolean shouldAutoQuit() {
        return this.autoQuit;
    }

    @Override
    public boolean shouldAutoStart() {
        return this.autoStart;
    }

    public void parse(String ... args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-f:")) {
                if (this.feederCreator != null) {
                    throw new IllegalArgumentException("Only one feeder is allowed");
                }
                this.feederCreator = this.findFeederCreator("feeder." + arg.substring(3));
                this.feederArgs = new String[this.feederCreator.serializePartsLabels().length];
                for (int j = 0; j < this.feederArgs.length; ++j) {
                    this.feederArgs[j] = args[++i];
                    if (!this.feederArgs[j].startsWith("-")) continue;
                    throw new IllegalArgumentException(this.feederCreator.getFeederName() + " requires " + this.feederArgs.length + " arguments");
                }
                continue;
            }
            if (arg.equals("-o")) {
                if (this.outputFilename != null) {
                    throw new IllegalArgumentException("Only one exporter is allowed");
                }
                this.outputFilename = args[++i];
                if (this.outputFilename.startsWith("-")) {
                    throw new IllegalArgumentException("Output filename missing");
                }
                this.exporter = this.findExporter(this.outputFilename);
                this.autoStart = true;
                continue;
            }
            if (arg.startsWith("-")) {
                block7: for (char option : arg.substring(1).toCharArray()) {
                    switch (option) {
                        case 's': {
                            this.autoStart = true;
                            continue block7;
                        }
                        case 'q': {
                            this.autoQuit = true;
                            continue block7;
                        }
                        case 'a': {
                            this.appendToFile = true;
                            continue block7;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown option: " + option);
                        }
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Unknown argument: " + arg);
        }
        if (this.feederCreator == null) {
            throw new IllegalArgumentException("Feeder missing");
        }
        this.feederCreator.unserialize(this.feederArgs);
    }

    public String toString() {
        StringBuilder usage = new StringBuilder();
        usage.append("Pass the following arguments:\n");
        usage.append("[options] <feeder> <exporter>\n\n");
        usage.append("Where <feeder> is one of:\n");
        for (FeederCreator creator : this.feederRegistry) {
            usage.append("-f:").append(this.shortId(creator.getFeederId()));
            for (String partLabel : creator.serializePartsLabels()) {
                usage.append(" <").append(Labels.getLabel(partLabel)).append(">");
            }
            usage.append('\n');
        }
        usage.append("\n<exporter> is one of:\n");
        for (Exporter exporter : this.exporters) {
            usage.append("-o filename.").append(this.shortId(exporter.getFilenameExtension())).append("\t\t").append(Labels.getLabel(exporter.getId())).append('\n');
        }
        usage.append("\nAnd possible [options] are (grouping allowed):\n");
        usage.append("-s\tstart scanning automatically\n");
        usage.append("-q\tquit after exporting the results\n");
        usage.append("-a\tappend to the file, do not overwrite\n");
        return usage.toString();
    }

    private String shortId(String longId) {
        return longId.substring(longId.lastIndexOf(46) + 1);
    }

    private FeederCreator findFeederCreator(String feederId) {
        for (FeederCreator creator : this.feederRegistry) {
            if (!feederId.equals(creator.getFeederId())) continue;
            return creator;
        }
        throw new IllegalArgumentException("Feeder unknown: " + this.shortId(feederId));
    }

    private Exporter findExporter(String outputFilename) {
        return this.exporters.createExporter(outputFilename);
    }

    @Override
    public void transitionTo(ScanningState state, StateMachine.Transition transition) {
        if (transition == StateMachine.Transition.INIT) {
            if (this.feederCreator != null) {
                this.feederRegistry.select(this.feederCreator.getFeederId());
            }
            if (this.autoStart) {
                this.stateMachine.transitionToNext();
            }
        } else if (transition == StateMachine.Transition.COMPLETE && state == ScanningState.IDLE && this.exporter != null) {
            ExportProcessor processor = new ExportProcessor(this.exporter, new File(this.outputFilename), this.appendToFile);
            processor.process(this.scanningResults, null);
            if (this.autoQuit) {
                System.err.println("Saved results to " + this.outputFilename);
                System.exit(0);
            }
        }
    }
}

