/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import net.azib.ipscan.config.ConfigModule;
import net.azib.ipscan.config.GUIRegistry;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.core.Plugin;
import net.azib.ipscan.core.PluginLoader;
import net.azib.ipscan.core.net.Pinger;
import net.azib.ipscan.core.net.PingerRegistry;
import net.azib.ipscan.di.Injector;
import net.azib.ipscan.exporters.CSVExporter;
import net.azib.ipscan.exporters.IPListExporter;
import net.azib.ipscan.exporters.SQLExporter;
import net.azib.ipscan.exporters.TXTExporter;
import net.azib.ipscan.exporters.XMLExporter;
import net.azib.ipscan.fetchers.CommentFetcher;
import net.azib.ipscan.fetchers.FilteredPortsFetcher;
import net.azib.ipscan.fetchers.HTTPProxyFetcher;
import net.azib.ipscan.fetchers.HTTPSenderFetcher;
import net.azib.ipscan.fetchers.HostnameFetcher;
import net.azib.ipscan.fetchers.IPFetcher;
import net.azib.ipscan.fetchers.MACFetcher;
import net.azib.ipscan.fetchers.MACVendorFetcher;
import net.azib.ipscan.fetchers.NetBIOSInfoFetcher;
import net.azib.ipscan.fetchers.PacketLossFetcher;
import net.azib.ipscan.fetchers.PingFetcher;
import net.azib.ipscan.fetchers.PingTTLFetcher;
import net.azib.ipscan.fetchers.PortsFetcher;
import net.azib.ipscan.fetchers.WebDetectFetcher;

public class ComponentRegistry {
    public void register(Injector i) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        i.register(IPFetcher.class, PingFetcher.class, PingTTLFetcher.class, HostnameFetcher.class, PortsFetcher.class);
        i.register(MACFetcher.class, (MACFetcher)Class.forName(MACFetcher.class.getPackage().getName() + (Platform.WINDOWS ? ".WinMACFetcher" : (Platform.LINUX ? ".LinuxMACFetcher" : ".UnixMACFetcher"))).newInstance());
        i.register(CommentFetcher.class, FilteredPortsFetcher.class, WebDetectFetcher.class, HTTPSenderFetcher.class, NetBIOSInfoFetcher.class, PacketLossFetcher.class, HTTPProxyFetcher.class, MACVendorFetcher.class);
        i.register(TXTExporter.class, CSVExporter.class, XMLExporter.class, IPListExporter.class, SQLExporter.class);
    }

    public Injector init() throws Exception {
        return this.init(true);
    }

    public Injector init(boolean withGUI) throws Exception {
        Injector i = new Injector();
        new ConfigModule().register(i);
        new ComponentRegistry().register(i);
        if (withGUI) {
            new GUIRegistry().register(i);
            PingerRegistry pingerRegistry = i.require(PingerRegistry.class);
            new PluginLoader().getClasses().forEach(c -> {
                Plugin plugin = (Plugin)i.require(c);
                if (Pinger.class.isAssignableFrom((Class<?>)c)) {
                    pingerRegistry.register(plugin.getId(), (Class<? extends Pinger>)c);
                }
            });
        }
        return i;
    }
}

