/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.util.prefs.Preferences;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.Platform;

public class ScannerConfig {
    private Preferences preferences;
    public int maxThreads;
    public int threadDelay;
    public boolean scanDeadHosts;
    public String selectedPinger;
    public int pingTimeout;
    public int pingCount;
    public boolean skipBroadcastAddresses;
    public int portTimeout;
    public boolean adaptPortTimeout;
    public int minPortTimeout;
    public String portString;
    public boolean useRequestedPorts;
    public String notAvailableText;
    public String notScannedText;

    ScannerConfig(Preferences preferences) {
        this.preferences = preferences;
        this.maxThreads = preferences.getInt("maxThreads", Platform.CRIPPLED_WINDOWS ? 10 : 100);
        this.threadDelay = preferences.getInt("threadDelay", 20);
        this.scanDeadHosts = preferences.getBoolean("scanDeadHosts", false);
        this.selectedPinger = preferences.get("selectedPinger", Platform.WINDOWS ? "pinger.windows" : "pinger.java");
        this.pingTimeout = preferences.getInt("pingTimeout", 2000);
        this.pingCount = preferences.getInt("pingCount", 3);
        this.skipBroadcastAddresses = preferences.getBoolean("skipBroadcastAddresses", true);
        this.portTimeout = preferences.getInt("portTimeout", 2000);
        this.adaptPortTimeout = preferences.getBoolean("adaptPortTimeout", !Platform.CRIPPLED_WINDOWS);
        this.minPortTimeout = preferences.getInt("minPortTimeout", 100);
        this.portString = preferences.get("portString", "80,443,8080");
        this.useRequestedPorts = preferences.getBoolean("useRequestedPorts", true);
        this.notAvailableText = preferences.get("notAvailableText", Labels.getLabel("fetcher.value.notAvailable"));
        this.notScannedText = preferences.get("notScannedText", Labels.getLabel("fetcher.value.notScanned"));
    }

    public void store() {
        this.preferences.putInt("maxThreads", this.maxThreads);
        this.preferences.putInt("threadDelay", this.threadDelay);
        this.preferences.putBoolean("scanDeadHosts", this.scanDeadHosts);
        this.preferences.put("selectedPinger", this.selectedPinger);
        this.preferences.putInt("pingTimeout", this.pingTimeout);
        this.preferences.putInt("pingCount", this.pingCount);
        this.preferences.putBoolean("skipBroadcastAddresses", this.skipBroadcastAddresses);
        this.preferences.putInt("portTimeout", this.portTimeout);
        this.preferences.putBoolean("adaptPortTimeout", this.adaptPortTimeout);
        this.preferences.putInt("minPortTimeout", this.minPortTimeout);
        this.preferences.put("portString", this.portString);
        this.preferences.putBoolean("useRequestedPorts", this.useRequestedPorts);
        this.preferences.put("notAvailableText", this.notAvailableText);
        this.preferences.put("notScannedText", this.notScannedText);
    }
}

