/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.values.NotAvailable;
import net.azib.ipscan.core.values.NotScanned;
import net.azib.ipscan.feeders.Feeder;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.FetcherRegistry;

public class Scanner {
    private static final Logger LOG = Logger.getLogger(Scanner.class.getName());
    private FetcherRegistry fetcherRegistry;
    private Map<Long, Fetcher> activeFetchers = new ConcurrentHashMap<Long, Fetcher>();

    public Scanner(FetcherRegistry fetcherRegistry) {
        this.fetcherRegistry = fetcherRegistry;
    }

    public void scan(ScanningSubject subject, ScanningResult result) {
        int fetcherIndex = 0;
        boolean isScanningInterrupted = false;
        for (Fetcher fetcher : this.fetcherRegistry.getSelectedFetchers()) {
            Object value = NotScanned.VALUE;
            try {
                this.activeFetchers.put(Thread.currentThread().getId(), fetcher);
                if (!subject.isAddressAborted() && !isScanningInterrupted) {
                    value = fetcher.scan(subject);
                    isScanningInterrupted = Thread.currentThread().isInterrupted();
                    if (value == null) {
                        value = isScanningInterrupted ? NotScanned.VALUE : NotAvailable.VALUE;
                    }
                }
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "", e);
            }
            result.setValue(fetcherIndex, value);
            ++fetcherIndex;
        }
        result.setMac((String)subject.getParameter("fetcher.mac"));
        this.activeFetchers.remove(Thread.currentThread().getId());
        result.setType(subject.getResultType());
    }

    public void interrupt(Thread thread) {
        Fetcher fetcher = this.activeFetchers.get(thread.getId());
        if (fetcher != null) {
            fetcher.cleanup();
        }
    }

    public void init(Feeder feeder) {
        for (Fetcher fetcher : this.fetcherRegistry.getSelectedFetchers()) {
            fetcher.init(feeder);
        }
    }

    public void cleanup() {
        this.activeFetchers.clear();
        for (Fetcher fetcher : this.fetcherRegistry.getSelectedFetchers()) {
            fetcher.cleanup();
        }
    }
}

