/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.FetcherRegistry;
import net.azib.ipscan.gui.AbstractModalDialog;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SelectFetchersDialog
extends AbstractModalDialog {
    private FetcherRegistry fetcherRegistry;
    private List lastFocusList;
    private List selectedFetchersList;
    private List registeredFetchersList;
    Map<String, String> registeredFetcherIdsByNames = new HashMap<String, String>();

    public SelectFetchersDialog(FetcherRegistry fetcherRegistry) {
        this.fetcherRegistry = fetcherRegistry;
    }

    @Override
    protected void populateShell() {
        Display currentDisplay = Display.getCurrent();
        Shell parent = currentDisplay != null ? currentDisplay.getActiveShell() : null;
        this.shell = new Shell(parent, 67680);
        this.shell.setText(Labels.getLabel("title.fetchers"));
        this.shell.setLayout(LayoutHelper.formLayout(10, 10, 4));
        Label messageLabel = new Label(this.shell, 64);
        messageLabel.setText(Labels.getLabel("text.fetchers.select"));
        Label selectedLabel = new Label(this.shell, 0);
        selectedLabel.setText(Labels.getLabel("text.fetchers.selectedList"));
        selectedLabel.setLayoutData(LayoutHelper.formData(null, null, new FormAttachment(messageLabel, 5), null));
        this.selectedFetchersList = this.lastFocusList = new List(this.shell, 2562);
        this.selectedFetchersList.setLayoutData(LayoutHelper.formData(160, 250, new FormAttachment(0), null, new FormAttachment(selectedLabel), null));
        Iterator<Fetcher> i = this.fetcherRegistry.getSelectedFetchers().iterator();
        i.next();
        while (i.hasNext()) {
            Fetcher fetcher = i.next();
            this.selectedFetchersList.add(fetcher.getName());
        }
        Font iconFont = LayoutHelper.iconFont(this.shell);
        Button upButton = new Button(this.shell, 0);
        upButton.setText(Labels.getLabel("button.up"));
        upButton.setToolTipText(Labels.getLabel("button.up.hint"));
        upButton.setFont(iconFont);
        Button downButton = new Button(this.shell, 0);
        downButton.setText(Labels.getLabel("button.down"));
        downButton.setToolTipText(Labels.getLabel("button.down.hint"));
        downButton.setFont(iconFont);
        Button addButton = new Button(this.shell, 0);
        addButton.setText(Labels.getLabel("button.left"));
        addButton.setToolTipText(Labels.getLabel("button.left.hint"));
        addButton.setFont(iconFont);
        Button removeButton = new Button(this.shell, 0);
        removeButton.setText(Labels.getLabel("button.right"));
        removeButton.setToolTipText(Labels.getLabel("button.right.hint"));
        removeButton.setFont(iconFont);
        Button prefsButton = new Button(this.shell, 0);
        prefsButton.setImage(LayoutHelper.icon("buttons/prefs"));
        prefsButton.setToolTipText(Labels.getLabel("text.fetchers.preferences"));
        prefsButton.setFont(iconFont);
        upButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.selectedFetchersList), null, new FormAttachment(selectedLabel), null));
        downButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.selectedFetchersList), null, new FormAttachment(upButton), null));
        addButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.selectedFetchersList), null, new FormAttachment(downButton, 16), null));
        removeButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.selectedFetchersList), null, new FormAttachment(addButton), null));
        prefsButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.selectedFetchersList), new FormAttachment(removeButton, 0, 131072), new FormAttachment(removeButton, 16), null));
        Label registeredLabel = new Label(this.shell, 0);
        registeredLabel.setText(Labels.getLabel("text.fetchers.availableList"));
        registeredLabel.setLayoutData(LayoutHelper.formData(new FormAttachment(upButton, 10), null, new FormAttachment(messageLabel, 5), null));
        this.registeredFetchersList = new List(this.shell, 2562);
        this.registeredFetchersList.setLayoutData(LayoutHelper.formData(160, 250, new FormAttachment(upButton, 10), null, new FormAttachment(registeredLabel), null));
        i = this.fetcherRegistry.getRegisteredFetchers().iterator();
        i.next();
        while (i.hasNext()) {
            Fetcher fetcher = i.next();
            String fetcherName = fetcher.getName();
            this.registeredFetcherIdsByNames.put(fetcherName, fetcher.getId());
            if (this.selectedFetchersList.indexOf(fetcherName) >= 0) continue;
            this.registeredFetchersList.add(fetcherName);
        }
        Button okButton = new Button(this.shell, 0);
        okButton.setText(Labels.getLabel("button.OK"));
        Button cancelButton = new Button(this.shell, 0);
        cancelButton.setText(Labels.getLabel("button.cancel"));
        this.positionButtonsInFormLayout(okButton, cancelButton, this.registeredFetchersList);
        upButton.addListener(13, new AbstractModalDialog.UpButtonListener(this.selectedFetchersList));
        downButton.addListener(13, new AbstractModalDialog.DownButtonListener(this.selectedFetchersList));
        AddRemoveButtonListener addButtonListener = new AddRemoveButtonListener(this.registeredFetchersList, this.selectedFetchersList);
        addButton.addListener(13, addButtonListener);
        this.registeredFetchersList.addListener(8, addButtonListener);
        AddRemoveButtonListener removeButtonListener = new AddRemoveButtonListener(this.selectedFetchersList, this.registeredFetchersList);
        removeButton.addListener(13, removeButtonListener);
        this.selectedFetchersList.addListener(8, removeButtonListener);
        prefsButton.addListener(13, new PrefsListener());
        this.registeredFetchersList.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.lastFocusList = (List)e.getSource();
        }));
        this.selectedFetchersList.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.lastFocusList = (List)e.getSource();
        }));
        this.shell.layout();
        Rectangle bounds = this.registeredFetchersList.getBounds();
        messageLabel.setLayoutData(LayoutHelper.formData(bounds.x + bounds.width - 10, -1, new FormAttachment(0), null, null, null));
        this.shell.pack();
        cancelButton.addListener(13, e -> this.close());
        okButton.addListener(13, event -> {
            this.saveFetchersToRegistry(this.selectedFetchersList.getItems());
            this.close();
        });
    }

    void saveFetchersToRegistry(String[] fetchersNamesToSave) {
        String[] fetchersLabelsToRetain = new String[fetchersNamesToSave.length + 1];
        fetchersLabelsToRetain[0] = "fetcher.ip";
        for (int i = 0; i < fetchersNamesToSave.length; ++i) {
            fetchersLabelsToRetain[i + 1] = this.registeredFetcherIdsByNames.get(fetchersNamesToSave[i]);
        }
        this.fetcherRegistry.updateSelectedFetchers(fetchersLabelsToRetain);
    }

    static class AddRemoveButtonListener
    implements Listener {
        private List fromList;
        private List toList;

        public AddRemoveButtonListener(List fromList, List toList) {
            this.fromList = fromList;
            this.toList = toList;
        }

        @Override
        public void handleEvent(Event event) {
            int[] selectedItems;
            for (int selectedItem : selectedItems = this.fromList.getSelectionIndices()) {
                this.toList.add(this.fromList.getItem(selectedItem));
            }
            this.fromList.remove(selectedItems);
        }
    }

    class PrefsListener
    implements Listener {
        PrefsListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (SelectFetchersDialog.this.lastFocusList.getItemCount() == 0) {
                return;
            }
            int selectionIndex = SelectFetchersDialog.this.lastFocusList.getSelectionIndex();
            if (selectionIndex < 0) {
                selectionIndex = 0;
            }
            String fetcherName = SelectFetchersDialog.this.lastFocusList.getItem(selectionIndex);
            for (Fetcher fetcher : SelectFetchersDialog.this.fetcherRegistry.getRegisteredFetchers()) {
                if (!fetcherName.equals(fetcher.getName())) continue;
                SelectFetchersDialog.this.fetcherRegistry.openPreferencesEditor(fetcher);
                break;
            }
        }
    }
}

