/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.FetcherRegistry;
import net.azib.ipscan.gui.ResultTable;
import net.azib.ipscan.gui.menu.ColumnsMenu;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ColumnsActions {

    public static final class AboutFetcher
    implements Listener {
        @Override
        public void handleEvent(Event event) {
            TableColumn tableColumn = (TableColumn)((MenuItem)event.widget).getParent().getData();
            Fetcher fetcher = (Fetcher)tableColumn.getData();
            MessageBox messageBox = new MessageBox(tableColumn.getParent().getShell(), 34);
            messageBox.setText(Labels.getLabel("text.fetchers.info") + fetcher.getName());
            String info = fetcher.getInfo();
            if (info == null) {
                info = Labels.getLabel("text.fetchers.info.notAvailable");
            }
            messageBox.setMessage(info);
            messageBox.open();
        }
    }

    public static final class FetcherPreferences
    implements Listener {
        private final FetcherRegistry fetcherRegistry;

        public FetcherPreferences(FetcherRegistry fetcherRegistry) {
            this.fetcherRegistry = fetcherRegistry;
        }

        @Override
        public void handleEvent(Event event) {
            TableColumn tableColumn = (TableColumn)((MenuItem)event.widget).getParent().getData();
            Fetcher fetcher = (Fetcher)tableColumn.getData();
            this.fetcherRegistry.openPreferencesEditor(fetcher);
            tableColumn.setText(fetcher.getFullName());
        }
    }

    public static final class SortBy
    implements Listener {
        private final ScanningResultList scanningResultList;

        public SortBy(ScanningResultList scanningResultList) {
            this.scanningResultList = scanningResultList;
        }

        @Override
        public void handleEvent(Event event) {
            TableColumn tableColumn = (TableColumn)((MenuItem)event.widget).getParent().getData();
            Table table = tableColumn.getParent();
            if (table.getSortColumn() != tableColumn) {
                table.setSortColumn(tableColumn);
                table.setSortDirection(128);
            } else {
                table.setSortDirection(table.getSortDirection() == 128 ? 1024 : 128);
            }
            this.scanningResultList.sort(table.indexOf(tableColumn), table.getSortDirection() == 128);
            ((ResultTable)table).updateResults();
        }
    }

    public static final class ColumnClick
    implements Listener {
        private final Menu columnsMenu;
        private final StateMachine stateMachine;

        public ColumnClick(ColumnsMenu columnsMenu, StateMachine stateMachine) {
            this.columnsMenu = columnsMenu;
            this.stateMachine = stateMachine;
        }

        @Override
        public void handleEvent(Event e) {
            TableColumn tableColumn = (TableColumn)e.widget;
            Fetcher fetcher = (Fetcher)tableColumn.getData();
            MenuItem sortMenuItem = this.columnsMenu.getItem(0);
            MenuItem preferencesMenuItem = this.columnsMenu.getItem(1);
            MenuItem aboutMenuItem = this.columnsMenu.getItem(2);
            if (tableColumn.getParent().getSortColumn() == tableColumn) {
                sortMenuItem.setText(Labels.getLabel("menu.columns.sortDirection"));
            } else {
                sortMenuItem.setText(Labels.getLabel("menu.columns.sortBy") + " " + fetcher.getName());
            }
            sortMenuItem.setEnabled(this.stateMachine.inState(ScanningState.IDLE));
            preferencesMenuItem.setText(fetcher.getName() + " " + Labels.getLabel("menu.columns.preferences"));
            preferencesMenuItem.setEnabled(fetcher.getPreferencesClass() != null && this.stateMachine.inState(ScanningState.IDLE));
            aboutMenuItem.setText(Labels.getLabel("menu.columns.about") + " " + fetcher.getName());
            tableColumn.getParent().forceFocus();
            this.columnsMenu.setData(tableColumn);
            this.columnsMenu.setLocation(e.display.getCursorLocation());
            this.columnsMenu.setVisible(true);
        }
    }

    public static final class ColumnResize
    implements Listener {
        private GUIConfig guiConfig;

        public ColumnResize(GUIConfig guiConfig) {
            this.guiConfig = guiConfig;
        }

        @Override
        public void handleEvent(Event event) {
            TableColumn column = (TableColumn)event.widget;
            if (Platform.LINUX && column.getParent().getColumn(column.getParent().getColumnCount() - 1) == column) {
                return;
            }
            this.guiConfig.setColumnWidth((Fetcher)column.getData(), column.getWidth());
        }
    }
}

