/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.feeders;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.feeders.Feeder;
import net.azib.ipscan.feeders.FeederCreator;
import net.azib.ipscan.util.InetAddressUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractFeederGUI
extends Composite
implements FeederCreator {
    static final Logger LOG = LoggerFactory.getLogger();
    protected Feeder feeder;
    private static final Object localResolveLock = new Object();
    private static String localName;
    private static InterfaceAddress localInterface;

    public AbstractFeederGUI(Composite parent) {
        super(parent, 0);
        this.setVisible(false);
        this.initialize();
    }

    public abstract void initialize();

    @Override
    public String getFeederId() {
        return this.feeder.getId();
    }

    @Override
    public String getFeederName() {
        return this.feeder.getName();
    }

    public String getInfo() {
        return this.getFeederName() + ": " + this.createFeeder().getInfo();
    }

    protected void asyncFillLocalHostInfo(Text hostnameText, Text ipText) {
        new Thread(() -> {
            Object object = localResolveLock;
            synchronized (object) {
                if (localInterface == null) {
                    localInterface = InetAddressUtils.getLocalInterface();
                    try {
                        localName = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        localName = localInterface.getAddress().getHostName();
                    }
                }
                Display.getDefault().asyncExec(() -> {
                    if ("".equals(hostnameText.getText())) {
                        hostnameText.setText(localName);
                    }
                    if ("".equals(ipText.getText())) {
                        ipText.setText(localInterface.getAddress().getHostAddress());
                        this.afterLocalHostInfoFilled(localInterface);
                    }
                });
            }
        }).start();
    }

    protected void afterLocalHostInfoFilled(InterfaceAddress localInterface) {
    }
}

