/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.config.Platform;

public class InetAddressUtils {
    static final Logger LOG = LoggerFactory.getLogger();
    public static final Pattern HOSTNAME_REGEX = Pattern.compile("(\\b(((?!25?[6-9])[12]\\d|[1-9])?\\d\\.?\\b){4}\\b)|(?<!(\\w|:))(([0-9a-f]{1,4}:){7,7}[0-9a-f]{1,4}|([0-9a-f]{1,4}:){1,7}:|([0-9a-f]{1,4}:){1,6}:[0-9a-f]{1,4}|([0-9a-f]{1,4}:){1,5}(:[0-9a-f]{1,4}){1,2}|([0-9a-f]{1,4}:){1,4}(:[0-9a-f]{1,4}){1,3}|([0-9a-f]{1,4}:){1,3}(:[0-9a-f]{1,4}){1,4}|([0-9a-f]{1,4}:){1,2}(:[0-9a-f]{1,4}){1,5}|[0-9a-f]{1,4}:((:[0-9a-f]{1,4}){1,6})|:((:[0-9a-f]{1,4}){1,7}|:)|fe80:(:[0-9a-f]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-f]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))(?!(\\w|:))|(\\b(([a-z]|[a-z0-9][a-z0-9\\-]*[a-z0-9])\\.)+([a-z0-9]{2,})\\.?(?!(\\w|\\.)))", 2);

    public static InetAddress startRangeByNetmask(InetAddress address, InetAddress netmask) {
        byte[] addressBytes = address.getAddress();
        byte[] netmaskBytes = netmask.getAddress();
        for (int i = 0; i < addressBytes.length; ++i) {
            addressBytes[i] = i < netmaskBytes.length ? (byte)(addressBytes[i] & netmaskBytes[i]) : (byte)0;
        }
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static InetAddress endRangeByNetmask(InetAddress address, InetAddress netmask) {
        byte[] netmaskBytes = netmask.getAddress();
        byte[] addressBytes = address.getAddress();
        for (int i = 0; i < addressBytes.length; ++i) {
            addressBytes[i] = (byte)(i < netmaskBytes.length ? addressBytes[i] | ~netmaskBytes[i] : 255);
        }
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean greaterThan(InetAddress inetAddress1, InetAddress inetAddress2) {
        byte[] address1 = inetAddress1.getAddress();
        byte[] address2 = inetAddress2.getAddress();
        for (int i = 0; i < address1.length; ++i) {
            if ((address1[i] & 0xFF) > (address2[i] & 0xFF)) {
                return true;
            }
            if ((address1[i] & 0xFF) < (address2[i] & 0xFF)) break;
        }
        return false;
    }

    public static InetAddress increment(InetAddress address) {
        return InetAddressUtils.modifyInetAddress(address, true);
    }

    public static InetAddress decrement(InetAddress address) {
        return InetAddressUtils.modifyInetAddress(address, false);
    }

    private static InetAddress modifyInetAddress(InetAddress address, boolean isIncrement) {
        try {
            byte[] newAddress = address.getAddress();
            for (int i = newAddress.length - 1; i >= 0; --i) {
                if (isIncrement) {
                    int n = i;
                    newAddress[n] = (byte)(newAddress[n] + 1);
                    if (newAddress[n] == 0) continue;
                    break;
                }
                int n = i;
                newAddress[n] = (byte)(newAddress[n] - 1);
                if (newAddress[n] != 0) break;
            }
            return InetAddress.getByAddress(newAddress);
        }
        catch (UnknownHostException e) {
            assert (false) : e;
            return null;
        }
    }

    public static InetAddress parseNetmask(String netmaskString) throws UnknownHostException {
        if (netmaskString.startsWith("/")) {
            int totalBits = Integer.parseInt(netmaskString.substring(1));
            return InetAddressUtils.parseNetmask(totalBits);
        }
        netmaskString = netmaskString.replaceAll("\\.\\.", ".255.");
        netmaskString = netmaskString.replaceAll("\\.\\.", ".255.");
        return InetAddress.getByName(netmaskString);
    }

    public static InetAddress parseNetmask(int prefixBits) {
        byte[] mask = new byte[prefixBits > 32 ? 16 : 4];
        for (int i = 0; i < mask.length; ++i) {
            int curByteBits = Math.min(prefixBits, 8);
            prefixBits -= curByteBits;
            mask[i] = (byte)((1 << curByteBits) - 1 << 8 - curByteBits & 0xFF);
        }
        try {
            return InetAddress.getByAddress(mask);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static void maskPrototypeAddressBytes(byte[] addressBytes, byte[] maskBytes, byte[] prototypeBytes) {
        for (int i = 0; i < addressBytes.length; ++i) {
            addressBytes[i] = (byte)(addressBytes[i] & ~maskBytes[i] | prototypeBytes[i] & maskBytes[i]);
        }
    }

    public static boolean isLikelyBroadcast(InetAddress address, InterfaceAddress ifAddr) {
        byte[] bytes = address.getAddress();
        int last = bytes.length - 1;
        if (ifAddr != null) {
            return address.equals(ifAddr.getBroadcast()) || bytes[last] == 0 && Arrays.equals(bytes, 0, last, ifAddr.getAddress().getAddress(), 0, last);
        }
        return bytes[last] == 0 || bytes[last] == -1;
    }

    public static InterfaceAddress getLocalInterface() {
        InterfaceAddress anyAddress = null;
        try {
            List<NetworkInterface> interfaces = InetAddressUtils.getNetworkInterfaces().stream().filter(i -> i.getParent() == null && !i.isVirtual()).toList();
            for (NetworkInterface networkInterface : interfaces) {
                try {
                    if (networkInterface.getHardwareAddress() == null) {
                        continue;
                    }
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                Iterator<InterfaceAddress> iterator = networkInterface.getInterfaceAddresses().iterator();
                while (iterator.hasNext()) {
                    InterfaceAddress ifAddr;
                    anyAddress = ifAddr = iterator.next();
                    InetAddress addr = ifAddr.getAddress();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    return ifAddr;
                }
            }
        }
        catch (SocketException e) {
            LOG.log(Level.FINE, "Cannot enumerate network interfaces", e);
        }
        return anyAddress;
    }

    public static NetworkInterface getInterface(InterfaceAddress address) {
        try {
            if (address == null) {
                return null;
            }
            return NetworkInterface.getByInetAddress(address.getAddress());
        }
        catch (SocketException e) {
            return null;
        }
    }

    public static NetworkInterface getInterface(InetAddress address, Stream<NetworkInterface> interfaceStream) {
        try {
            if (address == null) {
                return null;
            }
            return interfaceStream.filter(i -> i.getInterfaceAddresses().stream().anyMatch(ifAddr -> {
                InetAddress netmask = InetAddressUtils.parseNetmask(ifAddr.getNetworkPrefixLength());
                return InetAddressUtils.startRangeByNetmask(address, netmask).equals(InetAddressUtils.startRangeByNetmask(ifAddr.getAddress(), netmask));
            })).findFirst().orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static NetworkInterface getInterface(InetAddress address) {
        try {
            return InetAddressUtils.getInterface(address, NetworkInterface.networkInterfaces());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static InterfaceAddress matchingAddress(NetworkInterface netIf, Class<? extends InetAddress> addressClass) {
        if (netIf == null) {
            return null;
        }
        return netIf.getInterfaceAddresses().stream().filter(i -> i.getAddress().getClass() == addressClass).findFirst().orElse(null);
    }

    public static List<NetworkInterface> getNetworkInterfaces() throws SocketException {
        ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        if (!Platform.WINDOWS) {
            Collections.reverse(interfaces);
        }
        return interfaces;
    }
}

