/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class MDNSResolver
implements Closeable {
    InetAddress mdnsIP = InetAddress.getByName("224.0.0.251");
    private int mdnsPort = 5353;
    MulticastSocket socket = new MulticastSocket();

    public MDNSResolver(int timeout) throws IOException {
        this.socket.setSoTimeout(timeout);
        this.socket.setTimeToLive(1);
    }

    void writeName(DataOutputStream out, String name) throws IOException {
        int e;
        int s = 0;
        while ((e = name.indexOf(46, s)) != -1) {
            out.writeByte(e - s);
            out.write(name.substring(s, e).getBytes());
            s = e + 1;
        }
        out.write(name.length() - s);
        out.write(name.substring(s).getBytes());
        out.writeByte(0);
    }

    String decodeName(byte[] data, int offset, int length) {
        byte len;
        StringBuilder s = new StringBuilder(length);
        for (int i = offset; i < offset + length && (len = data[i]) != 0; ++i) {
            s.append(new String(data, i + 1, (int)len)).append('.');
            i += len;
        }
        s.setLength(s.length() - 1);
        return s.toString();
    }

    byte[] dnsRequest(int id, String name) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeShort(id);
        out.write(new byte[]{0, 0, 0, 1, 0, 0, 0, 0, 0, 0});
        this.writeName(out, name);
        out.write(new byte[]{0, 12, 0, 1});
        return baos.toByteArray();
    }

    String reverseName(byte[] addr) {
        return (addr[3] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[0] & 0xFF) + ".in-addr.arpa";
    }

    public String resolve(InetAddress ip) throws IOException {
        byte[] addr = ip.getAddress();
        int requestId = addr[2] * 255 + addr[3];
        byte[] request = this.dnsRequest(requestId, this.reverseName(addr));
        this.socket.send(new DatagramPacket(request, request.length, this.mdnsIP, this.mdnsPort));
        DatagramPacket respPacket = new DatagramPacket(new byte[512], 512);
        this.socket.receive(respPacket);
        byte[] response = respPacket.getData();
        if (response[0] != request[0] && response[1] != request[1]) {
            return null;
        }
        byte numQueries = response[5];
        int offset = (numQueries == 0 ? 12 : request.length) + 2 + 2 + 2 + 4 + 2;
        return this.decodeName(response, offset, respPacket.getLength() - offset);
    }

    @Override
    public void close() {
        this.socket.close();
    }

    public static void main(String[] args) throws IOException {
        System.out.println(new MDNSResolver(2000).resolve(InetAddress.getByName("192.168.0.10")));
    }
}

