/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;

public final class OS2BMPFileFormat
extends FileFormat.StaticImageFileFormat {
    static final int BMPFileHeaderSize = 14;
    static final int BMPHeaderFixedSize = 12;
    int width;
    int height;
    int bitCount;

    @Override
    boolean isFileFormat(LEDataInputStream stream) throws IOException {
        byte[] header = new byte[18];
        stream.read(header);
        stream.unread(header);
        int infoHeaderSize = header[14] & 0xFF | (header[15] & 0xFF) << 8 | (header[16] & 0xFF) << 16 | (header[17] & 0xFF) << 24;
        return header[0] == 66 && header[1] == 77 && infoHeaderSize == 12;
    }

    byte[] loadData(byte[] infoHeader) {
        int stride = (this.width * this.bitCount + 7) / 8;
        stride = (stride + 3) / 4 * 4;
        byte[] data = this.loadData(infoHeader, stride);
        this.flipScanLines(data, stride, this.height);
        return data;
    }

    byte[] loadData(byte[] infoHeader, int stride) {
        int dataSize = this.height * stride;
        byte[] data = new byte[dataSize];
        try {
            if (this.inputStream.read(data) != dataSize) {
                SWT.error(40);
            }
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        return data;
    }

    int[] loadFileHeader() {
        int[] header = new int[5];
        try {
            header[0] = this.inputStream.readShort();
            header[1] = this.inputStream.readInt();
            header[2] = this.inputStream.readShort();
            header[3] = this.inputStream.readShort();
            header[4] = this.inputStream.readInt();
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        if (header[0] != 19778) {
            SWT.error(40);
        }
        return header;
    }

    @Override
    ImageData[] loadFromByteStream() {
        int[] fileHeader = this.loadFileHeader();
        byte[] infoHeader = new byte[12];
        try {
            this.inputStream.read(infoHeader);
        }
        catch (Exception e) {
            SWT.error(39, e);
        }
        this.width = infoHeader[4] & 0xFF | (infoHeader[5] & 0xFF) << 8;
        this.height = infoHeader[6] & 0xFF | (infoHeader[7] & 0xFF) << 8;
        this.bitCount = infoHeader[10] & 0xFF | (infoHeader[11] & 0xFF) << 8;
        PaletteData palette = this.loadPalette(infoHeader);
        if (this.inputStream.getPosition() < fileHeader[4]) {
            try {
                this.inputStream.skip(fileHeader[4] - this.inputStream.getPosition());
            }
            catch (IOException e) {
                SWT.error(39, e);
            }
        }
        byte[] data = this.loadData(infoHeader);
        int type = 7;
        return new ImageData[]{ImageData.internal_new(this.width, this.height, this.bitCount, palette, 4, data, 0, null, null, -1, -1, type, 0, 0, 0, 0)};
    }

    PaletteData loadPalette(byte[] infoHeader) {
        if (this.bitCount <= 8) {
            int numColors = 1 << this.bitCount;
            byte[] buf = new byte[numColors * 3];
            try {
                if (this.inputStream.read(buf) != buf.length) {
                    SWT.error(40);
                }
            }
            catch (IOException e) {
                SWT.error(39, e);
            }
            return this.paletteFromBytes(buf, numColors);
        }
        if (this.bitCount == 16) {
            return new PaletteData(31744, 992, 31);
        }
        if (this.bitCount == 24) {
            return new PaletteData(255, 65280, 0xFF0000);
        }
        return new PaletteData(65280, 0xFF0000, -16777216);
    }

    PaletteData paletteFromBytes(byte[] bytes, int numColors) {
        int bytesOffset = 0;
        RGB[] colors = new RGB[numColors];
        int i = 0;
        while (i < numColors) {
            colors[i] = new RGB(bytes[bytesOffset + 2] & 0xFF, bytes[bytesOffset + 1] & 0xFF, bytes[bytesOffset] & 0xFF);
            bytesOffset += 3;
            ++i;
        }
        return new PaletteData(colors);
    }

    void flipScanLines(byte[] data, int stride, int height) {
        int i1 = 0;
        int i2 = (height - 1) * stride;
        int i = 0;
        while (i < height / 2) {
            int index = 0;
            while (index < stride) {
                byte b = data[index + i1];
                data[index + i1] = data[index + i2];
                data[index + i2] = b;
                ++index;
            }
            i1 += stride;
            i2 -= stride;
            ++i;
        }
    }
}

