/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.canary;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.FunctionHook;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.MethodWrapper;
import com.aspect.snoop.agent.AgentCommunicationException;
import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.agent.SnoopAgent;
import com.aspect.snoop.agent.manager.InstrumentationException;
import com.aspect.snoop.agent.manager.InstrumentationManager;
import com.aspect.snoop.agent.manager.MethodChanges;
import com.aspect.snoop.ui.canary.ButtonColumn;
import com.aspect.snoop.ui.canary.Chirp;
import com.aspect.snoop.ui.canary.ShowMethodsView;
import com.aspect.snoop.util.CanaryUtil;
import com.aspect.snoop.util.ClasspathUtil;
import com.aspect.snoop.util.StringUtil;
import com.aspect.snoop.util.UIUtil;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;

public class StartCanaryModeView
extends JDialog {
    final DefaultTableModel model;
    SwingWorker canaryWorker = null;
    private JButton btnStartCanaryMode;
    private JButton btnStopCanaryMode;
    private JCheckBox chkIncludeJava;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JComboBox lstDataTypes;
    private JProgressBar prgCanary;
    private JTable tblCanaries;
    private JTextField txtCanary;
    private JTextField txtPackage;
    private List<Chirp> chirps = new ArrayList<Chirp>();

    public StartCanaryModeView(final Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.model = new DefaultTableModel(new Object[]{"Method", ""}, 0);
        this.tblCanaries.setRowHeight(25);
        this.tblCanaries.setModel(this.model);
        AbstractAction addHook = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = Integer.valueOf(e.getActionCommand());
                Chirp c = (Chirp)StartCanaryModeView.this.chirps.get(i);
                FunctionHook hook = new FunctionHook(c.getMethod());
                SnoopAgent.getMainView().addHook(hook);
                JOptionPane.showMessageDialog(parent, "Function hook added to " + hook.getClazz().getName() + "." + hook.getMethodName() + "()");
            }
        };
        new ButtonColumn(this.tblCanaries, addHook, 1);
        this.tblCanaries.getColumnModel().getColumn(0).setPreferredWidth(450);
    }

    private void initComponents() {
        this.btnStartCanaryMode = new JButton();
        this.txtCanary = new JTextField();
        this.jLabel2 = new JLabel();
        this.lstDataTypes = new JComboBox();
        this.btnStopCanaryMode = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tblCanaries = new JTable();
        this.txtPackage = new JTextField();
        this.jLabel3 = new JLabel();
        this.prgCanary = new JProgressBar();
        this.chkIncludeJava = new JCheckBox();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getResourceMap(StartCanaryModeView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                StartCanaryModeView.this.viewShown(evt);
            }
        });
        ApplicationActionMap actionMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getActionMap(StartCanaryModeView.class, (Object)this);
        this.btnStartCanaryMode.setAction(actionMap.get("beginCanaryMode"));
        this.btnStartCanaryMode.setFont(resourceMap.getFont("btnStartCanaryMode.font"));
        this.btnStartCanaryMode.setText(resourceMap.getString("btnStartCanaryMode.text", new Object[0]));
        this.btnStartCanaryMode.setToolTipText(resourceMap.getString("btnStartCanaryMode.toolTipText", new Object[0]));
        this.btnStartCanaryMode.setName("btnStartCanaryMode");
        this.txtCanary.setText(resourceMap.getString("txtCanary.text", new Object[0]));
        this.txtCanary.setToolTipText(resourceMap.getString("txtCanary.toolTipText", new Object[0]));
        this.txtCanary.setName("txtCanary");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.lstDataTypes.setModel(new DefaultComboBoxModel<String>(new String[]{"String", "short", "int", "long", "double", "float"}));
        this.lstDataTypes.setName("lstDataTypes");
        this.btnStopCanaryMode.setAction(actionMap.get("endCanaryMode"));
        this.btnStopCanaryMode.setFont(resourceMap.getFont("btnStopCanaryMode.font"));
        this.btnStopCanaryMode.setText(resourceMap.getString("btnStopCanaryMode.text", new Object[0]));
        this.btnStopCanaryMode.setToolTipText(resourceMap.getString("btnStopCanaryMode.toolTipText", new Object[0]));
        this.btnStopCanaryMode.setEnabled(false);
        this.btnStopCanaryMode.setName("btnStopCanaryMode");
        this.jScrollPane1.setName("jScrollPane1");
        this.tblCanaries.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tblCanaries.setName("tblCanaries");
        this.jScrollPane1.setViewportView(this.tblCanaries);
        this.txtPackage.setText(resourceMap.getString("txtPackage.text", new Object[0]));
        this.txtPackage.setToolTipText(resourceMap.getString("txtPackage.toolTipText", new Object[0]));
        this.txtPackage.setName("txtPackage");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.prgCanary.setName("prgCanary");
        this.chkIncludeJava.setText(resourceMap.getString("chkIncludeJava.text", new Object[0]));
        this.chkIncludeJava.setToolTipText(resourceMap.getString("chkIncludeJava.toolTipText", new Object[0]));
        this.chkIncludeJava.setName("chkIncludeJava");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 625, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtPackage, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkIncludeJava)).addComponent(this.prgCanary, GroupLayout.Alignment.LEADING, -1, 625, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtCanary).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lstDataTypes, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnStartCanaryMode, -2, 211, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnStopCanaryMode))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.txtCanary, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.lstDataTypes, -2, -1, -2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnStartCanaryMode, -2, 50, -2).addComponent(this.btnStopCanaryMode, -2, 50, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPackage, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.chkIncludeJava)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prgCanary, -2, 26, -2).addGap(7, 7, 7).addComponent(this.jScrollPane1, -1, 160, Short.MAX_VALUE)));
        this.pack();
    }

    private void viewShown(ComponentEvent evt) {
        this.repaint();
    }

    @Action
    public void beginCanaryMode() throws AgentCommunicationException {
        String canary = this.txtCanary.getText();
        final String pkg = this.txtPackage.getText();
        if (canary.length() <= 0) {
            UIUtil.showErrorMessage(this, "Please enter a value to track through the application");
            return;
        }
        this.setDefaultCloseOperation(0);
        String type = (String)this.lstDataTypes.getSelectedItem();
        try {
            final InstrumentationManager manager = SnoopAgent.getAgentManager();
            manager.resetAllClasses();
            CanaryUtil.currentCanary = canary;
            String cType = null;
            if ("String".equals(type)) {
                cType = "java.lang.String";
            } else if ("short".equals(type)) {
                cType = "java.lang.Short";
            } else if ("int".equals(type)) {
                cType = "java.lang.Integer";
            } else if ("long".equals(type)) {
                cType = "java.lang.Long";
            } else if ("double".equals(type)) {
                cType = "java.lang.Double";
            } else if ("float".equals(type)) {
                cType = "java.lang.Float";
            }
            final String canaryType = cType;
            if (canary == null) {
                throw new InstrumentationException("Can't apply canary to unknown type: " + type);
            }
            final StartCanaryModeView parent = this;
            this.canaryWorker = new SwingWorker(){
                int clsCount = 0;
                int mtdCount = 0;
                String finalMsg = null;
                String nl = System.getProperty("line.separator");

                @Override
                protected void done() {
                    StartCanaryModeView.this.prgCanary.setString(this.finalMsg);
                    StartCanaryModeView.this.prgCanary.setEnabled(false);
                    try {
                        final String methodList = (String)this.get();
                        StartCanaryModeView.this.prgCanary.addMouseListener(new MouseListener(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (e.getClickCount() != 2) {
                                    return;
                                }
                                ShowMethodsView view = new ShowMethodsView((Dialog)parent, true, methodList);
                                view.setVisible(true);
                            }

                            @Override
                            public void mousePressed(MouseEvent e) {
                            }

                            @Override
                            public void mouseReleased(MouseEvent e) {
                            }

                            @Override
                            public void mouseEntered(MouseEvent e) {
                            }

                            @Override
                            public void mouseExited(MouseEvent e) {
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        AgentLogger.error(ex);
                    }
                    catch (ExecutionException ex) {
                        AgentLogger.error(ex);
                    }
                }

                protected Object doInBackground() throws Exception {
                    String clsName;
                    StringBuilder sb = new StringBuilder();
                    StartCanaryModeView.this.prgCanary.setString("Starting canary mode...");
                    StartCanaryModeView.this.prgCanary.setStringPainted(true);
                    StartCanaryModeView.this.prgCanary.setEnabled(true);
                    List<Class> loadedClasses = manager.getLoadedClasses();
                    ArrayList<Class> targetClasses = new ArrayList<Class>();
                    for (Class c : loadedClasses) {
                        if (c == null || c.isInterface() || c.isArray()) continue;
                        clsName = c.getName();
                        if (pkg != null && pkg.length() > 0 && !clsName.startsWith(pkg) || ClasspathUtil.isJavaSnoopClass(clsName) || !StartCanaryModeView.this.chkIncludeJava.isSelected() && ClasspathUtil.isJavaOrSunClass(clsName)) continue;
                        targetClasses.add(c);
                    }
                    StartCanaryModeView.this.prgCanary.setMinimum(0);
                    StartCanaryModeView.this.prgCanary.setMaximum(targetClasses.size());
                    AgentLogger.debug("Applying canaries to " + targetClasses.size() + " classes...");
                    for (int i = 0; i < targetClasses.size(); ++i) {
                        Class c;
                        if (this.isCancelled()) {
                            return null;
                        }
                        c = (Class)targetClasses.get(i);
                        clsName = c.getName();
                        StartCanaryModeView.this.prgCanary.setValue(i);
                        StartCanaryModeView.this.prgCanary.setString("Adding canaries to class " + c.getName() + " (" + (i + 1) + "/" + (targetClasses.size() + 1) + ")");
                        ArrayList<MethodChanges> classChanges = new ArrayList<MethodChanges>();
                        Method[] methods = null;
                        try {
                            methods = c.getDeclaredMethods();
                        }
                        catch (Throwable t) {
                            AgentLogger.warn("Problem analyzing method for canary purposes", t);
                            continue;
                        }
                        Constructor<?>[] constructors = null;
                        try {
                            constructors = c.getDeclaredConstructors();
                        }
                        catch (Throwable t) {
                            AgentLogger.trace("Failed to canary " + c.getName() + ": " + t.getMessage());
                        }
                        ArrayList<Executable> members = new ArrayList<Executable>();
                        if (methods != null) {
                            members.addAll(Arrays.asList(methods));
                        }
                        if (constructors != null) {
                            members.addAll(Arrays.asList(constructors));
                        }
                        for (Member member : members) {
                            if (Modifier.isAbstract(member.getModifiers())) continue;
                            Class<?>[] types = null;
                            types = member instanceof Constructor ? ((Constructor)member).getParameterTypes() : ((Method)member).getParameterTypes();
                            boolean alreadyMatched = false;
                            for (Class<?> paramType : types) {
                                boolean match;
                                if (alreadyMatched || !(match = paramType.getName().equals(canaryType))) continue;
                                alreadyMatched = true;
                                MethodWrapper wrapper = MethodWrapper.getWrapper((AccessibleObject)((Object)member));
                                MethodChanges change = new MethodChanges((AccessibleObject)((Object)member));
                                change.setNewStartSrc(CanaryUtil.getChirp(canaryType, clsName, wrapper.getName(), wrapper.getReturnType().getName()));
                                AgentLogger.debug("Applying canary to " + wrapper.getDescription());
                                sb.append(wrapper.getDescription());
                                sb.append(this.nl);
                                classChanges.add(change);
                                ++this.mtdCount;
                            }
                        }
                        try {
                            manager.instrument(c, classChanges.toArray(new MethodChanges[0]));
                            ++this.clsCount;
                            continue;
                        }
                        catch (InstrumentationException ex) {
                            AgentLogger.debug("Failed to apply canary to " + clsName + ": " + ex.getMessage());
                        }
                    }
                    StartCanaryModeView.this.prgCanary.setValue(StartCanaryModeView.this.prgCanary.getMaximum());
                    this.finalMsg = "Successfully canaried " + this.clsCount + " classes and " + this.mtdCount + " methods.";
                    AgentLogger.info(this.finalMsg);
                    return sb.toString();
                }
            };
            this.canaryWorker.execute();
            this.txtCanary.setEnabled(false);
            this.lstDataTypes.setEnabled(false);
            this.btnStartCanaryMode.setEnabled(false);
            this.btnStopCanaryMode.setEnabled(true);
        }
        catch (InstrumentationException ex) {
            UIUtil.showErrorMessage(this, StringUtil.exception2string(ex));
            AgentLogger.error(ex);
        }
    }

    @Action
    public void endCanaryMode() throws AgentCommunicationException {
        if (this.canaryWorker != null) {
            this.canaryWorker.cancel(true);
            while (!this.canaryWorker.isDone()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
        }
        this.txtCanary.setEnabled(true);
        this.lstDataTypes.setEnabled(true);
        this.btnStartCanaryMode.setEnabled(true);
        this.btnStopCanaryMode.setEnabled(false);
        try {
            SnoopAgent.getAgentManager().resetAllClasses();
            CanaryUtil.currentCanary = null;
        }
        catch (InstrumentationException ex) {
            UIUtil.showErrorMessage(this, StringUtil.exception2string(ex));
            AgentLogger.error(ex);
        }
        this.setDefaultCloseOperation(2);
    }

    public void addChirp(Class c, AccessibleObject method) {
        this.chirps.add(new Chirp(c, method));
        this.model.addRow(new Object[]{method.toString(), "Add Hook"});
        this.model.fireTableDataChanged();
    }
}

