/*
 * Decompiled with CFR 0.152.
 */
package entities;

public class HashEntry {
    private String hash;
    private String salt = null;
    private String saltType = "utf8";
    private boolean preSalt = true;
    private static final String SEPARATOR = ":";
    private static final String[] SALT_TYPES = new String[]{"utf8", "hex", "int64"};

    public HashEntry() {
    }

    public HashEntry(String line) {
        String aux = HashEntry.gerFirstField(line);
        if (aux != null) {
            this.hash = aux;
        }
        if ((line = HashEntry.removeFirstField(line)) != null) {
            aux = HashEntry.gerFirstField(line);
            if (aux != null) {
                this.salt = aux;
            }
            if ((line = HashEntry.removeFirstField(line)) != null) {
                aux = HashEntry.gerFirstField(line);
                if (aux != null) {
                    if (aux.equalsIgnoreCase("pre")) {
                        this.preSalt = true;
                    } else if (aux.equalsIgnoreCase("pos")) {
                        this.preSalt = false;
                    }
                }
                if ((line = HashEntry.removeFirstField(line)) != null && (aux = HashEntry.gerFirstField(line)) != null && HashEntry.isValidSaltType(aux)) {
                    this.saltType = aux;
                }
            }
        }
    }

    private static final String removeFirstField(String s) {
        String returnValue = null;
        int idx = s.indexOf(SEPARATOR, 0);
        if (idx != -1) {
            returnValue = s.substring(idx + 1, s.length());
        }
        return returnValue;
    }

    private static final String gerFirstField(String s) {
        String returnValue = null;
        int idx = s.indexOf(SEPARATOR, 0);
        if (idx == -1) {
            idx = s.length();
        }
        if ((returnValue = s.substring(0, idx)).equalsIgnoreCase("")) {
            returnValue = null;
        }
        return returnValue;
    }

    public HashEntry(String hash, String salt, String saltType, boolean preSalt) {
        this.hash = hash;
        this.salt = salt;
        this.saltType = saltType;
        this.preSalt = preSalt;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getSaltType() {
        return this.saltType;
    }

    public void setSaltType(String saltType) {
        this.saltType = saltType;
    }

    public boolean isPreSalt() {
        return this.preSalt;
    }

    public void setPreSalt(String salt) {
        this.salt = salt;
        this.preSalt = true;
    }

    public void setPostSalt(String salt) {
        this.salt = salt;
        this.preSalt = false;
    }

    public String getSalt() {
        return this.salt;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.hash + SEPARATOR + this.salt + SEPARATOR;
        s = this.preSalt ? String.valueOf(s) + "pre" + SEPARATOR : String.valueOf(s) + "pos" + SEPARATOR;
        s = String.valueOf(s) + this.saltType;
        return s;
    }

    public static final boolean isValidSaltType(String saltType) {
        boolean returnValue = false;
        int i = 0;
        while (i < SALT_TYPES.length) {
            if (saltType.equalsIgnoreCase(SALT_TYPES[i])) {
                returnValue = true;
                break;
            }
            ++i;
        }
        return returnValue;
    }
}

