/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.util.LogLevelUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public class DnsServer {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final InjectionModel injectionModel;
    private final List<String> results = new ArrayList<String>();
    private DatagramSocket socket;
    private boolean isStopped = false;

    public DnsServer(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        try {
            this.socket = new DatagramSocket(null);
        }
        catch (SocketException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public static void main(String[] args) {
        new Thread(new DnsServer(new InjectionModel())::listen).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen() {
        this.socket.close();
        int port = Integer.parseInt(this.injectionModel.getMediatorUtils().preferencesUtil().getDnsPort());
        String domainName = this.injectionModel.getMediatorUtils().preferencesUtil().getDnsDomain();
        this.results.clear();
        try (DatagramSocket newSocket = new DatagramSocket(port);){
            this.socket = newSocket;
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "DNS listening on port [{}] for [{}]...", (Object)port, (Object)domainName);
            byte[] buffer = new byte[512];
            while (!this.isStopped) {
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                this.socket.receive(packet);
                Message query = new Message(packet.getData());
                Record question = query.getQuestion();
                Name name = question.getName();
                if (name.toString().contains(domainName)) {
                    this.results.add(name.toString());
                }
                Message response = new Message(query.getHeader().getID());
                response.getHeader().setFlag(0);
                response.addRecord(question, 0);
                response.addRecord(Record.fromString(Name.fromString(domainName + "."), 1, 1, 86400L, "127.0.0.1", Name.fromString(domainName + ".")), 1);
                byte[] responseData = response.toWire();
                DatagramPacket responsePacket = new DatagramPacket(responseData, responseData.length, packet.getAddress(), packet.getPort());
                this.socket.send(responsePacket);
            }
        }
        catch (SocketException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        finally {
            this.isStopped = false;
        }
    }

    public void close() {
        this.socket.close();
        this.isStopped = false;
    }

    public List<String> getResults() {
        return this.results;
    }
}

