/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.exception.JSqlRuntimeException;
import com.jsql.util.LogLevelUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class PropertiesUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final Properties properties = new Properties();

    public PropertiesUtil() {
        String filename = "config.properties";
        try (InputStream input = PropertiesUtil.class.getClassLoader().getResourceAsStream(filename);){
            if (input == null) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Properties file {} not found", (Object)filename);
                return;
            }
            this.properties.load(input);
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public void displayI18nStatus(Locale newLocale) {
        if (!Arrays.asList("", "en").contains(newLocale.getLanguage())) {
            AtomicInteger countGui = new AtomicInteger();
            Properties bundleRoot = PropertiesUtil.getProperties("/i18n/jsql.properties");
            Properties bundleUser = PropertiesUtil.getProperties("/i18n/jsql_" + newLocale.getLanguage() + ".properties");
            bundleRoot.entrySet().stream().filter(key -> bundleUser.isEmpty() || !bundleUser.containsKey(key.getKey())).forEach(key -> countGui.getAndIncrement());
            if (countGui.get() > 0) {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = () -> newLocale.getDisplayLanguage(newLocale);
                supplierArray[1] = () -> BigDecimal.valueOf(100.0 - (double)countGui.get() * 100.0 / (double)bundleRoot.size()).setScale(1, RoundingMode.HALF_UP).doubleValue();
                supplierArray[2] = countGui::get;
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Switched to {} with {}% translated, contribute and translate any of remaining {} items in menu Community", supplierArray);
            }
        }
    }

    private static Properties getProperties(String name) {
        Properties properties;
        block9: {
            properties = new Properties();
            try (InputStream in = PropertiesUtil.class.getResourceAsStream(name);){
                if (in != null) {
                    byte[] root = in.readAllBytes();
                    String rootI18n = new String(root, StandardCharsets.UTF_8);
                    String rootI18nFixed = Pattern.compile("\\\\[\n\r]+").matcher(Matcher.quoteReplacement(rootI18n)).replaceAll("a");
                    properties.load(new StringReader(rootI18nFixed));
                    break block9;
                }
                throw new JSqlRuntimeException("Resource not found: " + name);
            }
            catch (IOException e) {
                throw new JSqlRuntimeException(e);
            }
        }
        return properties;
    }

    public String getVersionJsql() {
        return this.properties.getProperty("jsql.version");
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }
}

