# kismet2earth

## Modernization Covenant

This is a refactored and modernized edition of [kismet2earth](https://code.google.com/archive/p/kismet2earth), a set of utilities that convert from Kismet logs to Google Earth .kml format.

Key changes:

- ✅ Migration to Python 3

### Installation

#### Dependencies

Runtime dependencies:
```
python sqlite
```

#### From source

```bash
git clone https://github.com/Obsidian-Covenant/kismet2earth.git
cd kismet2earth
python k2db.py
python db2ge.py
```

### Usage

Create a fresh test database from SQL:
```shell
sqlite3 test.db < kismet2earth.sql
```

Use a `.netxml` file, or, for testing, create a new one `test.netxml`:
```xml
<?xml version="1.0" encoding="UTF-8"?>
<detection-run>
  <wireless-network type="infrastructure">
    <BSSID>00:11:22:33:44:55</BSSID>
    <manuf>TestCorp</manuf>
    <channel>6</channel>
    <essid>MyWiFi</essid>
    <encryption>WPA2</encryption>
    <gps-info>
      <avg-lat>46.9480</avg-lat>
      <avg-lon>7.4474</avg-lon>
    </gps-info>
  </wireless-network>

  <wireless-network type="infrastructure">
    <BSSID>AA:BB:CC:DD:EE:FF</BSSID>
    <manuf>OldSchool Inc</manuf>
    <channel>11</channel>
    <essid>OpenCafe</essid>
    <encryption>None</encryption>
    <gps-info>
      <avg-lat>47.3769</avg-lat>
      <avg-lon>8.5417</avg-lon>
    </gps-info>
  </wireless-network>
</detection-run>
```

Import netxml into SQLite:
```shell
python k2db.py -i test.netxml -o test.db
```

Export SQLite to KML:
```shell
python db2ge.py -i test.db -o test.kml -a
```
or test filters:
```shell
python db2ge.py -i test.db -o wpa_only.kml -w
python db2ge.py -i test.db -o open_only.kml -n
```

Sanity-check the KML:
```shell
head -n 30 test.kml
grep -n "<Placemark>" -n test.kml
grep -n "coordinates" test.kml
```

Now visual test in Google Earth. Open `test.kml` in Google Earth (desktop or web). You should see 2 placemarks roughly around:
* Bern (46.9480, 7.4474)
* Zürich (47.3769, 8.5417)