/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.language;

import com.paterva.maltego.automation.Compilation;
import com.paterva.maltego.automation.CompilationException;
import com.paterva.maltego.automation.MachineCompilation;
import com.paterva.maltego.automation.MachineCompiler;
import com.paterva.maltego.automation.MachineCompilerOptions;
import com.paterva.maltego.automation.language.Function;
import com.paterva.maltego.automation.language.Machine;
import com.paterva.maltego.automation.language.MachineBuilder;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import org.openide.util.Lookup;

public class DefaultMachineCompiler
extends MachineCompiler {
    @Override
    public MachineCompilation compile(String code, MachineCompilerOptions options) throws CompilationException {
        if (code == null) {
            throw new CompilationException("No code to compile.");
        }
        Machine machine = this.build(code, options);
        return this.compile(machine);
    }

    private Machine build(String code, MachineCompilerOptions options) throws CompilationException {
        try {
            MachineBuilder builder = new MachineBuilder(options.createActionRegistry());
            CompilerConfiguration compiler = new CompilerConfiguration();
            SecureASTCustomizer secureCustomizer = this.createSecureCustomizer();
            compiler.addCompilationCustomizers(new CompilationCustomizer[]{secureCustomizer});
            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Binding binding = new Binding();
            binding.setVariable("builder", (Object)builder);
            GroovyShell shell = new GroovyShell(cl, binding, compiler);
            shell.evaluate(DefaultMachineCompiler.getMachineScript(code));
            return builder.getMachine();
        }
        catch (Exception ex) {
            throw new CompilationException(ex);
        }
    }

    private static String getMachineScript(String code) {
        return "builder.automaton {\n" + code + "\n}";
    }

    private MachineCompilation compile(Machine machine) throws CompilationException {
        MainConnector input = new MainConnector();
        MainConnector output = new MainConnector();
        String emptyMachineMsg = "No 'start' method was found in machine.";
        if (machine == null) {
            throw new CompilationException(emptyMachineMsg);
        }
        Function main = machine.getMain();
        if (main == null) {
            throw new CompilationException(emptyMachineMsg);
        }
        Compilation mainCompilation = main.compile();
        mainCompilation.addChild(input);
        mainCompilation.addChild(output);
        mainCompilation.getOutput().addChild(output);
        input.addChild(mainCompilation.getInput());
        mainCompilation.setInput(input);
        mainCompilation.setOutput(input);
        this.dissolveConnectors(mainCompilation.getChildren());
        this.updateInputCount(mainCompilation);
        MachineCompilation machineCompilation = new MachineCompilation(mainCompilation);
        machineCompilation.setName(machine.getValueOrProperty("name", "").toString());
        machineCompilation.setDescription(machine.getProperty("description", "").toString());
        machineCompilation.setAuthor(machine.getProperty("author", "").toString());
        machineCompilation.setDisplayName(machine.getProperty("displayName", "").toString());
        if (machine.getTimer() != null) {
            machineCompilation.setTimerInterval(machine.getTimer().getInterval());
        }
        return machineCompilation;
    }

    private void dissolveConnectors(Collection<Compilation.Node> elements) {
        for (Compilation.Node element : elements) {
            if (!(element instanceof Compilation.Connector)) continue;
            this.rewireConnector(elements, (Compilation.Connector)element);
        }
        Iterator<Compilation.Node> it = elements.iterator();
        while (it.hasNext()) {
            Compilation.Node element;
            element = it.next();
            if (!(element instanceof Compilation.Connector)) continue;
            it.remove();
        }
    }

    private void rewireConnector(Collection<Compilation.Node> elements, Compilation.Connector connector) {
        Collection<Compilation.Node> dependants = connector.getChildren();
        Collection<Compilation.Node> parents = this.findParents(elements, connector);
        for (Compilation.Node parent : parents) {
            parent.removeChild(connector);
            parent.addChildren(dependants);
        }
    }

    private Collection<Compilation.Node> findParents(Collection<Compilation.Node> elements, Compilation.Node element) {
        HashSet<Compilation.Node> parents = new HashSet<Compilation.Node>();
        for (Compilation.Node e : elements) {
            if (!e.getChildren().contains(element)) continue;
            parents.add(e);
        }
        return parents;
    }

    private void updateInputCount(Compilation compilation) {
        Collection<Compilation.Node> elements = compilation.getChildren();
        for (Compilation.Node e : elements) {
            e.setParentCount(this.findParents(elements, e).size());
        }
    }

    private SecureASTCustomizer createSecureCustomizer() {
        SecureASTCustomizer secureCustomizer = new SecureASTCustomizer();
        secureCustomizer.setMethodDefinitionAllowed(false);
        secureCustomizer.setPackageAllowed(false);
        secureCustomizer.setIndirectImportCheckEnabled(true);
        ArrayList<String> importsWhitelist = new ArrayList<String>();
        importsWhitelist.add("java.lang.Object");
        secureCustomizer.setImportsWhitelist(importsWhitelist);
        secureCustomizer.setStarImportsWhitelist(Collections.EMPTY_LIST);
        ArrayList<Class<EmptyStatement>> statementsWhitelist = new ArrayList<Class<EmptyStatement>>();
        statementsWhitelist.add(BlockStatement.class);
        statementsWhitelist.add(ExpressionStatement.class);
        statementsWhitelist.add(EmptyStatement.class);
        secureCustomizer.setStatementsWhitelist(statementsWhitelist);
        return secureCustomizer;
    }

    public class MainConnector
    extends Compilation.AbstractNode {
    }
}

