/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.js.nodes.function.BuiltinArgumentBuilder;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;

public interface BuiltinEnum<E extends Enum<? extends BuiltinEnum<E>>> {
    default public E asEnum() {
        return (E)((Enum)((Object)this));
    }

    default public String getName() {
        return this.prependAccessorPrefix(BuiltinEnum.stripName(((Enum)this.asEnum()).name()));
    }

    default public Object getKey() {
        return BuiltinEnum.stripName(((Enum)this.asEnum()).name());
    }

    default public boolean isConstructor() {
        return false;
    }

    default public boolean isNewTargetConstructor() {
        return false;
    }

    public int getLength();

    default public boolean isEnabled() {
        return true;
    }

    default public boolean isAOTSupported() {
        return true;
    }

    default public int getECMAScriptVersion() {
        return 5;
    }

    default public boolean isAnnexB() {
        return false;
    }

    default public boolean isWritable() {
        return true;
    }

    default public boolean isConfigurable() {
        return true;
    }

    default public boolean isEnumerable() {
        return false;
    }

    default public boolean isGetter() {
        return false;
    }

    default public boolean isSetter() {
        return false;
    }

    default public Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget) {
        throw new UnsupportedOperationException();
    }

    default public BuiltinArgumentBuilder args() {
        return BuiltinArgumentBuilder.builder();
    }

    public static String stripName(String name) {
        if (name.endsWith("_") && !name.endsWith("__")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    default public String prependAccessorPrefix(String name) {
        if (this.isGetter()) {
            return "get " + name;
        }
        if (this.isSetter()) {
            return "set " + name;
        }
        return name;
    }
}

