/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.binding;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.registry.DefaultEntityRegistry;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.SlownessDetector;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;
import yguard.A.J.SA;

public class ImagePropertyTest
extends TopGraphAction {
    public String getName() {
        return "ImagePropertyTest";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void actionPerformed(TopComponent tc) {
        SlownessDetector.setEnabled((boolean)false);
        this.testCategoryNameVsAliasMappings();
    }

    private void testCategoryNameVsAliasMappings() {
        try {
            RegistryIcon icon;
            SA viewGraph = this.getTopViewGraph();
            GraphID graphID = GraphViewManager.getDefault().getGraphID(viewGraph);
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphDataStoreWriter writer = graphStore.getGraphDataStore().getDataStoreWriter();
            writer.beginUpdate();
            viewGraph.\u00cc();
            EntityFactory entityFactory = EntityFactory.forGraphID((GraphID)graphID);
            DefaultEntityRegistry entityRegistry = new DefaultEntityRegistry();
            String testCase = "testCategoryNameVsAliasMappings";
            IconRegistry registry = IconRegistry.getDefault();
            List icons = registry.getCategories().stream().map(arg_0 -> ((IconRegistry)registry).getIcons(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
            Integer[] count = new Integer[]{0};
            Iterator iterator = icons.iterator();
            while (iterator.hasNext() && !this.addEntities(icon = (RegistryIcon)iterator.next(), entityRegistry, entityFactory, testCase, icon.getName(), graphID, count)) {
                String iconAlias;
                Iterator iterator2 = icon.getAliases().iterator();
                while (iterator2.hasNext() && !this.addEntities(icon, entityRegistry, entityFactory, testCase, iconAlias = (String)iterator2.next(), graphID, count)) {
                }
            }
            System.out.println("Commiting...");
            viewGraph.D((Object)false);
            writer.endUpdate();
            viewGraph.\u00ff();
            System.out.println("Done");
        }
        catch (GraphStoreException | TypeInstantiationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private boolean addEntities(RegistryIcon icon, DefaultEntityRegistry entityRegistry, EntityFactory entityFactory, final String testCase, final String iconNameOrAlias, GraphID graphID, Integer[] count) throws TypeInstantiationException {
        final String category = icon.getCategory();
        if (!category.equalsIgnoreCase("Flags")) {
            MaltegoEntitySpec personSpec1 = entityRegistry.get("maltego.Person");
            MaltegoEntity personEntity1 = entityFactory.createInstance(personSpec1, true, true);
            personEntity1.setImageExpression("$property(person.lastname)");
            PropertyDescriptorCollection properties1 = personEntity1.getProperties();
            for (PropertyDescriptor property : properties1) {
                if (!property.getDisplayName().toLowerCase().contains("surname")) continue;
                personEntity1.setValue(property, (Object)(category + "/" + iconNameOrAlias));
            }
            GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)personEntity1);
            EntityID personEntityId1 = (EntityID)personEntity1.getID();
            final Image[] img = new Image[]{null, null};
            final Boolean[] imgSet = new Boolean[]{false, false};
            ImageCallback cb1 = new ImageCallback(){

                public void imageReady(Image image) {
                    img[0] = image;
                    imgSet[0] = true;
                    if (!ImagePropertyTest.isSameIcon(img[0], imgSet[0], img[1], imgSet[1])) {
                        System.out.println("  " + testCase + " --> " + category + "/" + iconNameOrAlias + " != " + iconNameOrAlias);
                    }
                }
            };
            this.getImage(graphID, personEntityId1, cb1);
            MaltegoEntitySpec personSpec2 = entityRegistry.get("maltego.Person");
            MaltegoEntity personEntity2 = entityFactory.createInstance(personSpec2, true, true);
            personEntity2.setImageExpression("$property(person.lastname)");
            PropertyDescriptorCollection properties2 = personEntity2.getProperties();
            for (PropertyDescriptor property : properties2) {
                if (!property.getDisplayName().toLowerCase().contains("surname")) continue;
                personEntity2.setValue(property, (Object)iconNameOrAlias);
            }
            GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)personEntity2);
            EntityID personEntityId2 = (EntityID)personEntity2.getID();
            ImageCallback cb2 = new ImageCallback(){

                public void imageReady(Image image) {
                    img[1] = image;
                    imgSet[1] = true;
                    if (!ImagePropertyTest.isSameIcon(img[0], imgSet[0], img[1], imgSet[1])) {
                        System.out.println("  " + testCase + " --> " + category + "/" + iconNameOrAlias + " != " + iconNameOrAlias);
                    }
                }
            };
            this.getImage(graphID, personEntityId2, cb2);
            Integer[] integerArray = count;
            Integer n = integerArray[0];
            Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
            if (count[0] > 5) {
                return true;
            }
        }
        return false;
    }

    private static boolean isSameIcon(Image img1, boolean img1Set, Image img2, boolean img2Set) {
        if (img1Set && img2Set) {
            BufferedImage bIcon2;
            if (img1 == null || img2 == null) {
                return false;
            }
            BufferedImage bIcon1 = ImageUtils.createBufferedImage((Image)img1);
            if (!ImageUtils.equals((BufferedImage)bIcon1, (BufferedImage)(bIcon2 = ImageUtils.createBufferedImage((Image)img2)))) {
                return false;
            }
        }
        return true;
    }

    public void getImage(GraphID graphID, EntityID entityID, ImageCallback cb) {
        try {
            int modelEntityCount = this.getModelEntities(graphID, entityID).size();
            if (modelEntityCount == 1) {
                ImageIcon smallTypeIcon = EntityImageFactory.forGraph((GraphID)graphID).getSmallTypeIcon(this.getTypeName(graphID, entityID));
                cb.imageReady(smallTypeIcon.getImage());
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getTypeName(GraphID graphID, EntityID entityID) {
        String typeName = null;
        try {
            Set<EntityID> modelEntities = this.getModelEntities(graphID, entityID);
            EntityID entity = modelEntities.iterator().next();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
            typeName = dataReader.getEntityType(entity);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return typeName;
    }

    private Set<EntityID> getModelEntities(GraphID graphID, EntityID entityID) throws GraphStoreException {
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        GraphModelViewMappings mappings = view.getModelViewMappings();
        Set modelEntities = mappings.getModelEntities(entityID);
        return modelEntities;
    }
}

