/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.propertyview;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import java.util.ArrayList;
import java.util.Arrays;

public class PropertyTypes {
    private static final String[] _valueTypes = new String[]{"string", "date", "int", "double", "url"};
    private static final String[] _imageTypes = new String[]{"image", "url", "string", "attachments"};

    private PropertyTypes() {
    }

    public static TypeDescriptor[] valueTypes() {
        return PropertyTypes.getTypes(_valueTypes);
    }

    private static TypeDescriptor[] getTypes(String[] names) {
        TypeRegistry registry = TypeRegistry.getDefault();
        ArrayList<TypeDescriptor> list = new ArrayList<TypeDescriptor>();
        for (String name : names) {
            list.add(registry.getType(name));
        }
        return list.toArray(new TypeDescriptor[list.size()]);
    }

    public static TypeDescriptor[] allTypes() {
        return TypeRegistry.getDefault().getTypes();
    }

    public static PropertyDescriptor[] getValueProperties(MaltegoEntity entity) {
        return PropertyTypes.getPropertiesOfType(entity.getProperties(), _valueTypes);
    }

    public static PropertyDescriptor[] getImageProperties(MaltegoEntity entity) {
        return PropertyTypes.getPropertiesOfType(entity.getProperties(), _imageTypes);
    }

    public static PropertyDescriptor[] getDisplayValueProperties(MaltegoEntity entity) {
        return PropertyTypes.getValueProperties(entity);
    }

    private static PropertyDescriptor[] getPropertiesOfType(PropertyDescriptorCollection descriptors, String[] types) {
        Object[] sorted = Arrays.copyOf(types, types.length);
        Arrays.sort(sorted);
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor d : descriptors) {
            if (Arrays.binarySearch(sorted, TypeRegistry.getDefault().getType(d.getType()).getTypeName()) < 0) continue;
            list.add(d);
        }
        return list.toArray(new PropertyDescriptor[list.size()]);
    }
}

