/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.Profile;

public abstract class LoopConditionProfile
extends ConditionProfile {
    LoopConditionProfile() {
    }

    @Override
    public abstract boolean profile(boolean var1);

    public abstract void profileCounted(long var1);

    public abstract boolean inject(boolean var1);

    public static LoopConditionProfile createCountingProfile() {
        if (Profile.isProfilingEnabled()) {
            return Enabled.createLazyLoadClass();
        }
        return Disabled.INSTANCE;
    }

    public static LoopConditionProfile getUncached() {
        return Disabled.INSTANCE;
    }

    static final class Disabled
    extends LoopConditionProfile {
        static final LoopConditionProfile INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        protected Object clone() {
            return INSTANCE;
        }

        @Override
        public boolean profile(boolean condition) {
            return condition;
        }

        @Override
        public void profileCounted(long length) {
        }

        @Override
        public boolean inject(boolean condition) {
            return condition;
        }

        public String toString() {
            return this.toStringDisabled(LoopConditionProfile.class);
        }
    }

    static final class Enabled
    extends LoopConditionProfile {
        @CompilerDirectives.CompilationFinal
        private long trueCount;
        @CompilerDirectives.CompilationFinal
        private int falseCount;

        Enabled() {
        }

        @Override
        public boolean profile(boolean condition) {
            long trueCountLocal = this.trueCount;
            int falseCountLocal = this.falseCount;
            if (trueCountLocal == 0L && condition) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (CompilerDirectives.inInterpreter()) {
                if (condition) {
                    if (trueCountLocal < Long.MAX_VALUE) {
                        this.trueCount = trueCountLocal + 1L;
                    }
                } else if (falseCountLocal < Integer.MAX_VALUE) {
                    this.falseCount = falseCountLocal + 1;
                }
                return condition;
            }
            return CompilerDirectives.injectBranchProbability(Enabled.calculateProbability(trueCountLocal, falseCountLocal), condition);
        }

        @Override
        public void profileCounted(long length) {
            long trueCountLocal;
            if (CompilerDirectives.inInterpreter() && (trueCountLocal = this.trueCount + length) >= 0L) {
                this.trueCount = trueCountLocal;
                int falseCountLocal = this.falseCount;
                if (falseCountLocal < Integer.MAX_VALUE) {
                    this.falseCount = falseCountLocal + 1;
                }
            }
        }

        @Override
        public boolean inject(boolean condition) {
            if (CompilerDirectives.inCompiledCode()) {
                return CompilerDirectives.injectBranchProbability(Enabled.calculateProbability(this.trueCount, this.falseCount), condition);
            }
            return condition;
        }

        private static double calculateProbability(long trueCountLocal, int falseCountLocal) {
            if (falseCountLocal == 0 && trueCountLocal == 0L) {
                return 0.0;
            }
            return (double)trueCountLocal / (double)(trueCountLocal + (long)falseCountLocal);
        }

        long getTrueCount() {
            return this.trueCount;
        }

        int getFalseCount() {
            return this.falseCount;
        }

        public String toString() {
            return this.toString(LoopConditionProfile.class, this.falseCount == 0, false, String.format("trueProbability=%s (trueCount=%s, falseCount=%s)", Enabled.calculateProbability(this.trueCount, this.falseCount), this.trueCount, this.falseCount));
        }

        static LoopConditionProfile createLazyLoadClass() {
            return new Enabled();
        }
    }
}

