/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.object.DynamicObjectImpl;
import com.oracle.truffle.object.Flags;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.PropertyMap;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.Transition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public abstract class LayoutStrategy {
    protected LayoutStrategy() {
    }

    protected final LocationFactory getDefaultLocationFactory() {
        return this.getDefaultLocationFactory(0L);
    }

    protected abstract LocationFactory getDefaultLocationFactory(long var1);

    protected abstract int getLocationOrdinal(Location var1);

    protected abstract boolean updateShape(DynamicObject var1);

    protected abstract ShapeImpl ensureValid(ShapeImpl var1);

    protected abstract ShapeImpl ensureSpace(ShapeImpl var1, Location var2);

    public abstract ShapeImpl.BaseAllocator createAllocator(LayoutImpl var1);

    public abstract ShapeImpl.BaseAllocator createAllocator(ShapeImpl var1);

    protected ShapeImpl defineProperty(ShapeImpl shape, Object key, Object value, int flags, LocationFactory locationFactory) {
        ShapeImpl oldShape = shape;
        if (!oldShape.isValid()) {
            oldShape = this.ensureValid(oldShape);
        }
        Property existing = oldShape.getProperty(key);
        return this.defineProperty(oldShape, key, value, flags, locationFactory, existing, 0L);
    }

    protected ShapeImpl defineProperty(ShapeImpl oldShape, Object key, Object value, int propertyFlags, LocationFactory locationFactory, Property existing, long putFlags) {
        if (existing == null) {
            Location location = locationFactory.createLocation(oldShape, value);
            Property property = Property.create(key, location, propertyFlags);
            if (Flags.isSeparateShape(putFlags)) {
                return this.createSeparateShape(oldShape).addProperty(property);
            }
            return oldShape.addProperty(property);
        }
        if (existing.getFlags() == propertyFlags) {
            if (existing.getLocation().canSet(value)) {
                return oldShape;
            }
            return this.definePropertyGeneralize(oldShape, existing, value, locationFactory, putFlags);
        }
        Location oldLocation = existing.getLocation();
        Location newLocation = oldLocation.canSet(value) ? oldLocation : oldShape.allocator().locationForValueUpcast(value, oldLocation, putFlags);
        Property newProperty = Property.create(existing.getKey(), newLocation, propertyFlags);
        oldShape.onPropertyTransition(existing);
        return this.replaceProperty(oldShape, existing, newProperty);
    }

    protected ShapeImpl definePropertyGeneralize(ShapeImpl oldShape, Property oldProperty, Object value, LocationFactory locationFactory, long putFlags) {
        if (Flags.isSeparateShape(putFlags)) {
            Property newProperty = oldProperty.relocate(locationFactory.createLocation(oldShape, value));
            oldShape.onPropertyTransition(oldProperty);
            return this.separateReplaceProperty(oldShape, oldProperty, newProperty);
        }
        if (oldProperty.getLocation().isValue()) {
            Property newProperty = oldProperty.relocate(locationFactory.createLocation(oldShape, value));
            oldShape.onPropertyTransition(oldProperty);
            return this.directReplaceProperty(oldShape, oldProperty, newProperty);
        }
        return this.generalizeProperty(oldProperty, value, oldShape, oldShape, putFlags);
    }

    @Deprecated
    protected ShapeImpl generalizeProperty(Property oldProperty, Object value, ShapeImpl currentShape, ShapeImpl nextShape) {
        return this.generalizeProperty(oldProperty, value, currentShape, nextShape, 0L);
    }

    protected ShapeImpl generalizeProperty(Property oldProperty, Object value, ShapeImpl currentShape, ShapeImpl nextShape, long putFlags) {
        Location oldLocation = oldProperty.getLocation();
        Location newLocation = currentShape.allocator().locationForValueUpcast(value, oldLocation, putFlags);
        Property newProperty = oldProperty.relocate(newLocation);
        nextShape.onPropertyTransition(oldProperty);
        return this.replaceProperty(nextShape, oldProperty, newProperty);
    }

    protected void propertySetFallback(Property property, DynamicObject store, Object value, ShapeImpl currentShape) {
        ShapeImpl oldShape = currentShape;
        ShapeImpl newShape = this.defineProperty(oldShape, property.getKey(), value, property.getFlags(), this.getDefaultLocationFactory());
        Property newProperty = newShape.getProperty(property.getKey());
        newProperty.setSafe(store, value, oldShape, newShape);
    }

    protected void propertySetWithShapeFallback(Property property, DynamicObject store, Object value, ShapeImpl currentShape, ShapeImpl nextShape) {
        ShapeImpl oldShape = currentShape;
        ShapeImpl newNextShape = this.generalizeProperty(property, value, oldShape, nextShape);
        Property newProperty = newNextShape.getProperty(property.getKey());
        newProperty.setSafe(store, value, oldShape, newNextShape);
    }

    protected void objectDefineProperty(DynamicObjectImpl object, Object key, Object value, int flags, LocationFactory locationFactory, ShapeImpl currentShape) {
        ShapeImpl oldShape = currentShape;
        Property oldProperty = oldShape.getProperty(key);
        ShapeImpl newShape = this.defineProperty(oldShape, key, value, flags, locationFactory, oldProperty, 0L);
        if (oldShape == newShape) {
            assert (oldProperty.equals(newShape.getProperty(key)));
            oldProperty.setSafe(object, value, oldShape);
        } else {
            Property newProperty = newShape.getProperty(key);
            newProperty.setSafe(object, value, oldShape, newShape);
        }
    }

    protected void objectRemoveProperty(DynamicObjectImpl object, Property property, ShapeImpl currentShape) {
        ShapeImpl oldShape = currentShape;
        ShapeImpl newShape = oldShape.removeProperty(property);
        this.reshapeAfterDelete(object, oldShape, newShape, ShapeImpl.findCommonAncestor(oldShape, newShape));
    }

    protected void reshapeAfterDelete(DynamicObjectImpl object, ShapeImpl oldShape, ShapeImpl newShape, ShapeImpl deletedParentShape) {
        if (oldShape.isShared()) {
            object.setShapeAndGrow(oldShape, newShape);
            return;
        }
        DynamicObject original = object.cloneWithShape(oldShape);
        object.setShapeAndResize(newShape);
        object.copyProperties(original, deletedParentShape);
    }

    protected ShapeImpl replaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty) {
        return this.directReplaceProperty(shape, oldProperty, newProperty);
    }

    protected ShapeImpl removeProperty(ShapeImpl shape, Property property) {
        boolean direct = shape.isShared();
        Transition.RemovePropertyTransition transition = new Transition.RemovePropertyTransition(property, direct);
        ShapeImpl cachedShape = shape.queryTransition(transition);
        if (cachedShape != null) {
            return this.ensureValid(cachedShape);
        }
        if (direct) {
            return LayoutStrategy.directRemoveProperty(shape, property, transition);
        }
        return this.indirectRemoveProperty(shape, property, transition);
    }

    private ShapeImpl indirectRemoveProperty(ShapeImpl shape, Property property, Transition.RemovePropertyTransition transition) {
        ShapeImpl owningShape = LayoutStrategy.getShapeFromProperty(shape, property.getKey());
        if (owningShape == null) {
            return null;
        }
        ArrayList<Transition> transitionList = new ArrayList<Transition>();
        ShapeImpl current = shape;
        while (current != owningShape) {
            Transition transitionFromParent = current.getTransitionFromParent();
            if (!(transitionFromParent instanceof Transition.DirectReplacePropertyTransition) || !((Transition.DirectReplacePropertyTransition)transitionFromParent).getPropertyBefore().getKey().equals(property.getKey())) {
                transitionList.add(transitionFromParent);
            }
            current = current.parent;
        }
        ShapeImpl newShape = owningShape.parent;
        ListIterator iterator = transitionList.listIterator(transitionList.size());
        while (iterator.hasPrevious()) {
            Transition previous = (Transition)iterator.previous();
            newShape = this.applyTransition(newShape, previous, true);
        }
        shape.addIndirectTransition(transition, newShape);
        return newShape;
    }

    private static ShapeImpl directRemoveProperty(ShapeImpl shape, Property property, Transition.RemovePropertyTransition transition) {
        PropertyMap newPropertyMap = shape.getPropertyMap().removeCopy(property);
        ShapeImpl newShape = shape.createShape(shape.getLayout(), shape.sharedData, shape, shape.objectType, newPropertyMap, transition, shape.allocator(), shape.flags);
        shape.addDirectTransition(transition, newShape);
        return newShape;
    }

    protected ShapeImpl directReplaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty) {
        return this.directReplaceProperty(shape, oldProperty, newProperty, true);
    }

    protected ShapeImpl directReplaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty, boolean ensureValid) {
        assert (oldProperty.getKey().equals(newProperty.getKey()));
        if (oldProperty.equals(newProperty)) {
            return shape;
        }
        shape.onPropertyTransition(oldProperty);
        Transition.DirectReplacePropertyTransition replacePropertyTransition = new Transition.DirectReplacePropertyTransition(oldProperty, newProperty);
        ShapeImpl cachedShape = shape.queryTransition(replacePropertyTransition);
        if (cachedShape != null) {
            return ensureValid ? this.ensureValid(cachedShape) : cachedShape;
        }
        PropertyMap newPropertyMap = shape.getPropertyMap().replaceCopy(oldProperty, newProperty);
        ShapeImpl.BaseAllocator allocator = shape.allocator().addLocation(newProperty.getLocation());
        ShapeImpl newShape = shape.createShape(shape.getLayout(), shape.sharedData, shape, shape.objectType, newPropertyMap, replacePropertyTransition, allocator, shape.flags);
        assert (newProperty.isSame(newShape.getProperty(newProperty.getKey()))) : newShape.getProperty(newProperty.getKey());
        shape.addDirectTransition(replacePropertyTransition, newShape);
        if (!shape.isValid()) {
            newShape.invalidateValidAssumption();
            return ensureValid ? this.ensureValid(newShape) : newShape;
        }
        return newShape;
    }

    protected ShapeImpl separateReplaceProperty(ShapeImpl shape, Property oldProperty, Property newProperty) {
        ShapeImpl newRoot;
        ShapeImpl newShape = newRoot = shape.createShape(shape.getLayout(), shape.sharedData, null, shape.objectType, PropertyMap.empty(), null, shape.getLayout().createAllocator(), shape.flags);
        boolean found = false;
        Iterator<Property> iterator = shape.getPropertyMap().orderedValueIterator();
        while (iterator.hasNext()) {
            Property p = iterator.next();
            if (!found && p.equals(oldProperty)) {
                p = newProperty;
                found = true;
            }
            newShape = newShape.addProperty(newProperty);
        }
        assert (found);
        assert (newShape.isValid());
        return newShape;
    }

    protected ShapeImpl createSeparateShape(ShapeImpl shape) {
        ShapeImpl newRoot;
        ShapeImpl newShape = newRoot = shape.createShape(shape.getLayout(), shape.sharedData, null, shape.objectType, PropertyMap.empty(), null, shape.getLayout().createAllocator(), shape.flags);
        Iterator<Property> iterator = shape.getPropertyMap().orderedValueIterator();
        while (iterator.hasNext()) {
            Property p = iterator.next();
            newShape = newShape.addProperty(p);
        }
        assert (newShape.isValid());
        return newShape;
    }

    protected ShapeImpl addProperty(ShapeImpl shape, Property property) {
        return this.addProperty(shape, property, true);
    }

    protected ShapeImpl addProperty(ShapeImpl shape, Property property, boolean ensureValid) {
        assert (!shape.hasProperty(property.getKey())) : "duplicate property " + property.getKey();
        Transition.AddPropertyTransition addTransition = new Transition.AddPropertyTransition(property);
        ShapeImpl cachedShape = shape.queryTransition(addTransition);
        if (cachedShape != null) {
            return ensureValid ? this.ensureValid(cachedShape) : cachedShape;
        }
        ShapeImpl oldShape = this.ensureSpace(shape, property.getLocation());
        ShapeImpl newShape = ShapeImpl.makeShapeWithAddedProperty(oldShape, addTransition);
        oldShape.addDirectTransition(addTransition, newShape);
        if (!oldShape.isValid()) {
            newShape.invalidateValidAssumption();
            return ensureValid ? this.ensureValid(newShape) : newShape;
        }
        return newShape;
    }

    protected ShapeImpl applyTransition(ShapeImpl shape, Transition transition, boolean append) {
        if (transition instanceof Transition.AddPropertyTransition) {
            ShapeImpl newShape;
            Property property = ((Transition.AddPropertyTransition)transition).getProperty();
            if (append) {
                newShape = shape.append(property);
            } else {
                shape.onPropertyTransition(property);
                newShape = this.addProperty(shape, property, false);
            }
            return newShape;
        }
        if (transition instanceof Transition.ObjectTypeTransition) {
            return shape.setDynamicType(((Transition.ObjectTypeTransition)transition).getObjectType());
        }
        if (transition instanceof Transition.ObjectFlagsTransition) {
            return shape.setFlags(((Transition.ObjectFlagsTransition)transition).getObjectFlags());
        }
        if (transition instanceof Transition.ReservePrimitiveArrayTransition) {
            return shape.reservePrimitiveExtensionArray();
        }
        if (transition instanceof Transition.DirectReplacePropertyTransition) {
            Property oldProperty = ((Transition.DirectReplacePropertyTransition)transition).getPropertyBefore();
            Property newProperty = ((Transition.DirectReplacePropertyTransition)transition).getPropertyAfter();
            if (append) {
                boolean sameLocation = oldProperty.getLocation().equals(newProperty.getLocation());
                oldProperty = shape.getProperty(oldProperty.getKey());
                Location newLocation = sameLocation ? oldProperty.getLocation() : shape.allocator().moveLocation(newProperty.getLocation());
                newProperty = newProperty.relocate(newLocation);
            }
            return this.directReplaceProperty(shape, oldProperty, newProperty, append);
        }
        throw new UnsupportedOperationException(transition.getClass().getName());
    }

    protected ShapeImpl addPrimitiveExtensionArray(ShapeImpl shape) {
        LayoutImpl layout = shape.getLayout();
        assert (layout.hasPrimitiveExtensionArray() && !shape.hasPrimitiveArray());
        Transition.ReservePrimitiveArrayTransition transition = new Transition.ReservePrimitiveArrayTransition();
        ShapeImpl cachedShape = shape.queryTransition(transition);
        if (cachedShape != null) {
            return layout.getStrategy().ensureValid(cachedShape);
        }
        ShapeImpl oldShape = this.ensureSpace(shape, layout.getPrimitiveArrayLocation());
        ShapeImpl newShape = ShapeImpl.makeShapeWithPrimitiveExtensionArray(oldShape, transition);
        oldShape.addDirectTransition(transition, newShape);
        return newShape;
    }

    protected static ShapeImpl getShapeFromProperty(ShapeImpl shape, Object propertyName) {
        ShapeImpl root = shape.getRoot();
        for (ShapeImpl current = shape; current != root; current = current.getParent()) {
            if (!(current.getTransitionFromParent() instanceof Transition.AddPropertyTransition) || !((Transition.AddPropertyTransition)current.getTransitionFromParent()).getProperty().getKey().equals(propertyName)) continue;
            return current;
        }
        return null;
    }

    @Deprecated
    protected static ShapeImpl getShapeFromProperty(ShapeImpl shape, Property prop) {
        ShapeImpl current = shape;
        ShapeImpl root = shape.getRoot();
        while (current != root) {
            if (current.getTransitionFromParent() instanceof Transition.AddPropertyTransition && ((Transition.AddPropertyTransition)current.getTransitionFromParent()).getProperty().equals(prop)) {
                return current;
            }
            current = current.parent;
        }
        return null;
    }
}

