/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.messaging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class MaltegoMessageInputStream
extends InputStream {
    private static final String SIGNATURE = "<MaltegoMessage>";
    private static final int VALID_UNKNOWN = 0;
    private static final int VALID_YES = 1;
    private static final int XML_HEADER_MAX = 50;
    private static final int VALIDATE_SIZE = 50 + "<MaltegoMessage>".length();
    private int _valid = 0;
    private InputStream _delegate;
    private ByteArrayOutputStream _os = new ByteArrayOutputStream();

    public MaltegoMessageInputStream(InputStream is) {
        this._delegate = is;
    }

    @Override
    public int read() throws IOException {
        int c = this._delegate.read();
        if (this._valid == 0) {
            if (c != -1) {
                this._os.write(c);
                this.checkValid();
            } else if (this._os.size() == 0 || this._os.toString().trim().isEmpty()) {
                throw new IOException("The transform response was empty.");
            }
        }
        return c;
    }

    private void checkValid() throws IOException {
        block4: {
            if (this._os.size() >= VALIDATE_SIZE) {
                try {
                    String start = this._os.toString("UTF-8").replaceAll("\\s", "");
                    start = start.replaceAll("<\\?[^>]+$", "");
                    start = start.replaceAll("<!--[^>]+$", "");
                    start = start.replaceAll("<\\?[^>]+?\\?>", "");
                    start = start.replaceAll("<!--[^>]+?-->", "");
                    if (start.length() < SIGNATURE.length()) break block4;
                    if (start.startsWith(SIGNATURE)) {
                        this.setValid();
                        break block4;
                    }
                    throw new IOException("Transform response does not start with \"<MaltegoMessage>\" but with: " + start);
                }
                catch (UnsupportedEncodingException ex) {
                    this.setValid();
                }
            }
        }
    }

    private void setValid() {
        this._valid = 1;
        this._os = null;
    }
}

