/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.collab.ui.PortInfo;
import com.paterva.maltego.collab.ui.PortType;
import com.paterva.maltego.licensing.UserInfo;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class PreviousSessionInfo {
    private static final boolean DEFUALT_USE_DEF_SERVER = true;
    private static final boolean DEFUALT_AUTO_REGISTER = true;
    private static PreviousSessionInfo _instance;
    private List<String> _sessions;
    private List<String> _keys;
    private List<String> _aliases;
    private List<String> _privatePatervaServers;
    private List<String> _servers;
    private List<String> _users;
    private Map<String, SessionNameInfo> _sessionInfos;
    private Map<String, ServerInfo> _serverInfos;
    private Map<ServerAndUser, String> _passwords;
    private boolean _savePassword = false;
    private boolean _debug = false;
    private PreviousSessionInfoSerializer _serializer = new PreviousSessionInfoSerializer();
    private int _keyGenPressCount = 0;
    private SecureRandom _secureRandom = new SecureRandom();
    private MessageDigest _md;
    private boolean _encryption256 = false;
    private boolean _saveKey = false;

    private PreviousSessionInfo() {
        this.load();
    }

    public static synchronized PreviousSessionInfo instance() {
        if (_instance == null) {
            _instance = new PreviousSessionInfo();
        }
        return _instance;
    }

    public boolean use256Encryption() {
        return this._encryption256;
    }

    public List<String> getSessionNames() {
        return Collections.unmodifiableList(this._sessions);
    }

    public List<String> getSecurityKeys() {
        return Collections.unmodifiableList(this._keys);
    }

    public List<String> getAliases() {
        return Collections.unmodifiableList(this._aliases);
    }

    public List<String> getServerDnsNames() {
        return Collections.unmodifiableList(this._servers);
    }

    public List<String> getPrivatePatervaServerDnsNames() {
        return Collections.unmodifiableList(this._privatePatervaServers);
    }

    public PortInfo getPortInfo(String server) {
        ServerInfo serverInfo = this._serverInfos.get(server);
        return serverInfo != null ? serverInfo.getPortInfo() : new PortInfo();
    }

    public boolean isAttemptAutoRegister(String server) {
        ServerInfo serverInfo = this._serverInfos.get(server);
        return serverInfo != null ? serverInfo.isAutoRegister() : true;
    }

    public List<String> getUsers() {
        return Collections.unmodifiableList(this._users);
    }

    public String getPassword(String server, String user) {
        ServerAndUser serverAndUser = new ServerAndUser(server, user);
        String password = this._passwords.get(serverAndUser);
        return password != null ? password : "";
    }

    public String getSecurityKey(String sessionName) {
        SessionNameInfo sessionInfo = this._sessionInfos.get(sessionName);
        String key = sessionInfo != null ? sessionInfo.getKey() : "";
        return this.isSaveKey() ? key : "";
    }

    public String getAlias(String sessionName) {
        SessionNameInfo sessionInfo = this._sessionInfos.get(sessionName);
        return sessionInfo != null ? sessionInfo.getAlias() : "";
    }

    public boolean isUseDefaultServer(String sessionName) {
        SessionNameInfo sessionInfo = this._sessionInfos.get(sessionName);
        return sessionInfo != null ? sessionInfo.isUseDefaultServer() : true;
    }

    public boolean isUsePrivatePatervaServer(String sessionName) {
        SessionNameInfo sessionInfo = this._sessionInfos.get(sessionName);
        return sessionInfo != null ? sessionInfo.isUsePrivatePatervaServer() : false;
    }

    public String getPrivatePatervaServerDnsName(String sessionName) {
        SessionNameInfo sessionInfo = this._sessionInfos.get(sessionName);
        return sessionInfo != null ? sessionInfo.getPrivatePatervaServerDnsName() : "";
    }

    public String getServerDnsName(String sessionName) {
        SessionNameInfo sessionInfo = this._sessionInfos.get(sessionName);
        return sessionInfo != null ? sessionInfo.getServerDnsName() : "";
    }

    public String getUser(String server) {
        ServerInfo serverInfo = this._serverInfos.get(server);
        return serverInfo != null ? serverInfo.getUser() : "";
    }

    public boolean isSavePassword() {
        return this._savePassword;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public boolean isSaveKey() {
        return this._saveKey;
    }

    public String generateKey() {
        ++this._keyGenPressCount;
        try {
            if (this._md == null) {
                this._md = MessageDigest.getInstance("SHA-256");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
        byte[] randomBytes = new byte[32];
        this._secureRandom.nextBytes(randomBytes);
        int randIters = (this._secureRandom.nextInt() & 0xFF) + this._keyGenPressCount;
        for (int ii = 0; ii < randIters; ++ii) {
            this._md.update(randomBytes);
        }
        randomBytes = this._md.digest();
        String keyTemp = "";
        for (int ii = 0; ii < 32; ++ii) {
            long tempLong = this._secureRandom.nextLong();
            for (int jj = 0; jj < 8; ++jj) {
                tempLong ^= (long)randomBytes[ii] << jj * 8;
            }
            keyTemp = keyTemp + StringUtilities.toStringUnsignedLong((long)tempLong, (int)36).substring(1);
        }
        String key = keyTemp.substring(0, 10 * (this._keyGenPressCount % 3) + 10);
        return key;
    }

    private void store() {
        this._serializer.store();
    }

    private void load() {
        this._serializer.load();
    }

    public void add(String session, String key, String alias, boolean useDefaultServer, boolean usePrivatePatervaServer, String privatePatervaServer, String server, PortInfo portInfo, boolean autoRegister, String user, String password, boolean savePassword, boolean debug, boolean use256Encryption, boolean saveKey) {
        int limit = 10;
        key = saveKey ? key : "";
        this.addFirst(this._sessions, session, 10);
        this.addFirst(this._keys, key, 10);
        this.addFirst(this._aliases, alias, 10);
        this.addFirst(this._privatePatervaServers, privatePatervaServer, 10);
        this.addFirst(this._servers, server, 20);
        this.addFirst(this._users, user, 10);
        this._sessionInfos.put(session, new SessionNameInfo(key, alias, useDefaultServer, usePrivatePatervaServer, privatePatervaServer, server));
        this._serverInfos.put(server, new ServerInfo(portInfo, autoRegister, user));
        ServerAndUser serverAndUser = new ServerAndUser(server, user);
        if (!password.isEmpty() && savePassword) {
            this._passwords.put(serverAndUser, password);
        } else {
            this._passwords.remove(serverAndUser);
        }
        this._savePassword = savePassword;
        this._debug = debug;
        this._encryption256 = use256Encryption;
        this._saveKey = saveKey;
        this.store();
    }

    private void addFirst(List<String> list, String value, int limit) {
        list.remove(value);
        list.add(0, value);
        while (list.size() > limit) {
            list.remove(limit);
        }
    }

    private class PreviousSessionInfoSerializer {
        private static final String PREF_SESSIONS = "collab.sessions";
        private static final String PREF_KEYS = "collab.keys";
        private static final String PREF_ALIASES = "collab.aliases";
        private static final String PREF_PRIVATE_PATERVA_SERVERS = "collab.privatePatervaServers";
        private static final String PREF_SERVERS = "collab.servers";
        private static final String PREF_USERS = "collab.users";
        private static final String PREF_SESSIONS_INFO = "collab.sessionsInfo";
        private static final String PREF_SERVER_INFO = "collab.serverInfo";
        private static final String PREF_PASSWORDS = "collab.pass";
        private static final String PREF_SAVE_PASSWORD = "collab.savePass";
        private static final String PREF_DEBUG = "collab.debug";
        private static final String PREF_SAVE_KEY = "collab.saveKey";
        private static final String PREF_ENCRYPTION = "collab.encryption256";
        private Preferences _prefs = NbPreferences.forModule(this.getClass());

        private PreviousSessionInfoSerializer() {
        }

        public void store() {
            this.store(PREF_SESSIONS, PreviousSessionInfo.this._sessions);
            if (!PreviousSessionInfo.this._saveKey) {
                ArrayList<String> keys = new ArrayList<String>(PreviousSessionInfo.this._keys.size());
                for (int i = 0; i < PreviousSessionInfo.this._keys.size(); ++i) {
                    keys.add("");
                }
                PreviousSessionInfo.this._keys = keys;
            }
            this.store(PREF_KEYS, PreviousSessionInfo.this._keys);
            this.store(PREF_ALIASES, PreviousSessionInfo.this._aliases);
            this.store(PREF_PRIVATE_PATERVA_SERVERS, PreviousSessionInfo.this._privatePatervaServers);
            this.store(PREF_SERVERS, PreviousSessionInfo.this._servers);
            this.store(PREF_USERS, PreviousSessionInfo.this._users);
            this.storeSessioNameInfos();
            this.storeServerInfos();
            this.storePasswords();
            this._prefs.putBoolean(PREF_DEBUG, PreviousSessionInfo.this._debug);
            this._prefs.putBoolean(PREF_ENCRYPTION, PreviousSessionInfo.this._encryption256);
            this._prefs.putBoolean(PREF_SAVE_KEY, PreviousSessionInfo.this._saveKey);
        }

        public void load() {
            PreviousSessionInfo.this._sessions = this.load(PREF_SESSIONS);
            if (!PreviousSessionInfo.this._sessions.isEmpty()) {
                PreviousSessionInfo.this._keys = this.load(PREF_KEYS);
                PreviousSessionInfo.this._aliases = this.load(PREF_ALIASES);
                PreviousSessionInfo.this._privatePatervaServers = this.load(PREF_PRIVATE_PATERVA_SERVERS);
                PreviousSessionInfo.this._servers = this.load(PREF_SERVERS);
                PreviousSessionInfo.this._users = this.load(PREF_USERS);
                this.loadSessionNameInfos();
                this.loadServerInfos();
                this.loadPasswords();
                PreviousSessionInfo.this._debug = this._prefs.getBoolean(PREF_DEBUG, false);
                PreviousSessionInfo.this._encryption256 = this._prefs.getBoolean(PREF_ENCRYPTION, false);
                PreviousSessionInfo.this._saveKey = this._prefs.getBoolean(PREF_SAVE_KEY, false);
            } else {
                this.generateDefaults();
            }
        }

        private void generateDefaults() {
            String[] servers;
            PreviousSessionInfo.this._sessions = new ArrayList();
            PreviousSessionInfo.this._keys = new ArrayList();
            PreviousSessionInfo.this._aliases = new ArrayList();
            PreviousSessionInfo.this._privatePatervaServers = new ArrayList();
            PreviousSessionInfo.this._servers = new ArrayList();
            PreviousSessionInfo.this._users = new ArrayList();
            PreviousSessionInfo.this._sessionInfos = new HashMap();
            PreviousSessionInfo.this._serverInfos = new HashMap();
            PreviousSessionInfo.this._passwords = new HashMap();
            UserInfo userInfo = new UserInfo();
            String alias = userInfo.getAlias();
            alias = StringUtilities.keepOnlyAlphaNumeric((String)alias);
            long randomLong = UUID.randomUUID().getLeastSignificantBits() & 0xFFFFFL;
            String session = alias + StringUtilities.toStringUnsignedLong((long)randomLong, (int)36).toUpperCase();
            PreviousSessionInfo.this._sessions.add(session);
            String key = PreviousSessionInfo.this.generateKey();
            PreviousSessionInfo.this._keys.add(key);
            PreviousSessionInfo.this._aliases.add(alias);
            PreviousSessionInfo.this._sessionInfos.put(session, new SessionNameInfo(key, alias, true, false, "", ""));
            for (String server : servers = new String[]{"jabber.de", "jabber.iitsp.com", "comm.unicate.me", "forumanalogue.fr", "jabber.se", "rkquery.de"}) {
                PreviousSessionInfo.this._servers.add(server);
                PreviousSessionInfo.this._serverInfos.put(server, new ServerInfo(new PortInfo(), true, ""));
            }
            PreviousSessionInfo.this._encryption256 = false;
            this.store();
        }

        private void store(String preferenceKey, List<String> values) {
            this.store(preferenceKey, StringUtilities.listToString(values));
        }

        private void store(String preferenceKey, String value) {
            try {
                this._prefs.putByteArray(preferenceKey, value.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }

        private List<String> load(String preferenceKey) {
            return StringUtilities.listFromString((String)this.loadStr(preferenceKey));
        }

        private String loadStr(String preferenceKey) {
            byte[] bytes = this._prefs.getByteArray(preferenceKey, new byte[0]);
            String value = "";
            try {
                value = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
            return value;
        }

        private void storeSessioNameInfos() {
            ArrayList<String> sessionNameInfos = new ArrayList<String>();
            for (String session : PreviousSessionInfo.this._sessions) {
                sessionNameInfos.add(this.sessionNameInfoToString(session));
            }
            this.store(PREF_SESSIONS_INFO, StringUtilities.listToString(sessionNameInfos));
        }

        private String sessionNameInfoToString(String sessionName) {
            StringBuilder sb = new StringBuilder();
            SessionNameInfo sessionNameInfo = (SessionNameInfo)PreviousSessionInfo.this._sessionInfos.get(sessionName);
            sb.append(PreviousSessionInfo.this._keys.indexOf(sessionNameInfo.getKey())).append(",");
            sb.append(PreviousSessionInfo.this._aliases.indexOf(sessionNameInfo.getAlias())).append(",");
            sb.append(sessionNameInfo.isUseDefaultServer() ? "1" : "0").append(",");
            sb.append(PreviousSessionInfo.this._servers.indexOf(sessionNameInfo.getServerDnsName())).append(",");
            sb.append(sessionNameInfo.isUsePrivatePatervaServer() ? "1" : "0").append(",");
            sb.append(PreviousSessionInfo.this._privatePatervaServers.indexOf(sessionNameInfo.getPrivatePatervaServerDnsName()));
            return sb.toString();
        }

        private void storeServerInfos() {
            ArrayList<String> serverInfos = new ArrayList<String>();
            for (String server : PreviousSessionInfo.this._servers) {
                serverInfos.add(this.serverInfoToString(server));
            }
            this.store(PREF_SERVER_INFO, StringUtilities.listToString(serverInfos));
        }

        private String serverInfoToString(String server) {
            StringBuilder sb = new StringBuilder();
            ServerInfo serverInfo = (ServerInfo)PreviousSessionInfo.this._serverInfos.get(server);
            PortInfo portInfo = serverInfo.getPortInfo();
            sb.append(this.portToString(portInfo, PortType.NORMAL)).append(",");
            sb.append(serverInfo.isAutoRegister() ? "1" : "0").append(",");
            sb.append(PreviousSessionInfo.this._users.indexOf(serverInfo.getUser())).append(",");
            sb.append(this.portToString(portInfo, PortType.SSL)).append(",");
            sb.append(this.portToString(portInfo, PortType.HTTP)).append(",");
            sb.append(this.portToString(portInfo, PortType.HTTPS)).append(",");
            sb.append(portInfo.getSelectedType().name());
            return sb.toString();
        }

        private String portToString(PortInfo info, PortType type) {
            int defaultPort = type.getDefaultPort();
            int port = info.getPort(type);
            return port != defaultPort ? Integer.toString(port) : "";
        }

        private void storePasswords() {
            ArrayList<String> passwordInfos = new ArrayList<String>();
            for (String server : PreviousSessionInfo.this._servers) {
                for (String user : PreviousSessionInfo.this._users) {
                    String password = (String)PreviousSessionInfo.this._passwords.get(new ServerAndUser(server, user));
                    if (password == null) continue;
                    try {
                        passwordInfos.add(this.passwordInfoToString(server, user, password));
                    }
                    catch (UnsupportedEncodingException ex) {
                        NormalException.showStackTrace((Throwable)ex);
                    }
                    catch (GeneralSecurityException ex) {
                        NormalException.showStackTrace((Throwable)ex);
                    }
                }
            }
            this.store(PREF_PASSWORDS, StringUtilities.listToString(passwordInfos));
            this._prefs.putBoolean(PREF_SAVE_PASSWORD, PreviousSessionInfo.this._savePassword);
        }

        private String passwordInfoToString(String server, String user, String password) throws UnsupportedEncodingException, GeneralSecurityException {
            StringBuilder sb = new StringBuilder();
            sb.append(PreviousSessionInfo.this._servers.indexOf(server)).append(",");
            sb.append(PreviousSessionInfo.this._users.indexOf(user)).append(",");
            sb.append(StringUtilities.basicEncrypt((String)password));
            return sb.toString();
        }

        private void loadSessionNameInfos() {
            PreviousSessionInfo.this._sessionInfos = new HashMap();
            List<String> sessionNameInfos = this.load(PREF_SESSIONS_INFO);
            int count = 0;
            for (String sessionNameInfo : sessionNameInfos) {
                try {
                    String[] tokens = sessionNameInfo.split(",");
                    if (tokens.length >= 4) {
                        String session = (String)PreviousSessionInfo.this._sessions.get(count);
                        int keyIndex = Integer.parseInt(tokens[0]);
                        String key = keyIndex >= 0 ? (String)PreviousSessionInfo.this._keys.get(keyIndex) : "";
                        int aliasIndex = Integer.parseInt(tokens[1]);
                        String alias = aliasIndex >= 0 ? (String)PreviousSessionInfo.this._aliases.get(aliasIndex) : "";
                        boolean useDefaultServer = !"0".equals(tokens[2]);
                        int serverIndex = Integer.parseInt(tokens[3]);
                        String server = serverIndex >= 0 ? (String)PreviousSessionInfo.this._servers.get(serverIndex) : "";
                        String privatePatervaServer = "";
                        boolean usePrivatePatervaServer = false;
                        if (tokens.length >= 6) {
                            usePrivatePatervaServer = !"0".equals(tokens[4]);
                            int privatePatervaServerIndex = Integer.parseInt(tokens[5]);
                            privatePatervaServer = privatePatervaServerIndex >= 0 ? (String)PreviousSessionInfo.this._privatePatervaServers.get(privatePatervaServerIndex) : "";
                        }
                        PreviousSessionInfo.this._sessionInfos.put(session, new SessionNameInfo(key, alias, useDefaultServer, usePrivatePatervaServer, privatePatervaServer, server));
                    }
                }
                catch (Exception ex) {
                    NormalException.showStackTrace((Throwable)ex);
                }
                ++count;
            }
        }

        private void loadServerInfos() {
            PreviousSessionInfo.this._serverInfos = new HashMap();
            List<String> serverInfos = this.load(PREF_SERVER_INFO);
            int count = 0;
            for (String serverInfo : serverInfos) {
                block10: {
                    try {
                        String user;
                        String[] tokens = serverInfo.split(",", -1);
                        if (tokens.length < 3) break block10;
                        String server = (String)PreviousSessionInfo.this._servers.get(count);
                        PortInfo portInfo = new PortInfo();
                        if (!tokens[0].trim().isEmpty()) {
                            portInfo.setPort(PortType.NORMAL, Integer.parseInt(tokens[0]));
                        }
                        boolean autoRegister = !"0".equals(tokens[1]);
                        int userIndex = Integer.parseInt(tokens[2]);
                        String string = user = userIndex >= 0 ? (String)PreviousSessionInfo.this._users.get(userIndex) : "";
                        if (tokens.length >= 7) {
                            PortType portType;
                            if (!tokens[3].trim().isEmpty()) {
                                portInfo.setPort(PortType.SSL, Integer.parseInt(tokens[3]));
                            }
                            if (!tokens[4].trim().isEmpty()) {
                                portInfo.setPort(PortType.HTTP, Integer.parseInt(tokens[4]));
                            }
                            if (!tokens[5].trim().isEmpty()) {
                                portInfo.setPort(PortType.HTTPS, Integer.parseInt(tokens[5]));
                            }
                            try {
                                portType = PortType.valueOf(tokens[6]);
                            }
                            catch (IllegalArgumentException ex) {
                                portType = PortType.AUTO;
                            }
                            portInfo.setSelectedType(portType);
                        }
                        PreviousSessionInfo.this._serverInfos.put(server, new ServerInfo(portInfo, autoRegister, user));
                    }
                    catch (Exception ex) {
                        NormalException.showStackTrace((Throwable)ex);
                    }
                }
                ++count;
            }
        }

        private void loadPasswords() {
            PreviousSessionInfo.this._passwords = new HashMap();
            List<String> passwordInfos = this.load(PREF_PASSWORDS);
            for (String passwordInfo : passwordInfos) {
                try {
                    String[] tokens = passwordInfo.split(",");
                    if (tokens.length != 3) continue;
                    int serverIndex = Integer.parseInt(tokens[0]);
                    int userIndex = Integer.parseInt(tokens[1]);
                    if (serverIndex < 0 || userIndex < 0) continue;
                    String server = (String)PreviousSessionInfo.this._servers.get(serverIndex);
                    String user = (String)PreviousSessionInfo.this._users.get(userIndex);
                    String password = StringUtilities.basicDecrypt((String)tokens[2]);
                    PreviousSessionInfo.this._passwords.put(new ServerAndUser(server, user), password);
                }
                catch (Exception ex) {
                    NormalException.showStackTrace((Throwable)ex);
                }
            }
            PreviousSessionInfo.this._savePassword = this._prefs.getBoolean(PREF_SAVE_PASSWORD, false);
        }
    }

    private static class ServerAndUser {
        private String _server;
        private String _user;

        public ServerAndUser(String server, String user) {
            this._server = server;
            this._user = user;
        }

        public String getServer() {
            return this._server;
        }

        public void setServer(String server) {
            this._server = server;
        }

        public String getUser() {
            return this._user;
        }

        public void setUser(String user) {
            this._user = user;
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + (this._server != null ? this._server.hashCode() : 0);
            hash = 59 * hash + (this._user != null ? this._user.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerAndUser other = (ServerAndUser)obj;
            if (this._server == null ? other._server != null : !this._server.equals(other._server)) {
                return false;
            }
            return !(this._user == null ? other._user != null : !this._user.equals(other._user));
        }
    }

    private static class ServerInfo {
        private PortInfo _portInfo;
        private boolean _autoRegister;
        private String _user;

        public ServerInfo(PortInfo portInfo, boolean autoRegister, String user) {
            this._portInfo = portInfo;
            this._autoRegister = autoRegister;
            this._user = user;
        }

        public PortInfo getPortInfo() {
            return this._portInfo;
        }

        public void setPortInfo(PortInfo portInfo) {
            this._portInfo = portInfo;
        }

        public boolean isAutoRegister() {
            return this._autoRegister;
        }

        public void setAutoRegister(boolean autoRegister) {
            this._autoRegister = autoRegister;
        }

        public String getUser() {
            return this._user;
        }

        public void setUser(String user) {
            this._user = user;
        }
    }

    private static class SessionNameInfo {
        private String _key;
        private String _alias;
        private boolean _useDefaultServer;
        private boolean _usePrivatePatervaServer;
        private String _privatePatervaServer;
        private String _server;

        public SessionNameInfo(String key, String alias, boolean useDefaultServer, boolean usePrivatePatervaServer, String privatePatervaServer, String server) {
            this._key = key;
            this._alias = alias;
            this._useDefaultServer = useDefaultServer;
            this._usePrivatePatervaServer = usePrivatePatervaServer;
            this._privatePatervaServer = privatePatervaServer;
            this._server = server;
        }

        public String getKey() {
            return this._key;
        }

        public void setKey(String key) {
            this._key = key;
        }

        public String getAlias() {
            return this._alias;
        }

        public void setAlias(String alias) {
            this._alias = alias;
        }

        public boolean isUseDefaultServer() {
            return this._useDefaultServer;
        }

        public void setUseDefaultServer(boolean useDefaultServer) {
            this._useDefaultServer = useDefaultServer;
        }

        public boolean isUsePrivatePatervaServer() {
            return this._usePrivatePatervaServer;
        }

        public void setUsePrivatePatervaServer(boolean usePrivatePatervaServer) {
            this._usePrivatePatervaServer = usePrivatePatervaServer;
        }

        public String getPrivatePatervaServerDnsName() {
            return this._privatePatervaServer;
        }

        public void setPrivatePatervaServerDnsName(String privatePatervaserverDnsName) {
            this._privatePatervaServer = privatePatervaserverDnsName;
        }

        public String getServerDnsName() {
            return this._server;
        }

        public void setServerDnsName(String serverDnsName) {
            this._server = serverDnsName;
        }
    }
}

