/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.privacymode;

import com.paterva.maltego.util.Args;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;

public enum PrivacyMode {
    NORMAL("Normal", "Your Maltego Desktop can fetch data directly from the internet.", "Use this mode for richest Maltego experience. Your Maltego Desktop is allowed to fetch some data directly from the internet. Examples include fetching of entity images from URLs and Favicons for websites overlays."),
    STEALTH("Stealth", "Your Maltego Desktop will never fetch data directly from the internet. Your IP will not be exposed to potential targets.", "Use this mode if you are an investigator and it is important that no internet traffic originates from your computer\u2019s IP. Your Maltego Desktop will not fetch any data directly from the internet. Downloading of entity images and image overlays will be blocked. Note that transforms might still make direct connections to the target from the transform server or from your computer (in case of local transforms).");

    public static final PrivacyMode DEFAULT_MODE;
    private static final Logger LOG;
    private final String _displayName;
    private final String _shortDescription;
    private final String _longDescription;

    private PrivacyMode(String displayName, String shortDescription, String longDescription) {
        Args.notNullOrBlank((String)displayName, (String)"displayName");
        Args.notNullOrBlank((String)shortDescription, (String)"shortDescription");
        Args.notNullOrBlank((String)longDescription, (String)"longDescription");
        this._displayName = displayName;
        this._shortDescription = shortDescription;
        this._longDescription = longDescription;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getShortDescription() {
        return this._shortDescription;
    }

    public String getLongDescription() {
        return this._longDescription;
    }

    public Optional<ImageIcon> getIcon() {
        String iconPath = "com/paterva/maltego/util/ui/privacymode/" + this.name() + ".png";
        ImageIcon icon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)true);
        if (icon == null) {
            LOG.log(Level.SEVERE, "Privacy Mode icon not found: {0}", icon);
        }
        return Optional.ofNullable(icon);
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        DEFAULT_MODE = NORMAL;
        LOG = Logger.getLogger(PrivacyMode.class.getName());
    }
}

