/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.xlightweb.AbstractBodyParser;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyType;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.HeaderlineParser;
import org.xlightweb.IHttpHeader;
import org.xlightweb.ProtocolException;

final class FullMessageChunkedBodyParser
extends AbstractBodyParser
implements HeaderlineParser.IHeaderSink {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte SPACE = 32;
    private static final byte HTAB = 9;
    private static final int STATE_READ_LENGTH_FIELD = 0;
    private static final int STATE_READ_CONTENT = 1;
    private static final int STATE_READ_CONTENT_CRLF = 2;
    private static final int STATE_READ_TRAILER = 3;
    private static final int STATE_COMPLETE = 999;
    private int state = 0;
    private final StringBuilder stringBuilder = new StringBuilder(8);
    private int remainingDataToRead;
    private final IHttpHeader header;
    private HeaderlineParser headerlineParser;

    public FullMessageChunkedBodyParser(AbstractHttpConnection httpConnection, IHttpHeader header) throws IOException {
        super(BodyType.FULL_MESSAGE_CHUNKED, httpConnection, header);
        this.header = header;
    }

    void doParse(ComposedByteBuffer rawData) throws IOException {
        while (rawData.available() > 0) {
            block0 : switch (this.state) {
                case 0: {
                    byte b = rawData.getByte();
                    switch (b) {
                        case 13: {
                            break block0;
                        }
                        case 32: {
                            break block0;
                        }
                        case 9: {
                            break block0;
                        }
                        case 10: {
                            this.remainingDataToRead = this.parseLengtField(this.stringBuilder.toString());
                            this.stringBuilder.setLength(0);
                            if (this.remainingDataToRead > 0) {
                                this.state = 1;
                                break block0;
                            }
                            this.state = 3;
                            this.headerlineParser = HeaderlineParser.newInstance();
                            break block0;
                        }
                    }
                    this.stringBuilder.append((char)b);
                    break;
                }
                case 1: {
                    int size = rawData.remaining();
                    if (size >= this.remainingDataToRead) {
                        size = this.remainingDataToRead;
                        this.remainingDataToRead = 0;
                    } else {
                        this.remainingDataToRead -= size;
                    }
                    rawData.readByteBufferByLength(size, this);
                    if (this.remainingDataToRead != 0) break;
                    this.state = 2;
                    break;
                }
                case 2: {
                    byte b = rawData.getByte();
                    switch (b) {
                        case 13: {
                            break block0;
                        }
                        case 10: {
                            this.state = 0;
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    boolean isRead = this.headerlineParser.parse(rawData, this);
                    if (!isRead) break;
                    this.state = 999;
                    this.setComplete();
                    HeaderlineParser.recycleInstance(this.headerlineParser);
                    return;
                }
            }
        }
    }

    void onException(IOException ioe, ComposedByteBuffer rawData) {
        if (!this.isComplete()) {
            String msg = "error occured by parsing full message chunked body (remaing size of current chunk: " + this.remainingDataToRead + ") ";
            msg = ioe instanceof ClosedChannelException ? msg + "connection disconnected (by peer?)" : msg + ioe.toString();
            this.register(new ProtocolException(msg));
        }
    }

    void onDisconnect() {
        if (!this.isComplete()) {
            this.setPersistent(false);
        }
        super.onDisconnect();
    }

    public void addHeader(String headername, String headervalue) {
        this.header.addHeader(headername, headervalue);
    }

    private int parseLengtField(String lengthField) throws IOException {
        try {
            return Integer.parseInt(lengthField, 16);
        }
        catch (NumberFormatException nfe) {
            if (lengthField.indexOf(";") != -1) {
                String length = lengthField.substring(0, lengthField.indexOf(";"));
                return Integer.parseInt(length, 16);
            }
            throw new IOException("[" + this.getConnectionId() + "] http protocol error. length field expected. Got " + lengthField);
        }
    }
}

