/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.server.HttpProtocolAdapter;
import org.xlightweb.server.ISessionManager;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServer
extends Server {
    public HttpServer(IHttpRequestHandler requestHandler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(0), new HashMap<String, Object>(), requestHandler, null, false);
    }

    public HttpServer(IHttpRequestHandler handler, Map<String, Object> options) throws UnknownHostException, IOException {
        this(new InetSocketAddress(0), options, handler, null, false);
    }

    public HttpServer(int port, IHttpRequestHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), new HashMap<String, Object>(), handler, null, false);
    }

    public HttpServer(int port, IHttpRequestHandler handler, Map<String, Object> options) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), options, handler, null, false);
    }

    public HttpServer(InetAddress address, int port, IHttpRequestHandler handler) throws UnknownHostException, IOException {
        this(address, port, handler, new HashMap<String, Object>(), null, false);
    }

    public HttpServer(String ipAddress, int port, IHttpRequestHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, handler, new HashMap<String, Object>(), null, false);
    }

    public HttpServer(String ipAddress, int port, IHttpRequestHandler handler, Map<String, Object> options) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, handler, options, null, false);
    }

    public HttpServer(int port, IHttpRequestHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), new HashMap<String, Object>(), handler, sslContext, sslOn);
    }

    public HttpServer(int port, IHttpRequestHandler handler, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), options, handler, sslContext, sslOn);
    }

    public HttpServer(String ipAddress, int port, IHttpRequestHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, handler, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public HttpServer(String ipAddress, int port, IHttpRequestHandler handler, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, handler, options, sslContext, sslOn);
    }

    public HttpServer(InetAddress address, int port, IHttpRequestHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(address, port, handler, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public HttpServer(InetAddress address, int port, IHttpRequestHandler handler, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, handler, sslContext, sslOn);
    }

    private HttpServer(InetSocketAddress address, Map<String, Object> options, IHttpRequestHandler requestHandler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        super(address, options, (IHandler)new HttpProtocolAdapter(requestHandler), sslContext, sslOn, 0);
    }

    public void addConnectionHandler(IHttpConnectionHandler connectionHandler) {
        ((HttpProtocolAdapter)super.getHandler()).addConnectionHandler(connectionHandler);
    }

    public String getImplementationVersion() {
        return HttpUtils.getImplementationVersion();
    }

    public String getImplementationDate() {
        return HttpUtils.getImplementationDate();
    }

    String getXSocketImplementationVersion() {
        return ConnectionUtils.getImplementationVersion();
    }

    String getXSocketImplementationDate() {
        return ConnectionUtils.getImplementationDate();
    }

    public void setRequestTimeoutMillis(long receivetimeout) {
        ((HttpProtocolAdapter)super.getHandler()).setRequestTimeoutMillis(receivetimeout);
    }

    public long getRequestTimeoutMillis() {
        return ((HttpProtocolAdapter)super.getHandler()).getRequestTimeoutMillis();
    }

    public final void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        ((HttpProtocolAdapter)super.getHandler()).setBodyDataReceiveTimeoutMillis(bodyDataReceiveTimeoutMillis);
    }

    public void setSessionMaxInactiveIntervalSec(int sessionMaxInactiveIntervalSec) {
        ((HttpProtocolAdapter)super.getHandler()).setSessionMaxInactiveIntervalSec(sessionMaxInactiveIntervalSec);
    }

    public int getSessionMaxInactiveIntervalSec() {
        return ((HttpProtocolAdapter)super.getHandler()).getSessionMaxInactiveIntervalSec();
    }

    public void setCloseOnSendingError(boolean isCloseOnSendingError) {
        ((HttpProtocolAdapter)super.getHandler()).setCloseOnSendingError(isCloseOnSendingError);
    }

    public boolean isCloseOnSendingError() {
        return ((HttpProtocolAdapter)super.getHandler()).isCloseOnSendingError();
    }

    public void setMaxTransactions(int maxTransactions) {
        ((HttpProtocolAdapter)this.getHandler()).setMaxTransactions(maxTransactions);
    }

    public int getMaxTransactions() {
        return ((HttpProtocolAdapter)this.getHandler()).getMaxTransactions();
    }

    public void setSessionManager(ISessionManager sessionManager) {
        ((HttpProtocolAdapter)this.getHandler()).setSessionManager(sessionManager);
    }

    public void setUsingCookies(boolean useCookies) {
        ((HttpProtocolAdapter)this.getHandler()).setUsingCookies(useCookies);
    }

    public boolean isUsingCookies() {
        return ((HttpProtocolAdapter)this.getHandler()).isUsingCookies();
    }

    public ISessionManager getSessionManager() {
        return ((HttpProtocolAdapter)this.getHandler()).getSessionManager();
    }
}

