/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class SmartExceptionFilterLogger {
    private static final long RESET_INTERVAL = 600000L;
    private static final long LOG_MSG_INTERVAL = 10000L;
    private static SmartExceptionFilterLogger _instance;
    private final Map<String, LogData> _exceptionsLogged = new HashMap<String, LogData>();
    private long _lastListResetTime = 0L;

    public static synchronized SmartExceptionFilterLogger getDefault() {
        if (_instance == null) {
            _instance = new SmartExceptionFilterLogger();
        }
        return _instance;
    }

    public void log(Class sourceClass, Exception ex) {
        String msg;
        LogData logData;
        long millis = System.currentTimeMillis();
        if (millis - this._lastListResetTime > 600000L) {
            this._exceptionsLogged.clear();
            this._lastListResetTime = millis;
        }
        if ((logData = this._exceptionsLogged.get(msg = ex.toString())) == null) {
            Exceptions.printStackTrace((Throwable)ex);
            this._exceptionsLogged.put(msg, new LogData(millis));
        } else {
            int logCount = logData.getCount();
            if (millis - logData.getLastLogTime() > 10000L) {
                if (logCount > 1) {
                    msg = msg + " (" + logCount + ")";
                }
                Logger.getLogger(sourceClass.getName()).severe(msg);
                logData.setCount(0);
                logData.setLastLogTime(millis);
            } else {
                logData.setCount(logCount + 1);
            }
        }
    }

    private static class LogData {
        private long _lastLogTime = 0L;
        private int _count = 0;

        public LogData(long time) {
            this._lastLogTime = time;
        }

        public long getLastLogTime() {
            return this._lastLogTime;
        }

        public void setLastLogTime(long lastLogTime) {
            this._lastLogTime = lastLogTime;
        }

        public void setCount(int count) {
            this._count = count;
        }

        public int getCount() {
            return this._count;
        }
    }
}

