/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.PainterAware;

public class JRendererCheckBox
extends JCheckBox
implements PainterAware {
    protected Painter painter;

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        Painter old = this.getPainter();
        this.painter = painter;
        if (painter != null) {
            this.setContentAreaFilled(false);
        }
        this.firePropertyChange("painter", old, this.getPainter());
    }

    public boolean isOpaque() {
        return this.painter == null;
    }

    public void setToolTipText(String text) {
        this.putClientProperty("ToolTipText", text);
    }

    protected void paintComponent(Graphics g) {
        if (this.painter != null) {
            this.paintComponentWithPainter((Graphics2D)g);
        } else {
            super.paintComponent(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintPainter(Graphics g) {
        Graphics2D scratch = (Graphics2D)g.create();
        try {
            this.painter.paint(scratch, this, this.getWidth(), this.getHeight());
        }
        finally {
            scratch.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponentWithPainter(Graphics2D g) {
        if (this.ui != null) {
            Graphics scratchGraphics = g.create();
            try {
                scratchGraphics.setColor(this.getBackground());
                scratchGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintPainter(g);
                this.ui.paint(scratchGraphics, this);
            }
            finally {
                scratchGraphics.dispose();
            }
        }
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("text".equals(propertyName)) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

